/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ccrc;

import com.ibm.rational.clearcase.ui.util.CcProviderFactory;
import com.ibm.rational.wvcm.stp.StpProvider;
import com.ibm.rational.wvcm.stp.cc.CcProvider;
import com.ibm.rational.wvcm.stp.cc.CcView;
import com.ibm.rational.wvcm.stp.cc.CcViewTag;
import com.smartbear.beans.IAskUser;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.NullAskUser;
import com.smartbear.beans.ScmOptions;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.ResourceScmClientConfigurationWrapper;
import com.smartbear.collaborator.team.scm.IResourceScmClientConfigurationFactory;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.ScmUtils;
import com.smartbear.scm.impl.clearcase.ClearCaseSystem;
import java.io.File;
import java.util.List;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ProviderFactory;
import javax.wvcm.WvcmException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;

public class CcrcConfigFactory
implements IResourceScmClientConfigurationFactory {
    public IResourceScmClientConfiguration getClientConfiguration(RepositoryProvider provider, IProgressMonitor monitor) throws ScmConfigurationException {
        IScmClientConfiguration clientConfig;
        File checkout = null;
        IProject project = provider.getProject();
        IPath projectLocation = null;
        if (project != null && (projectLocation = project.getLocation()) != null) {
            checkout = projectLocation.toFile();
        }
        CcProviderFactory ccProviderFactory = CcProviderFactory.getProviderFactory();
        List views = ccProviderFactory.getViews();
        CcView projectView = null;
        if (projectLocation != null) {
            for (CcView viewFromList : views) {
                PropertyRequestItem.PropertyRequest request = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CcView.VIEW_TYPE, CcView.FILE_AREA_ROOT_DIRECTORY});
                CcView view = null;
                try {
                    view = (CcView)viewFromList.doReadProperties((Feedback)request);
                    if (!view.getViewType().equals((Object)CcViewTag.ViewType.WEB) || !Path.fromOSString((String)view.getFileAreaRootDirectory().getPath()).isPrefixOf(projectLocation)) continue;
                    projectView = view;
                    break;
                }
                catch (WvcmException e) {
                    e.printStackTrace();
                }
            }
        }
        if (checkout != null && projectView != null) {
            CcProvider ccProvider = projectView.ccProvider();
            ProviderFactory.Callback.Authentication auth = ccProvider.getAuthentication(StpProvider.Domain.CLEAR_CASE, ccProvider.getServerUrl());
            if (auth == null) {
                throw new ScmConfigurationException("Please make sure the ClearCase View is connected.");
            }
            ScmOptions options = new ScmOptions();
            options.setCcrcServerUrl(ccProvider.getServerUrl());
            options.setCcrcUser(auth.loginName());
            options.setCcrcPasswd(auth.password());
            clientConfig = ClearCaseSystem.INSTANCE.getClientConfiguration(checkout, (IScmOptions)options, (IAskUser)NullAskUser.INSTANCE, monitor);
            if (clientConfig == null) {
                throw new ScmConfigurationException("Could not get ClearCase configuration for " + checkout);
            }
        } else {
            clientConfig = ScmUtils.requireScm((IScmSystem)ClearCaseSystem.INSTANCE, (IScmOptions)new ScmOptions(), (IAskUser)NullAskUser.INSTANCE, (IProgressMonitor)monitor);
        }
        ResourceScmClientConfigurationWrapper resourceClientConfig = new ResourceScmClientConfigurationWrapper(clientConfig);
        return resourceClientConfig;
    }
}

