/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.accurev;

import com.smartbear.beans.IAskUser;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.NullAskUser;
import com.smartbear.beans.ScmOptions;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.ResourceScmClientConfigurationWrapper;
import com.smartbear.collaborator.team.scm.IResourceScmClientConfigurationFactory;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.accurev.AccuRevSystem;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;

public class AccuRevClientConfigFactory
implements IResourceScmClientConfigurationFactory {
    public IResourceScmClientConfiguration getClientConfiguration(final RepositoryProvider provider, IProgressMonitor monitor) throws ScmConfigurationException {
        final ClosureReturn clientConfig = new ClosureReturn();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AccuRevSystem scm = AccuRevSystem.INSTANCE;
                    File file = provider.getProject().getLocation().toFile();
                    IScmOptions options = ScmOptions.create((String)"accurev");
                    try {
                        clientConfig.set((Object)new ResourceScmClientConfigurationWrapper(scm.getClientConfiguration(file, options, (IAskUser)NullAskUser.INSTANCE, monitor)));
                    }
                    catch (ScmConfigurationException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ScmConfigurationException) {
                throw (ScmConfigurationException)e.getCause();
            }
            throw new ScmConfigurationException("Could not get SCM configuration for provider '" + provider + "'", e.getCause());
        }
        catch (InterruptedException e) {
            throw new ScmConfigurationException("Could not get SCM configuration for provider '" + provider + "'", e.getCause());
        }
        return (IResourceScmClientConfiguration)clientConfig.get();
    }
}

