/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.ccollab.datamodel.client.ActionItemType;
import com.smartbear.ccollab.datamodel.client.IActionItem;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ErrorUI;
import com.smartbear.collaborator.ui.Messages;
import com.smartbear.jface.CollectionContentProvider;
import com.smartbear.jface.IOpenListener2;
import com.smartbear.jface.ITableLabelProvider2;
import com.smartbear.jface.LabelProvider2;
import com.smartbear.jface.TableViewer2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ActionItemsBlock<A extends IActionItem>
extends Composite {
    private StackLayout stackLayout;
    private Composite errorComposite;
    private ErrorUI errorUI;
    private Table table;
    private TableViewer2<List<? extends A>, A> viewer;

    public ActionItemsBlock(Composite parent) {
        this(parent, null);
    }

    public ActionItemsBlock(Composite parent, Runnable errorRetry) {
        super(parent, 0);
        this.initialize(errorRetry);
    }

    private void initialize(final Runnable errorRetry) {
        this.stackLayout = new StackLayout();
        this.setLayout((Layout)this.stackLayout);
        if (errorRetry != null) {
            this.errorComposite = new Composite((Composite)this, 0);
            this.errorComposite.setLayout((Layout)new GridLayout());
            this.errorUI = new ErrorUI(this.errorComposite);
            this.errorUI.setLayoutData(new GridData(0x1000000, 0x1000000, true, true));
            Button retryButton = new Button(this.errorComposite, 8);
            retryButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            retryButton.setText("Retry");
            retryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    errorRetry.run();
                }
            });
        } else {
            this.errorUI = new ErrorUI(this);
            this.errorComposite = this.errorUI;
        }
        this.table = new Table((Composite)this, 66052);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        TableColumn c = new TableColumn(this.table, 0);
        c.setText(Messages.getString("ActionItemsView.taskColumn"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200));
        c = new TableColumn(this.table, 0);
        c.setText(Messages.getString("ActionItemsView.reviewColumn"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200));
        c = new TableColumn(this.table, 0);
        c.setText("Role");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        TableViewer2 tableViewer = TableViewer2.create(this.table);
        tableViewer.setContentProvider(CollectionContentProvider.getInstance());
        tableViewer.setLabelProvider(new ItemLabelProvider());
        this.viewer = tableViewer;
    }

    public synchronized void setActionItems(List<? extends A> actionItems) {
        if (this.viewer != null && this.viewer.getContentProvider() != null) {
            ArrayList<? extends A> modifiableActionItems = new ArrayList<A>(actionItems);
            Collections.sort(modifiableActionItems);
            this.viewer.setInput(modifiableActionItems);
        }
        if (this.stackLayout.topControl != this.table) {
            this.stackLayout.topControl = this.table;
            if (!this.isDisposed()) {
                this.layout();
            }
        }
    }

    public synchronized void setError(String message, Throwable throwable) {
        this.errorUI.setError(message, throwable);
        if (this.stackLayout.topControl != this.errorComposite) {
            this.stackLayout.topControl = this.errorComposite;
            this.layout();
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer.getInner();
    }

    public void addOpenListener(IOpenListener2<A> listener) {
        if (this.viewer != null) {
            this.viewer.addOpenListener(listener);
        }
    }

    private static class ItemLabelProvider
    extends LabelProvider2<IActionItem>
    implements ITableLabelProvider2<IActionItem> {
        private ItemLabelProvider() {
        }

        @Override
        public String getColumnText(IActionItem item, int index) {
            switch (index) {
                case 0: {
                    return item.getNextActionText();
                }
                case 1: {
                    return item.getReviewText();
                }
                case 2: {
                    return item.getRoleText();
                }
            }
            return "";
        }

        @Override
        public Image getColumnImage(IActionItem item, int index) {
            switch (index) {
                case 0: {
                    if (JsonAPIHandler.isUserActionRequired((ActionItemType)item.getType())) {
                        return CollaboratorUI.getImage("IMG_IMPORTANT_TASK");
                    }
                    return CollaboratorUI.getImage("IMG_TASK");
                }
                case 1: {
                    return null;
                }
            }
            return null;
        }
    }
}

