/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.google.common.collect.ImmutableSet;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import java.util.Set;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;

public class ActivityListener
implements Listener,
SelectionListener,
KeyListener,
MouseListener,
MouseWheelListener,
TraverseListener,
FocusListener,
IExpansionListener,
ISelectionChangedListener,
IViewportListener {
    private static final Set<Integer> SWT_EVENTS = ImmutableSet.of((Object)2, (Object)1, (Object)3, (Object)4, (Object)8, (Object)37, (Object[])new Integer[]{13, 14});
    private final ClientModelRefreshJob refreshJob;

    public ActivityListener(ClientModelRefreshJob refreshJob) {
        this.refreshJob = refreshJob;
    }

    public void hook(Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        for (Integer swtEvent : SWT_EVENTS) {
            widget.addListener(swtEvent.intValue(), (Listener)this);
        }
        if (widget instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)widget;
            this.hook((Widget)scrollable.getVerticalBar());
            this.hook((Widget)scrollable.getHorizontalBar());
        }
    }

    public void registerActivity() {
        if (this.refreshJob != null) {
            this.refreshJob.registerActivity();
        }
    }

    public void handleEvent(Event event) {
        this.registerActivity();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.registerActivity();
    }

    public void widgetSelected(SelectionEvent e) {
        this.registerActivity();
    }

    public void keyPressed(KeyEvent e) {
        this.registerActivity();
    }

    public void keyReleased(KeyEvent e) {
        this.registerActivity();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.registerActivity();
    }

    public void mouseDown(MouseEvent e) {
        this.registerActivity();
    }

    public void mouseUp(MouseEvent e) {
        this.registerActivity();
    }

    public void mouseScrolled(MouseEvent e) {
        this.registerActivity();
    }

    public void keyTraversed(TraverseEvent e) {
        this.registerActivity();
    }

    public void focusGained(FocusEvent e) {
        this.registerActivity();
    }

    public void focusLost(FocusEvent e) {
        this.registerActivity();
    }

    public void expansionStateChanged(ExpansionEvent e) {
        this.registerActivity();
    }

    public void expansionStateChanging(ExpansionEvent e) {
        this.registerActivity();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.registerActivity();
    }

    public void viewportChanged(int verticalOffset) {
        this.registerActivity();
    }
}

