/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.ccollab.datamodel.client.IAutomaticLink;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.CompositeStyledTextDecorator;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.swt.text.RegexStyledTextDecorator;
import java.util.Collections;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;

public class AutomaticLinkStyledTextDecorator
extends RegexStyledTextDecorator
implements IStyledTextDecorator {
    private final IAutomaticLink autoLink;
    private final IWorkbenchSite site;

    public AutomaticLinkStyledTextDecorator(IAutomaticLink autoLink, IWorkbenchSite site) {
        super(Pattern.compile(autoLink.getRegex(), autoLink.isCaseSensitive() ? 0 : 2));
        this.autoLink = autoLink;
        this.site = site;
    }

    @Override
    protected void decorate(StyledText text, MatchResult matchResult) {
        Matcher newMatcher = this.getPattern().matcher(matchResult.group());
        final String url = newMatcher.replaceAll(this.autoLink.getUrlFormat());
        String toolTip = newMatcher.replaceAll(this.autoLink.getTooltip());
        SwtUtils.addLink(text, matchResult.start(), matchResult.end(), toolTip, new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUIUtils.executeCommand((IServiceLocator)AutomaticLinkStyledTextDecorator.this.site, "org.eclipse.ui.browser.openBrowser", Collections.singletonMap("url", url), null);
                }
                catch (ExecutionException e) {
                    CollaboratorUI.log("Error launching browser", e);
                }
            }
        });
    }

    public static IStyledTextDecorator create(List<? extends IAutomaticLink> autoLinks, IWorkbenchSite site) {
        CompositeStyledTextDecorator decorator = new CompositeStyledTextDecorator();
        for (IAutomaticLink iAutomaticLink : autoLinks) {
            decorator.add(new AutomaticLinkStyledTextDecorator(iAutomaticLink, site));
        }
        return decorator;
    }
}

