/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ErrorUI;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class CollaboratorErrorDialog
extends ErrorDialog {
    private static final String SAVE_LOG_LINK_PROMPT = "To get help with this problem, <a>save the error log</a> and send it to " + Product.current.getProductSupportEmail() + " along with a detailed description of what you were doing when the problem occurred.";
    private final boolean link;
    private final boolean saveLog;
    private final Throwable tbl;

    public CollaboratorErrorDialog(Shell shell, String error, Throwable tbl, boolean link, boolean saveLog) {
        super(shell, CollaboratorUI.PRODUCT_NAME + " Error", error, CollaboratorErrorDialog.toStatus(error, tbl), 7);
        this.tbl = tbl;
        this.link = link;
        this.saveLog = saveLog;
    }

    protected Point getInitialSize() {
        Shell shell = this.getShell();
        return shell.computeSize(shell.getMonitor().getClientArea().width / 2, -1, true);
    }

    protected Control createDialogArea(Composite composite) {
        Composite dialogArea = (Composite)super.createDialogArea(composite);
        if (this.tbl != null && this.link && Collaborator.isConfigError((Throwable)this.tbl) || this.saveLog) {
            Composite linksComposite = new Composite(dialogArea, 0);
            GridLayout linksLayout = new GridLayout();
            linksLayout.marginHeight = 0;
            linksLayout.marginWidth = 0;
            linksComposite.setLayout((Layout)linksLayout);
            GridData linksLayoutData = new GridData(-1, -1, true, true);
            linksLayoutData.horizontalSpan = 2;
            linksComposite.setLayoutData((Object)linksLayoutData);
            if (this.tbl != null && this.link && Collaborator.isConfigError((Throwable)this.tbl)) {
                ErrorUI.createPrefsLink(linksComposite);
            }
            if (this.saveLog) {
                Link saveLogLink = new Link(linksComposite, 0);
                saveLogLink.setLayoutData((Object)new GridData(-1, -1, true, false));
                saveLogLink.setText(SAVE_LOG_LINK_PROMPT);
                saveLogLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ErrorUI.saveDebugLog(CollaboratorErrorDialog.this.getShell());
                    }
                });
            }
        }
        return dialogArea;
    }

    private static IStatus toStatus(String error, Throwable tbl) {
        if (tbl instanceof CoreException) {
            return ((CoreException)tbl).getStatus();
        }
        String statusMessage = tbl != null ? StringUtils.defaultString((String)tbl.getMessage(), (String)tbl.toString()) : error;
        return new Status(4, "com.smartbear.collaborator.ui", 0, StringUtils.defaultString((String)statusMessage, (String)"Unspecified error"), null);
    }
}

