/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.CollabClientRuntimeException;
import com.smartbear.beans.IGlobalOptions;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.service.api.v7001.ServiceException;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientInvalidInputException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.review.request.CommitDatabaseRequest;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.json.utils.JsonUtils;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.ui.CollaboratorErrorDialog;
import com.smartbear.collaborator.ui.debug.DebugWindow;
import com.smartbear.collaborator.ui.preferences.ICollaboratorPreferencesHelper;
import com.smartbear.collaborator.ui.preferences.PreferencesDialogSettings;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.util.Strings;
import com.smartbear.util.commons.ArrayUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.Bundle;

public class CollaboratorUI {
    public static String PRODUCT_NAME = Product.current.getProductName();
    public static final String ID = "com.smartbear.collaborator.ui";
    public static final String PERSPECTIVE_ID = "com.smartbear.collaborator.ui.collabPerspective";
    public static final String COMMAND_OPEN_BROWSER = "org.eclipse.ui.browser.openBrowser";
    public static final String COMMAND_OPEN_BROWSER_PARAM_URL = "url";
    public static final String COMMAND_OPEN_BROWSER_PARAM_BROWSER_ID = "browserId";
    public static final String COMMAND_ADD_TO_REVIEW_ID = "com.smartbear.collaborator.ui.commands.AddToReview";
    public static final String COMMAND_OPEN_REVIEW_ID = "com.smartbear.collaborator.ui.commands.OpenReview";
    public static final String COMMAND_OPEN_REVIEW_PARAM_REVIEW_ID = "com.smartbear.collaborator.ui.commands.OpenReview_ReviewId";
    public static final String COMMAND_OPEN_REVIEW_FILE_ID = "com.smartbear.collaborator.ui.commands.OpenReviewFile";
    private static String DEBUG_WINDOW_PARENT_TITLE = "IDE";
    private static CollaboratorUI instance;
    private DebugWindow debugWindow;
    private ImageRegistry imageRegistry = new ImageRegistry();
    private static PreferencesDialogSettings dialogSettings;
    private static boolean debugging;
    private static final Comparator<Shell> SHELL_COMPARATOR;
    private static final String PREFERENCE_PAGES_EXTENSION_POINT = "preferencePages";
    private static final String CLASS_ATTRIBUTE = "class";
    private static ICollaboratorPreferencesHelper prefsHelper;

    private CollaboratorUI() {
        CollaboratorUI.initializeImageRegistry(this.imageRegistry);
    }

    private static CollaboratorUI getInstance() {
        if (instance == null) {
            instance = new CollaboratorUI();
        }
        return instance;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return CollaboratorUI.getInstance().imageRegistry.getDescriptor(key);
    }

    private static void initializeImageRegistry(ImageRegistry reg) {
        Bundle bundle = Platform.getBundle((String)ID);
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_REFRESH_ENABLED", "icons/elcl16/refresh.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_REFRESH_DISABLED", "icons/dlcl16/refresh.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_EXPAND_ALL", "icons/clcl16/expandall.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_COLLAPSE_ALL", "icons/elcl16/collapseall.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_TASK", "icons/obj16/aitem_obj.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_IMPORTANT_TASK", "icons/obj16/aitemi_obj.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_NEW_REVIEW_WIZARD", "icons/wizban/newrev_wiz.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_EXISTING_REVIEW_WIZARD", "icons/wizban/addrev_wiz.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_COLLAB_LOGO_16", "icons/logo16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_COLLAB_LOGO_24", "icons/logo24.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_COLLAB_LOGO_32", "icons/logo32.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_COLLAB_LOGO_48", "icons/logo48.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_USER", "icons/other/user1.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_USER_ADD", "icons/other/user1_add.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_USER_NEW", "icons/other/user1_new.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_USER_ACTIVE", "icons/other/user1_view.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_USER_WAITING", "icons/other/user1_time.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_USER_FINISHED", "icons/other/user1_preferences.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_REVIEW_POOL", "icons/other/icon_user_group.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_COMMENT_UNREAD", "icons/other/message_yellow-16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_COMMENT", "icons/other/message-16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_ACCEPTED", "icons/other/check2-16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_DEFECT_OPEN", "icons/other/bug_red-16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_DEFECT_FIXED", "icons/other/bug_green_checked-16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_DEFECT_REJECT", "icons/other/bug_gray-16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_DEFECT_EXTERNALIZED", "icons/other/bug_green_arrow_blue-16.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_REJECT", "icons/other/reject.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_WEB", "icons/other/web.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_SCM_MATERIALS", "icons/obj16/repository.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CHANGELIST", "icons/obj16/changeset_obj.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_SCM_CONSOLIDATION_METHOD", "icons/obj16/changeset_obj.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CHILDREN_STYLE", "icons/other/hierarchical.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CONVO_PIN_SELECTED", "icons/other/pin_blue_plain-32.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CONVO_PIN_READ", "icons/other/pin_grey_plain-32.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CONVO_PIN_UNREAD", "icons/other/pin_yellow_plain-32.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CONVO_PIN_DEFECT_OPEN", "icons/other/pin_red_plain-32.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CONVO_PIN_DEFECT_RESOLVED", "icons/other/pin_green_plain-32.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_ADDING_ARROW_OVERLAY", "icons/ovr16/inadd_ov.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_CHANGED_ARROW_OVERLAY", "icons/ovr16/inchg_ov.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_DELETED_ARROW_OVERLAY", "icons/ovr16/indel_ov.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_REVERTED_ARROW_OVERLAY", "icons/ovr16/inrev_ov.gif");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_ADDED_OVERLAY", "icons/other/added_overlay.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_INCLUDED_OVERLAY", "icons/other/added_overlay.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_DELETED_OVERLAY", "icons/other/deleted_overlay.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_EXCLUDED_OVERLAY", "icons/other/deleted_overlay.png");
        CollaboratorUI.addToImageRegistry(reg, bundle, "IMG_REVERTED_OVERLAY", "icons/other/reverted_overlay.png");
    }

    private static void addToImageRegistry(ImageRegistry reg, Bundle bundle, String key, String bundleEntry) {
        reg.put(key, ImageDescriptor.createFromURL((URL)bundle.getEntry(bundleEntry)));
    }

    public static Image getImage(String key) {
        return CollaboratorUI.getInstance().imageRegistry.get(key);
    }

    public static Image[] getLogoIcons() {
        return new Image[]{CollaboratorUI.getImage("IMG_COLLAB_LOGO_16"), CollaboratorUI.getImage("IMG_COLLAB_LOGO_24"), CollaboratorUI.getImage("IMG_COLLAB_LOGO_32"), CollaboratorUI.getImage("IMG_COLLAB_LOGO_48")};
    }

    public static IDialogSettings getDialogSettings() {
        if (dialogSettings == null) {
            dialogSettings = new PreferencesDialogSettings(PrefsHelper.getEclipsePrefsNode().node("dialogSettings"));
        }
        return dialogSettings;
    }

    public static DebugWindow createDebugWindow(Shell launcherShell) {
        Shell parentShell = launcherShell.getParent() == null ? launcherShell : launcherShell.getParent().getShell();
        CollaboratorUI.getInstance().debugWindow = new DebugWindow(parentShell, DEBUG_WINDOW_PARENT_TITLE, false);
        return CollaboratorUI.getInstance().debugWindow;
    }

    public static DebugWindow getDebugWindow() {
        return CollaboratorUI.getInstance().debugWindow;
    }

    public static IDialogSettings getDialogSettingsSection(IDialogSettings parent, String sectionName) {
        IDialogSettings section;
        if (parent != null) {
            section = parent.getSection(sectionName);
            if (section == null) {
                section = parent.addNewSection(sectionName);
            }
        } else {
            section = null;
        }
        return section;
    }

    public static void saveDialogSettings() {
        if (dialogSettings != null) {
            dialogSettings.save();
        }
    }

    public static void log(String message, Throwable e) {
        CollaboratorUI.log((IStatus)new Status(4, ID, 0, message, e));
    }

    public static void log(IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)ID)).log(status);
        if (CollaboratorUI.isDebugging()) {
            System.err.println("Collaborator Status: " + status.toString());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
    }

    public static void openError(final Shell shell, final String message, final Throwable tbl, final boolean link, final boolean saveLog) {
        CollaboratorUI.log(message, tbl);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new CollaboratorErrorDialog(shell, message, tbl, link, saveLog).open();
            }
        });
    }

    public static void openWarning(final Shell shell, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)(PRODUCT_NAME + " Warning"), (String)message);
            }
        });
    }

    public static boolean isDebugging() {
        return debugging;
    }

    public static Shell getShell() {
        final Display display = Display.getDefault();
        final ClosureReturn shell = new ClosureReturn();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = display.getActiveShell();
                if (activeShell != null) {
                    shell.set((Object)activeShell);
                    return;
                }
                LinkedList<Shell> shells = new LinkedList<Shell>(Arrays.asList(display.getShells()));
                Collections.sort(shells, SHELL_COMPARATOR);
                shell.set((Object)((Shell)shells.get(0)));
            }
        });
        return (Shell)shell.get();
    }

    public static ICollaboratorPreferencesHelper getPrefsHelper() {
        if (prefsHelper == null) {
            Object[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ID, PREFERENCE_PAGES_EXTENSION_POINT);
            if (ArrayUtils.isEmpty((Object[])configElements)) {
                CollaboratorUI.log("Could not get preferences helper - No preferencePages extension registered", null);
                return null;
            }
            Object configElement = configElements[0];
            if (configElements.length > 1) {
                String guessConfigElementId = Collaborator.isRunningIDE() ? "com.smartbear.collaborator.ui.ide.preferencePages" : "com.smartbear.collaborator.ui.standalone.preferencePages";
                Object[] guessConfigElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ID, PREFERENCE_PAGES_EXTENSION_POINT, guessConfigElementId);
                if (!ArrayUtils.isEmpty((Object[])guessConfigElements)) {
                    configElement = guessConfigElements[0];
                }
                CollaboratorUI.log("Warning: More than one preferences helper registered!  Choosing: " + configElement.getDeclaringExtension().getLabel(), null);
            }
            try {
                prefsHelper = (ICollaboratorPreferencesHelper)configElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                Collaborator.log((String)"Could not load Preferences helper from extension point", (Throwable)e);
            }
        }
        return prefsHelper;
    }

    public static int openPreferencesDialog(String pageId, Shell shell, boolean blockOnOpen) {
        ICollaboratorPreferencesHelper prefsHelper = CollaboratorUI.getPrefsHelper();
        PreferenceDialog prefsDialog = new PreferenceDialog(shell, prefsHelper.getPreferenceManager());
        prefsDialog.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.smartbear.collaborator"));
        if (!StringUtils.isEmpty((String)pageId)) {
            prefsDialog.setSelectedNode(pageId);
        }
        prefsDialog.setBlockOnOpen(blockOnOpen);
        return prefsDialog.open();
    }

    public static boolean executeServerCommands(List<? extends Command> commands, IProgressMonitor monitor) {
        int totalWork = commands.size() + 1 + 1;
        monitor.beginTask("Executing server commands", totalWork);
        UserInfo userInfo = null;
        IGlobalOptions options = Collaborator.getOptions();
        try {
            monitor.subTask("Logging into " + Product.current.getProductName());
            userInfo = Collaborator.jsonLogin();
        }
        catch (CollabClientRuntimeException e) {
            CollaboratorUI.openError(CollaboratorUI.getShell(), "Error logging in", e, true, true);
            monitor.done();
            return false;
        }
        monitor.worked(1);
        ScmOptions scmOptions = new ScmOptions();
        try {
            boolean aborted = false;
            try {
                for (Command command : commands) {
                    Collaborator.executeJson((Command)command, (UserInfo)userInfo, (IScmOptions)scmOptions, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            catch (Throwable tbl) {
                aborted = true;
                CollaboratorUI.log("Error running commands " + commands, tbl);
                throw tbl;
            }
            finally {
                JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
                CollaboratorJsonApi collaboratorJsonApi = jsonBatchCommand.getCollaboratorJsonApi();
                CommitDatabaseRequest request = (CommitDatabaseRequest)JsonUtils.create(CommitDatabaseRequest.class);
                request.setAborted(Boolean.valueOf(aborted));
                collaboratorJsonApi.reviewApi().utilitiesApi().saveAllandClose(request);
                monitor.worked(1);
                monitor.done();
                monitor.done();
            }
            return true;
        }
        catch (OperationCanceledException e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)e.getMessage(), (String)"Operation canceled."));
                }
            });
        }
        catch (CollabClientInvalidInputException e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)CollaboratorUI.getShell(), (String)"Action not allowed", (String)e.getMessage());
                }
            });
        }
        catch (ServiceException e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)CollaboratorUI.getShell(), (String)Product.current.getProductName(), (String)e.getMessage());
                }
            });
        }
        catch (Throwable e) {
            CollaboratorUI.openError(CollaboratorUI.getShell(), "Error", e, false, true);
        }
        return false;
    }

    public static void executeServerCommands(final List<? extends Command> commands, IWorkbenchSite site, boolean async) {
        try {
            if (async) {
                Job job = new Job("Updating server"){

                    protected IStatus run(IProgressMonitor monitor) {
                        CollaboratorUI.executeServerCommands(commands, monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.setPriority(10);
                job.schedule();
            } else {
                IProgressService progressService = null;
                if (site != null) {
                    progressService = (IProgressService)site.getService(IProgressService.class);
                }
                if (progressService == null) {
                    progressService = PlatformUI.getWorkbench().getProgressService();
                }
                progressService.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        CollaboratorUI.executeServerCommands(commands, monitor);
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            CollaboratorUI.openError(CollaboratorUI.getShell(), "Error running commands", e.getTargetException(), false, true);
        }
        catch (InterruptedException e) {
            CollaboratorUI.log("Interrupted running commands: " + commands, e);
        }
    }

    static {
        debugging = Boolean.valueOf(Platform.getDebugOption((String)"com.smartbear.collaborator.ui/debug"));
        SHELL_COMPARATOR = new Comparator<Shell>(){
            static final int FIRST_ARG_BETTER = 1;
            static final int SECOND_ARG_BETTER = -1;

            @Override
            public int compare(Shell s1, Shell s2) {
                if (!s1.isDisposed() && s2.isDisposed()) {
                    return 1;
                }
                if (s1.isDisposed() && !s2.isDisposed()) {
                    return -1;
                }
                if (s1.isFocusControl() && !s2.isFocusControl()) {
                    return 1;
                }
                if (!s1.isFocusControl() && s2.isFocusControl()) {
                    return -1;
                }
                if (s1.isEnabled() && !s2.isEnabled()) {
                    return 1;
                }
                if (!s1.isEnabled() && s2.isEnabled()) {
                    return -1;
                }
                if (s1.isVisible() && !s2.isVisible()) {
                    return 1;
                }
                if (!s1.isVisible() && s2.isVisible()) {
                    return -1;
                }
                return 0;
            }
        };
        prefsHelper = null;
    }
}

