/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.beans.ConfigUtils;
import com.smartbear.beans.IGlobalOptions;
import com.smartbear.ccollab.client.AuthorizationResponseInfo;
import com.smartbear.ccollab.client.ICollabClientInterface;
import com.smartbear.ccollab.datamodel.Engine;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ModalAskUser;
import com.smartbear.collaborator.ui.ssl.EclipseX509UserConfirmation;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.ScmChangeset;
import com.smartbear.scm.ScmMultiVersionChange;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.InputDialog;

public class EclipseClientInterface
implements ICollabClientInterface {
    private IGlobalOptions options;

    public void setOptions(IGlobalOptions options) {
        this.options = options;
    }

    public IGlobalOptions getOptions() {
        return this.options;
    }

    public String askUser(final String prompt, final String defaultValue) {
        final ClosureReturn response = ClosureReturn.create();
        CollaboratorUI.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                InputDialog dialog = new InputDialog(CollaboratorUI.getShell(), Product.current.getProductName(), prompt, defaultValue, null);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    response.set((Object)dialog.getValue());
                } else {
                    response.set(null);
                }
            }
        });
        if (response.get() == null) {
            throw new OperationCanceledException();
        }
        return (String)response.get();
    }

    public String askUserPassword(String prompt) {
        ModalAskUser m = new ModalAskUser(CollaboratorUI.getShell());
        return m.askPass(prompt);
    }

    public void handleAuthorizationResponse(AuthorizationResponseInfo authorizationResponseInfo) {
        String loginTicketId = Product.current.getCachedLoginTicketId();
        if (StringUtils.isNotBlank((String)loginTicketId)) {
            ConfigUtils.saveLoginTicketId((String)loginTicketId);
            ConfigUtils.clearPassword();
        }
    }

    public void logInfo(String message) {
        if (CollaboratorUI.isDebugging()) {
            CollaboratorUI.log((IStatus)new Status(1, "com.smartbear.collaborator.ui", 0, message, null));
        }
    }

    public void openReview(Engine engine, int reviewId) {
    }

    public void openReview(ReviewInfo reviewInfo) {
    }

    public Set<IScmLocalCheckout> selectFiles(IScmClientConfiguration clientConfig, Set<IScmLocalCheckout> initialFiles, IProgressMonitor monitor) throws CollabClientException {
        return initialFiles;
    }

    public ScmChangeset editChangelist(ScmMultiVersionChange changelist, IProgressMonitor monitor) throws CollabClientException {
        return null;
    }

    public boolean confirmCertificateChain(X509Certificate[] chain, String message) throws CertificateException {
        return new EclipseX509UserConfirmation().confirmCertificateChain(chain, message);
    }

    public String askUserMultiLine(String prompt, String defaultValue) throws CollabClientException {
        return defaultValue;
    }
}

