/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.progress.IOUtilsWithProgress;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.swt.RightSizeText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class ErrorUI
extends Composite {
    private static final String PREFS_LINK_PROMPT = "You may need to <a>go to the " + CollaboratorUI.PRODUCT_NAME + " Preferences</a> to fix this problem.";
    private Link prefsLink;
    private RightSizeText errorText;

    public ErrorUI(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.prefsLink = ErrorUI.createPrefsLink(this);
        this.errorText = new RightSizeText(this, 74);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        this.errorText.setLayoutData(gridData);
    }

    public void setError(String message, Throwable throwable) {
        if (this.isDisposed()) {
            return;
        }
        message = StringUtils.defaultString((String)message);
        if (Collaborator.isConfigError((Throwable)throwable)) {
            message = (String)message + "\n\n" + PREFS_LINK_PROMPT;
        }
        this.prefsLink.setText((String)message);
        Object errorDesc = "";
        if (throwable != null && throwable.getLocalizedMessage() != null) {
            errorDesc = "Error: " + throwable.getLocalizedMessage();
        }
        this.errorText.setText((String)errorDesc);
        this.errorText.setVisible(!((String)errorDesc).isEmpty());
        this.layout();
    }

    public static Link createPrefsLink(Composite parent) {
        Link prefsLink = new Link(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        prefsLink.setLayoutData((Object)gridData);
        prefsLink.setText(PREFS_LINK_PROMPT);
        final Shell shell = parent.getShell();
        prefsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CollaboratorUI.openPreferencesDialog("com.smartbear.collaborator.ui.ide.preferences.ServerConnectionPage", shell, false);
            }
        });
        return prefsLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDebugLog(Shell parentShell) {
        boolean bl;
        File logFile = Platform.getLogFileLocation().toFile();
        FileInputStream input = null;
        try {
            input = new FileInputStream(logFile);
            bl = ErrorUI.saveDebugLog(parentShell, input, "ccollab.log", null);
        }
        catch (FileNotFoundException ex) {
            boolean bl2;
            try {
                CollaboratorUI.log("Could not find log file", ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            return bl2;
        }
        IOUtils.closeQuietly((InputStream)input);
        return bl;
    }

    public static boolean saveDebugLog(Shell parentShell, final InputStream input, final String name, final List<File> extraFiles) {
        final FileDialog dialog = new FileDialog(parentShell, 8192);
        dialog.setText("Save Debugging Logs");
        if (extraFiles == null) {
            dialog.setFileName(name);
        } else {
            dialog.setFileName("ccollab-logs.zip");
        }
        if (dialog.open() == null || StringUtils.isBlank((String)dialog.getFileName())) {
            return false;
        }
        try {
            new ProgressMonitorDialog(parentShell).run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    FileOutputStream output;
                    block13: {
                        File file = new File(new File(dialog.getFilterPath()), dialog.getFileName());
                        output = null;
                        try {
                            file.createNewFile();
                            output = new FileOutputStream(file);
                            if (extraFiles == null) {
                                IOUtilsWithProgress.copy((InputStream)input, (OutputStream)output, (IProgressMonitor)monitor);
                                break block13;
                            }
                            monitor.beginTask("Saving logs", extraFiles.size() + 1);
                            ZipOutputStream zipOutput = null;
                            FileInputStream fileInput = null;
                            try {
                                zipOutput = new ZipOutputStream(output);
                                zipOutput.putNextEntry(new ZipEntry(name));
                                IOUtilsWithProgress.copy((InputStream)input, (OutputStream)zipOutput, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                zipOutput.closeEntry();
                                IteratorWithProgress itr = IteratorWithProgress.getIterator((Collection)extraFiles, (String)"Saving file", (IProgressMonitor)new SubProgressMonitor(monitor, extraFiles.size()));
                                while (itr.hasNext()) {
                                    File extraFile = (File)itr.next();
                                    try {
                                        fileInput = new FileInputStream(extraFile);
                                        zipOutput.putNextEntry(new ZipEntry(extraFile.getName()));
                                        IOUtilsWithProgress.copy((InputStream)fileInput, (OutputStream)zipOutput, (IProgressMonitor)itr.getIterationProgressMonitor());
                                        zipOutput.closeEntry();
                                    }
                                    catch (Throwable tbl) {
                                        try {
                                            Collaborator.log((String)("Error saving file " + extraFile.getName()), (Throwable)tbl);
                                        }
                                        catch (Throwable throwable) {
                                            IOUtils.closeQuietly(fileInput);
                                            throw throwable;
                                        }
                                        IOUtils.closeQuietly((InputStream)fileInput);
                                        continue;
                                    }
                                    IOUtils.closeQuietly((InputStream)fileInput);
                                }
                                zipOutput.close();
                            }
                            finally {
                                IOUtils.closeQuietly(fileInput);
                                IOUtils.closeQuietly((OutputStream)zipOutput);
                            }
                        }
                        catch (IOException ex) {
                            try {
                                throw new InvocationTargetException(ex);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(output);
                                throw throwable;
                            }
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)output);
                }
            });
            return true;
        }
        catch (InvocationTargetException ex) {
            CollaboratorUI.log("Error saving debug log files", ex.getTargetException());
        }
        catch (InterruptedException ex) {
            CollaboratorUI.log("Error saving debug log files", ex);
            Thread.currentThread().interrupt();
        }
        return false;
    }
}

