/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.AbstractExistingReviewCommand;
import com.smartbear.ccollab.client.commands.argrefs.IReviewRef;
import com.smartbear.ccollab.client.commands.argrefs.ReviewRefBySpec;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ICommandRunner;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchSite;

public class ReviewCommandRunner
implements ICommandRunner {
    private final int reviewId;
    private final IWorkbenchSite site;

    public ReviewCommandRunner(int reviewId, IWorkbenchSite site) {
        this.reviewId = reviewId;
        this.site = site;
    }

    @Override
    public void run(Command command, boolean async) {
        if (command instanceof AbstractExistingReviewCommand) {
            ((AbstractExistingReviewCommand)command).setReviewRef((IReviewRef)new ReviewRefBySpec(Integer.toString(this.reviewId)));
        }
        List<Command> commands = Arrays.asList(command, new Command(){

            protected void executeJson(IProgressMonitor monitor) throws CollabClientException {
                for (Job job : Job.getJobManager().find(ClientModelRefreshJob.getReviewFamily((int)ReviewCommandRunner.this.reviewId))) {
                    ClientModelRefreshJob reviewRelatedJob = (ClientModelRefreshJob)job;
                    reviewRelatedJob.registerActivity();
                    reviewRelatedJob.start();
                }
            }
        });
        CollaboratorUI.executeServerCommands(commands, this.site, async);
    }
}

