/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.smartbear.beans.IAskUser;
import com.smartbear.beans.IScmOptions;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.ScmUtils;
import com.smartbear.scm.impl.none.NoneSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScmConfig {
    private static final List<IScmSystem> DETECT_SCMS = new ArrayList<IScmSystem>(ScmUtils.SCMS);
    String name;
    private IScmOptions options;
    private IScmClientConfiguration clientConfigCache;

    public ScmConfig(IScmOptions options) {
        this.options = options;
    }

    public IScmOptions getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setOptions(IScmOptions options) {
        ScmConfig scmConfig = this;
        synchronized (scmConfig) {
            this.clientConfigCache = null;
        }
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScmSystem getScmSystem(IAskUser askUser, IProgressMonitor monitor) throws ScmConfigurationException {
        ScmConfig scmConfig = this;
        synchronized (scmConfig) {
            if (this.clientConfigCache != null) {
                return this.clientConfigCache.getScmSystem();
            }
        }
        if (StringUtils.isNotBlank((String)this.options.getScm())) {
            IScmSystem scmSystem = ScmUtils.getScmSystemFromToken((String)this.options.getScm());
            if (scmSystem == null) {
                throw new ScmConfigurationException("SCM option is invalid");
            }
            return scmSystem;
        }
        return this.getClientConfig(askUser, monitor).getScmSystem();
    }

    public synchronized IScmClientConfiguration getClientConfig(IAskUser askUser, IProgressMonitor monitor) throws ScmConfigurationException {
        if (this.clientConfigCache == null) {
            File currentDirectory = this.options.getCurrentDirectory();
            if (StringUtils.isBlank((String)this.options.getScm()) && currentDirectory == null) {
                throw new ScmConfigurationException("SCM Configuration must specify either an SCM system or a Local Path");
            }
            this.clientConfigCache = ScmUtils.requireScm((File)currentDirectory, (IScmOptions)this.options, (IAskUser)askUser, (IProgressMonitor)monitor, DETECT_SCMS);
            if (this.clientConfigCache == null) {
                throw new ScmConfigurationException("No SCM Configuration could be determined");
            }
        }
        return this.clientConfigCache;
    }

    static {
        DETECT_SCMS.add((IScmSystem)NoneSystem.INSTANCE);
    }
}

