/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.smartbear.beans.ConfigUtils;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.beans.ValidateBean;
import com.smartbear.beans.ValidateBeanUtils;
import com.smartbear.collaborator.ui.ScmConfig;
import com.smartbear.utils.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;

public class ScmConfigManager {
    private static final String PROFILES = "profiles";
    private final List<ScmConfig> scmConfigs;
    private static ListenerList listenerList = new ListenerList();

    public List<ScmConfig> getScmConfigs() {
        return this.scmConfigs;
    }

    private ScmConfigManager(List<ScmConfig> scmConfigs) {
        this.scmConfigs = scmConfigs;
    }

    public static ScmConfigManager load(IProgressMonitor monitor) throws IOException {
        File profilesDir = new File(ConfigUtils.getPreferenceDirectory(), PROFILES);
        if (!profilesDir.exists()) {
            ScmConfigManager manager = new ScmConfigManager(Lists.newArrayList());
            for (ScmConfig config : ScmConfigManager.loadLegacy()) {
                manager.add(config);
            }
            FileUtils.forceMkdir((File)profilesDir);
            return manager;
        }
        ArrayList configs = Lists.newArrayList();
        for (File configFile : profilesDir.listFiles((FilenameFilter)FileFilterUtils.suffixFileFilter((String)"options"))) {
            IScmOptions scmOptions = (IScmOptions)ConfigUtils.loadConfigFile((File)configFile).getB();
            ScmConfig config = new ScmConfig(scmOptions);
            config.name = FilenameUtils.getBaseName((String)configFile.getName());
            configs.add(config);
        }
        return new ScmConfigManager(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ScmConfig> loadLegacy() {
        File prefsFile = new File(ConfigUtils.getPreferenceDirectory(), "instance/.metadata/.plugins/org.eclipse.core.runtime/.settings/com.smartbear.collaborator.prefs");
        if (!prefsFile.isFile()) {
            return Collections.emptyList();
        }
        Properties prefs = new Properties();
        FileInputStream prefsStream = null;
        try {
            prefsStream = new FileInputStream(prefsFile);
            prefs.load(prefsStream);
        }
        catch (IOException e) {
            List<ScmConfig> list;
            try {
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(prefsStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)prefsStream);
            return list;
        }
        IOUtils.closeQuietly((InputStream)prefsStream);
        Pattern keyPattern = Pattern.compile("scmConfigs/(\\d+)/(.*)");
        HashMap configEntriesById = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : prefs.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher matcher = keyPattern.matcher(key);
            if (!matcher.matches()) continue;
            String prefId = matcher.group(1);
            String configKey = matcher.group(2);
            if (configKey.startsWith("Dialog Settings")) continue;
            if (!configEntriesById.containsKey(prefId)) {
                configEntriesById.put(prefId, Maps.newHashMap());
            }
            ((Map)configEntriesById.get(prefId)).put(configKey, value);
        }
        ArrayList configs = Lists.newArrayListWithExpectedSize((int)configEntriesById.size());
        for (Map configEntries : configEntriesById.values()) {
            ScmOptions options = new ScmOptions();
            ValidateBeanUtils.loadFromMapBestEffort((Map)configEntries, (ValidateBean)options);
            String path = (String)configEntries.get("path");
            if (StringUtils.isNotBlank((String)path)) {
                options.setCurrentDirectory(new File(path));
            }
            configs.add(new ScmConfig((IScmOptions)options));
        }
        return configs;
    }

    public void add(IScmOptions options) throws IOException {
        ScmConfig config = new ScmConfig(options);
        this.add(config);
    }

    private static File getFile(ScmConfig config) {
        return new File(new File(ConfigUtils.getPreferenceDirectory(), PROFILES), config.name + ".options");
    }

    public static File getDialogSettingsFile(ScmConfig config) {
        return new File(new File(ConfigUtils.getPreferenceDirectory(), PROFILES), config.name + ".dialogSettings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ScmConfig config) throws IOException {
        boolean isNew = false;
        if (config.name == null) {
            isNew = true;
            config.name = Hashing.getGuid();
        }
        Properties props = new Properties();
        try {
            ValidateBeanUtils.saveToMap((Map)props, (ValidateBean)((ScmOptions)config.getOptions()), (ValidateBean)new ScmOptions());
        }
        catch (GeneralSecurityException e) {
            throw new IOExceptionWithCause("Error encrypting password-type option", (Throwable)e);
        }
        File configFile = ScmConfigManager.getFile(config);
        FileUtils.forceMkdir((File)configFile.getParentFile());
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(configFile);
            FileLock lock = stream.getChannel().tryLock();
            if (lock == null) {
                throw new IOException(configFile + " is locked by another process");
            }
            props.store(stream, null);
        }
        catch (IOException e) {
            try {
                props.store(stream, null);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
        IOUtils.closeQuietly((OutputStream)stream);
        if (isNew) {
            this.scmConfigs.add(config);
        }
        this.notifyListeners();
    }

    public void remove(ScmConfig scmConfig) throws IOException {
        File dialogSettingsFile;
        File configFile = ScmConfigManager.getFile(scmConfig);
        if (configFile.exists()) {
            FileUtils.forceDelete((File)configFile);
        }
        if ((dialogSettingsFile = ScmConfigManager.getDialogSettingsFile(scmConfig)).exists()) {
            FileUtils.forceDelete((File)dialogSettingsFile);
        }
        this.scmConfigs.remove(scmConfig);
        this.notifyListeners();
    }

    private void notifyListeners() {
        List<ScmConfig> unmodifiableScmConfigs = Collections.unmodifiableList(this.scmConfigs);
        for (Object listener : listenerList.getListeners()) {
            ((IScmConfigsListener)listener).scmConfigsChanged(unmodifiableScmConfigs);
        }
    }

    public void addListener(IScmConfigsListener listener) {
        listenerList.add((Object)listener);
    }

    public void removeListener(IScmConfigsListener listener) {
        listenerList.remove((Object)listener);
    }

    public static interface IScmConfigsListener {
        public void scmConfigsChanged(List<ScmConfig> var1);
    }
}

