/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.changes;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmLocalCheckout;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ChangedAndRevertedLabelDecorator
implements ILabelDecorator {
    private static final ImageData ADDING_OVERLAY = CollaboratorUI.getImageDescriptor("IMG_ADDING_ARROW_OVERLAY").getImageData();
    private static final ImageData CHANGED_OVERLAY = CollaboratorUI.getImageDescriptor("IMG_CHANGED_ARROW_OVERLAY").getImageData();
    private static final ImageData DELETED_OVERLAY = CollaboratorUI.getImageDescriptor("IMG_DELETED_ARROW_OVERLAY").getImageData();
    private static final ImageData REVERTED_OVERLAY = CollaboratorUI.getImageDescriptor("IMG_REVERTED_ARROW_OVERLAY").getImageData();
    private Set<IScmLocalCheckout> revertedCheckouts;

    public ChangedAndRevertedLabelDecorator(Collection<? extends IScmLocalCheckout> revertedCheckouts) {
        this.revertedCheckouts = new HashSet<IScmLocalCheckout>(revertedCheckouts);
    }

    private static String getStateString(IScmCommitInfo.State state) {
        switch (state) {
            case ADDING: {
                return "adding";
            }
            case BRANCHING: {
                return "branching";
            }
            case CONTROLLED: {
                return "controlled";
            }
            case DELETING: {
                return "deleting";
            }
            case INTEGRATING: {
                return "modified";
            }
            case REVERTED: {
                return "reverted";
            }
            case UNCONTROLLED: {
                return "uncontrolled";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        throw new RuntimeException("Unrecognized File Revision state");
    }

    public Image decorateImage(Image image, Object element) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        return this.decorateImage(imageDescriptor, element).createImage();
    }

    public ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        ImageData overlayData;
        final ImageData inputData = input.getImageData();
        switch (this.getState(element)) {
            case ADDING: {
                overlayData = ADDING_OVERLAY;
                break;
            }
            case INTEGRATING: {
                overlayData = CHANGED_OVERLAY;
                break;
            }
            case DELETING: {
                overlayData = DELETED_OVERLAY;
                break;
            }
            case REVERTED: {
                overlayData = REVERTED_OVERLAY;
                break;
            }
            default: {
                overlayData = null;
            }
        }
        return new CompositeImageDescriptor(){

            protected Point getSize() {
                return new Point(inputData.width + 5, inputData.height);
            }

            protected void drawCompositeImage(int width, int height) {
                this.drawImage(inputData, 0, 0);
                if (overlayData != null) {
                    this.drawImage(overlayData, inputData.width - 5, inputData.height / 2 - overlayData.height / 2);
                }
            }
        };
    }

    public String decorateText(String text, Object element) {
        IScmCommitInfo.State state = this.getState(element);
        if (state == IScmCommitInfo.State.CONTROLLED || state == IScmCommitInfo.State.UNCONTROLLED || state == IScmCommitInfo.State.UNKNOWN) {
            return text;
        }
        return text + " (" + ChangedAndRevertedLabelDecorator.getStateString(state) + ")";
    }

    private IScmCommitInfo.State getState(Object element) {
        if (!(element instanceof IAdaptable)) {
            return IScmCommitInfo.State.UNKNOWN;
        }
        IAdaptable adaptable = (IAdaptable)element;
        IScmLocalCheckout checkout = (IScmLocalCheckout)adaptable.getAdapter(IScmLocalCheckout.class);
        if (checkout != null && this.revertedCheckouts.contains(checkout)) {
            return IScmCommitInfo.State.REVERTED;
        }
        IScmCommitInfo.State state = (IScmCommitInfo.State)adaptable.getAdapter(IScmCommitInfo.State.class);
        if (state == null) {
            state = IScmCommitInfo.State.UNKNOWN;
        } else if (state == IScmCommitInfo.State.CONTROLLED) {
            state = IScmCommitInfo.State.INTEGRATING;
        }
        return state;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

