/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.customfield;

import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.collaborator.ui.customfield.ICustomFieldWidget;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.HashSets;
import com.smartbear.util.ListenerList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCustomFieldWidget<F extends ICustomField, C extends Control>
implements ICustomFieldWidget {
    private final ListenerList<ICustomFieldWidget.ICustomFieldWidgetModifyListener> modifyListeners = new ListenerList();
    private final F customField;
    private final C control;
    private final ControlDecoration decoration;
    private String user;
    private Integer checklistItemId;
    private IReviewMovingOn reviewMovingOn;

    public AbstractCustomFieldWidget(F customField, C control) {
        this.customField = customField;
        this.control = control;
        this.decoration = new ControlDecoration(control, 16512);
        if (StringUtils.isNotEmpty((String)customField.getDescription())) {
            control.setToolTipText(SwtUtils.escapeMnemonics(customField.getDescription()));
        }
        this.updateDecoration(HashSets.emptyHashSet());
    }

    public final F getCustomField() {
        return this.customField;
    }

    public final C getControl() {
        return this.control;
    }

    private void updateDecoration(HashSet<String> value) {
        String errorMsg = "";
        boolean isPhaseMandatory = false;
        if (this.reviewMovingOn != null) {
            Phase currentPhase = this.reviewMovingOn.getPhase();
            HashSet mandatoryPhases = this.customField.getMandatoryPhases();
            boolean bl = isPhaseMandatory = mandatoryPhases == null ? false : mandatoryPhases.contains(currentPhase);
        }
        if (!value.isEmpty()) {
            errorMsg = this.customField.getErrorMessage(value, isPhaseMandatory, false);
        }
        if (StringUtils.isNotBlank((String)errorMsg)) {
            this.decoration.setDescriptionText(errorMsg);
            this.decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        } else {
            this.decoration.setDescriptionText(this.getCustomField().getDescription());
            this.decoration.setImage(null);
        }
    }

    @Override
    public void setReviewMovingOn(IReviewMovingOn reviewMovingOn) {
        this.reviewMovingOn = reviewMovingOn;
    }

    protected void valueChanged() {
        this.valueChanged(null);
    }

    protected void valueChanged(HashSet<String> value) {
        HashSet<String> newValue = value == null ? this.getValue() : value;
        this.updateDecoration(newValue);
        for (ICustomFieldWidget.ICustomFieldWidgetModifyListener modifyListener : this.modifyListeners.getListeners()) {
            modifyListener.widgetModified(this, newValue);
        }
    }

    @Override
    public final void setValue(HashSet<String> value) {
        this.doSetValue(value);
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setChecklistItemId(Integer checklistItemId) {
        this.checklistItemId = checklistItemId;
    }

    @Override
    public Integer getChecklistItemId() {
        return this.checklistItemId;
    }

    protected abstract void doSetValue(Set<String> var1);

    @Override
    public final void addModifyListener(ICustomFieldWidget.ICustomFieldWidgetModifyListener listener) {
        this.modifyListeners.add((Object)listener);
    }

    @Override
    public final void removeModifyListener(ICustomFieldWidget.ICustomFieldWidgetModifyListener listener) {
        this.modifyListeners.remove((Object)listener);
    }
}

