/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.customfield;

import com.google.common.base.Joiner;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.collaborator.ui.customfield.AbstractCustomFieldWidget;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.HashSets;
import com.smartbear.util.SmartBearUtils;
import com.smartbear.util.Strings;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

abstract class AbstractStringCustomFieldWidget<F extends ICustomField>
extends AbstractCustomFieldWidget<F, StyledText> {
    private final IStyledTextDecorator userTextDecorator;

    protected AbstractStringCustomFieldWidget(Composite parent, int style, F customField, IStyledTextDecorator userTextDecorator) {
        super(customField, new StyledText(parent, style));
        this.userTextDecorator = userTextDecorator;
        ((StyledText)this.getControl()).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractStringCustomFieldWidget.this.valueChanged();
            }
        });
    }

    @Override
    public final HashSet<String> getValue() {
        String text = ((StyledText)this.getControl()).getText();
        if (StringUtils.isBlank((String)text)) {
            return HashSets.singletonHashSet((Object)"");
        }
        Object[] lines = Strings.breakIntoLines((String)text);
        Joiner j = Joiner.on((String)"\n");
        text = j.join(lines);
        return HashSets.singletonHashSet((Object)text);
    }

    @Override
    protected final void doSetValue(Set<String> value) {
        ((StyledText)this.getControl()).setText(StringUtils.defaultString((String)((String)SmartBearUtils.getFirstObject(value))));
    }

    @Override
    protected void valueChanged() {
        super.valueChanged();
        SwtUtils.clearStylesAndLinks((StyledText)this.getControl());
        this.userTextDecorator.decorate((StyledText)this.getControl());
    }

    @Override
    public void setEditable(boolean editable) {
        ((StyledText)this.getControl()).setEditable(editable);
    }
}

