/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.customfield;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.smartbear.ccollab.client.commands.argrefs.ICustomFieldRef;
import com.smartbear.ccollab.datamodel.MetaDataDescription;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.ICustomFieldMultiSelection;
import com.smartbear.ccollab.datamodel.client.ICustomFieldSelection;
import com.smartbear.ccollab.datamodel.client.ICustomFieldString;
import com.smartbear.ccollab.datamodel.client.ICustomFieldStringBig;
import com.smartbear.ccollab.datamodel.client.ICustomFieldTreeSelection;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.collaborator.ui.customfield.ICustomFieldWidget;
import com.smartbear.collaborator.ui.customfield.MultiSelectionCustomFieldWidget;
import com.smartbear.collaborator.ui.customfield.SelectionCustomFieldWidget;
import com.smartbear.collaborator.ui.customfield.StringBigCustomFieldWidget;
import com.smartbear.collaborator.ui.customfield.StringCustomFieldWidget;
import com.smartbear.collaborator.ui.customfield.TreeSelectionCustomFieldWidget;
import com.smartbear.collections.Pair;
import com.smartbear.swt.TableWrapData2;
import com.smartbear.swt.text.IStyledTextDecorator;
import java.util.Collection;
import java.util.Set;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class CustomFieldWidgetFactory {
    private CustomFieldWidgetFactory() {
    }

    public static ICustomFieldWidget create(Composite parent, int style, ICustomField customField, IStyledTextDecorator userTextDecorator) {
        if (customField instanceof ICustomFieldString) {
            return new StringCustomFieldWidget(parent, style, (ICustomFieldString)customField, userTextDecorator);
        }
        if (customField instanceof ICustomFieldStringBig) {
            return new StringBigCustomFieldWidget(parent, style, (ICustomFieldStringBig)customField, userTextDecorator);
        }
        if (customField instanceof ICustomFieldSelection) {
            return new SelectionCustomFieldWidget(parent, style, (ICustomFieldSelection)customField);
        }
        if (customField instanceof ICustomFieldTreeSelection) {
            return new TreeSelectionCustomFieldWidget(parent, style, (ICustomFieldTreeSelection)customField);
        }
        if (customField instanceof ICustomFieldMultiSelection) {
            return new MultiSelectionCustomFieldWidget(parent, style, (ICustomFieldMultiSelection)customField);
        }
        throw new RuntimeException("No widget for custom field type " + customField.getClass());
    }

    public static Pair<Label, ICustomFieldWidget> layoutWithLabel(Composite parent, int style, ICustomField field, IStyledTextDecorator userTextDecorator, IReviewMovingOn reviewMovingOn) {
        Label label = new Label(parent, 0);
        label.setText(field.getTitle() + ":");
        label.setToolTipText(field.getDescription());
        label.setLayoutData((Object)new TableWrapData2(8, 16));
        ICustomFieldWidget widget = CustomFieldWidgetFactory.create(parent, 2048, field, userTextDecorator);
        widget.setReviewMovingOn(reviewMovingOn);
        TableWrapData2 layoutData = new TableWrapData2(256, 16);
        if (widget instanceof StringBigCustomFieldWidget) {
            StyledText control = (StyledText)((StringBigCustomFieldWidget)widget).getControl();
            control.setText("\n\n\n");
            layoutData.heightHint = control.computeSize((int)-1, (int)-1).y;
            control.setText("");
        }
        widget.getControl().setLayoutData((Object)layoutData);
        return Pair.of((Object)label, (Object)widget);
    }

    public static ICustomFieldRef toValueRef(final ICustomFieldWidget widget) {
        return new ICustomFieldRef(){

            public String getTitle() {
                return widget.getCustomField().getTitle();
            }

            public Set<String> getValues(MetaDataDescription.Type type) {
                return this.getValues();
            }

            public Set<String> getValues() {
                return widget.getValue();
            }

            public Set<String> getRawValues() {
                return widget.getValue();
            }

            public String getUser() {
                return widget.getUser();
            }

            public Integer getChecklistItemId() {
                return widget.getChecklistItemId();
            }
        };
    }

    public static ICustomFieldRef[] toValueRefs(Collection<? extends ICustomFieldWidget> widgets) {
        Collection refs = Collections2.transform(widgets, (Function)new Function<ICustomFieldWidget, ICustomFieldRef>(){

            public ICustomFieldRef apply(ICustomFieldWidget widget) {
                return CustomFieldWidgetFactory.toValueRef(widget);
            }
        });
        return refs.toArray(ICustomFieldRef.EMPTY_ARRAY);
    }
}

