/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.customfield;

import com.smartbear.ccollab.datamodel.client.ICustomFieldSelection;
import com.smartbear.collaborator.ui.customfield.AbstractCustomFieldWidget;
import com.smartbear.jface.CollectionContentProvider;
import com.smartbear.jface.ComboViewer2;
import com.smartbear.jface.ISelectionChangedListener2;
import com.smartbear.util.HashSets;
import com.smartbear.util.SmartBearUtils;
import com.smartbear.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class SelectionCustomFieldWidget
extends AbstractCustomFieldWidget<ICustomFieldSelection, Combo> {
    private final ComboViewer2<List<String>, String> viewer = ComboViewer2.create((Combo)this.getControl());
    private final int EVENT_MOUSE_DOWN = 1;
    private final int EVENT_ENTER = 2;
    private final int EVENT_MODIFY = 3;

    public SelectionCustomFieldWidget(Composite parent, int style, ICustomFieldSelection customField) {
        super(customField, new Combo(parent, style | 4));
        this.viewer.setContentProvider(CollectionContentProvider.getInstance());
        this.viewer.setInput(customField.getItems());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener2<String>(){

            @Override
            public void selectionChanged(List<String> selection) {
                SelectionCustomFieldWidget.this.valueChanged();
            }
        });
        this.viewer.getCombo().addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    SelectionCustomFieldWidget.this.handleCustomFieldValue(2);
                }
            }
        });
        this.viewer.getCombo().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 3 || event.type == 8) {
                    SelectionCustomFieldWidget.this.handleCustomFieldValue(1);
                    String text = SelectionCustomFieldWidget.this.viewer.getCombo().getText();
                    int endSelection = text.length();
                    Point point = new Point(endSelection, endSelection);
                    SelectionCustomFieldWidget.this.viewer.getCombo().setSelection(point);
                }
            }
        });
        this.viewer.getCombo().addModifyListener(new ModifyListener(){
            private List<String> itemFields;

            public void modifyText(ModifyEvent e) {
                SelectionCustomFieldWidget.this.handleCustomFieldValue(3);
            }
        });
        if (customField.getDefaultValue() != null) {
            this.setValue(HashSets.singletonHashSet((Object)customField.getDefaultValue()));
        }
        AutoCompleteField autoCompleteField = new AutoCompleteField((Control)this.viewer.getCombo(), (IControlContentAdapter)new ComboContentAdapter(), customField.getItems().toArray(new String[0]));
    }

    private void handleCustomFieldValue(int eventType) {
        String text = this.viewer.getCombo().getText();
        ArrayList<String> itemFields = this.getComboItems();
        if (eventType != 3) {
            this.viewer.setInput(itemFields);
        }
        if (itemFields.contains(text) || Strings.isNullOrEmpty((String)text)) {
            HashSet values;
            HashSet hashSet = values = null == text ? HashSets.emptyHashSet() : HashSets.singletonHashSet((Object)text);
            if (eventType == 2) {
                this.setValue(values);
            }
            if (eventType == 1) {
                this.viewer.getCombo().setText(text);
            }
            this.valueChanged(values);
        }
    }

    @Override
    public HashSet<String> getValue() {
        String firstValue = (String)SmartBearUtils.getFirstObject(this.viewer.getSelection());
        if (firstValue == null) {
            firstValue = this.viewer.getCombo().getText();
        }
        return null == firstValue ? HashSets.emptyHashSet() : HashSets.singletonHashSet((Object)firstValue);
    }

    @Override
    protected void doSetValue(Set<String> values) {
        List selection = values.isEmpty() ? Collections.emptyList() : Collections.singletonList((String)SmartBearUtils.getFirstObject(values));
        this.viewer.setSelection(selection);
    }

    @Override
    public void setEditable(boolean editable) {
        this.viewer.getControl().setEnabled(editable);
    }

    private ArrayList<String> getComboItems() {
        String[] comboItems = this.viewer.getCombo().getItems();
        ArrayList<String> itemFields = new ArrayList<String>();
        Collections.addAll(itemFields, comboItems);
        return itemFields;
    }
}

