/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.customfield;

import com.smartbear.ccollab.datamodel.client.ICustomFieldTreeSelection;
import com.smartbear.collaborator.ui.customfield.AbstractCustomFieldWidget;
import com.smartbear.jface.CollectionContentProvider;
import com.smartbear.jface.ComboViewer2;
import com.smartbear.jface.ISelectionChangedListener2;
import com.smartbear.util.HashSets;
import com.smartbear.util.SmartBearUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public final class TreeSelectionCustomFieldWidget
extends AbstractCustomFieldWidget<ICustomFieldTreeSelection, Combo> {
    private final ComboViewer2<List<String>, String> viewer = ComboViewer2.create((Combo)this.getControl());

    public TreeSelectionCustomFieldWidget(Composite parent, int style, ICustomFieldTreeSelection customField) {
        super(customField, new Combo(parent, style | 8));
        this.viewer.setContentProvider(CollectionContentProvider.getInstance());
        this.viewer.setInput(customField.getItems());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener2<String>(){

            @Override
            public void selectionChanged(List<String> selection) {
                TreeSelectionCustomFieldWidget.this.valueChanged();
            }
        });
        if (customField.getDefaultValue() != null) {
            this.setValue(HashSets.singletonHashSet((Object)customField.getDefaultValue()));
        }
    }

    @Override
    public HashSet<String> getValue() {
        String firstValue = (String)SmartBearUtils.getFirstObject(this.viewer.getSelection());
        return null == firstValue ? HashSets.emptyHashSet() : HashSets.singletonHashSet((Object)firstValue);
    }

    @Override
    protected void doSetValue(Set<String> values) {
        List selection = values.isEmpty() ? Collections.emptyList() : Collections.singletonList((String)SmartBearUtils.getFirstObject(values));
        this.viewer.setSelection(selection);
    }

    @Override
    public void setEditable(boolean editable) {
        this.viewer.getControl().setEnabled(editable);
    }
}

