/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.debug;

import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.collaborator.CommonsLoggingBridge;
import com.smartbear.collaborator.ui.ErrorUI;
import com.smartbear.collaborator.ui.UIName;
import com.smartbear.swt.RightSizeText;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.EnvironmentUtils;
import com.smartbear.util.LoggingUtils;
import com.smartbear.util.PathUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DebugWindow
extends Window {
    private static final int LOG_DISPLAY_REFRESH_MILLIS = 500;
    private final boolean allLogs;
    private File eclipseLogSnapshot;
    private RightSizeText logText;
    private boolean logDisplayNeedsRefresh = false;
    private String parentWindowTitle;
    private static final Log log = LogFactory.getLog(DebugWindow.class);
    private ILogListener logListener;

    public DebugWindow(Shell parent, String parentWindowTitle, boolean allLogs) {
        super(parent);
        this.allLogs = allLogs;
        this.setBlockOnOpen(false);
        this.setShellStyle(2160);
        this.parentWindowTitle = parentWindowTitle;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Debug Log");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label messageLabel = new Label(composite, 64);
        messageLabel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).create());
        messageLabel.setText("Re-create the problem in the main " + this.parentWindowTitle + " window, and then select \"Save Log\" below:");
        this.logText = new RightSizeText(composite, 543498);
        this.logText.setBackground(parent.getDisplay().getSystemColor(25));
        this.logText.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        if (this.allLogs) {
            try {
                this.eclipseLogSnapshot = new File(PathUtils.createTempDir((String)"eclipseLogSnapshot", (String)"", null), "eclipse.log");
                FileUtils.copyFile((File)Platform.getLogFileLocation().toFile(), (File)this.eclipseLogSnapshot);
            }
            catch (IOException e) {
                log.error((Object)"Error taking snapshot of Eclipse log", (Throwable)e);
            }
        }
        final StringBuilder buffer = new StringBuilder();
        this.logListener = new ILogListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void logging(IStatus status, String plugin) {
                StringBuilder stringBuilder = buffer;
                synchronized (stringBuilder) {
                    this.appendToLog(buffer, status);
                    if (status.isMultiStatus()) {
                        for (IStatus child : status.getChildren()) {
                            this.appendToLog(buffer, child);
                        }
                    }
                    DebugWindow.this.logDisplayNeedsRefresh = true;
                }
            }

            private void appendToLog(StringBuilder buffer2, IStatus status) {
                if (!(status instanceof CommonsLoggingBridge.FormattedStatus)) {
                    buffer2.append(DebugWindow.this.formatSeverity(status)).append(": ").append(new Date()).append(": ").append(status.getPlugin()).append(SystemUtils.LINE_SEPARATOR);
                }
                buffer2.append(status.getMessage());
                buffer2.append(SystemUtils.LINE_SEPARATOR);
                if (status.getException() != null) {
                    buffer2.append(ExceptionUtils.getStackTrace((Throwable)status.getException()));
                }
            }
        };
        Platform.addLogListener((ILogListener)this.logListener);
        Logger.getLogger("").setLevel(Level.FINE);
        log.debug((Object)(Product.current.getProductName() + " version " + Product.current.getProductVersion()));
        log.debug((Object)("Build Number:" + Product.current.getProductVersionNumber() + "." + Product.current.getProductInternalBuildNumber()));
        LoggingUtils.logVmMemory((Log)log);
        LoggingUtils.logSystemProperties((Log)log);
        EnvironmentUtils.logEnvironment((Log)log);
        this.logDisplayNeedsRefresh = true;
        Display.getDefault().timerExec(500, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (DebugWindow.this.logText.isDisposed()) {
                    return;
                }
                StringBuilder stringBuilder = buffer;
                synchronized (stringBuilder) {
                    if (DebugWindow.this.logDisplayNeedsRefresh) {
                        DebugWindow.this.logText.setText(buffer.toString());
                        DebugWindow.this.logText.setTopIndex(DebugWindow.this.logText.getLineCount());
                        DebugWindow.this.logDisplayNeedsRefresh = false;
                    }
                    Display.getDefault().timerExec(500, (Runnable)this);
                }
            }
        });
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayoutData((Object)GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(true, false).create());
        buttonsComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Button saveLogButton = new Button(buttonsComposite, 8);
        SwtUtils.setName((Widget)saveLogButton, UIName.DEBUG_WINDOW_SAVE_LOG);
        saveLogButton.setText("Save Log");
        saveLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<File> extraFiles;
                String bufferName;
                if (DebugWindow.this.allLogs) {
                    bufferName = "gui.log";
                    extraFiles = Arrays.asList(new File("ccollab.log"), DebugWindow.this.eclipseLogSnapshot);
                } else {
                    bufferName = "ccollab.log";
                    extraFiles = null;
                }
                if (ErrorUI.saveDebugLog(DebugWindow.this.getShell(), new ByteArrayInputStream(buffer.toString().getBytes()), bufferName, extraFiles)) {
                    DebugWindow.this.closeShell();
                }
            }
        });
        Button cancelButton = new Button(buttonsComposite, 8);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugWindow.this.closeShell();
            }
        });
        return composite;
    }

    public boolean close() {
        if (this.logListener != null) {
            Platform.removeLogListener((ILogListener)this.logListener);
            this.logListener = null;
        }
        Logger.getLogger("").setLevel(null);
        return super.close();
    }

    public boolean isLogging() {
        return this.logListener != null;
    }

    private void closeShell() {
        if (this.getShell() != null) {
            this.getShell().close();
        } else {
            this.close();
        }
    }

    private String formatSeverity(IStatus status) {
        String severity = null;
        if (status.isOK()) {
            severity = "OK";
        } else if (status.matches(8)) {
            severity = "CANCEL";
        } else if (status.matches(4)) {
            severity = "ERROR";
        } else if (status.matches(1)) {
            severity = "INFO";
        } else if (status.matches(2)) {
            severity = "WARNING";
        }
        return severity;
    }
}

