/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.diffs;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.ui.diffs.GitBranchesBlock;
import com.smartbear.collaborator.ui.diffs.IDiffBuilder;
import com.smartbear.collaborator.ui.diffs.IDiffBuilderListener;
import com.smartbear.collaborator.ui.wizards.ProgressWizardDialog;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.impl.git.GitClientConfiguration;
import com.smartbear.util.commons.ArrayUtils;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GitBranchesDiffBuilder
implements IDiffBuilder {
    private static final String DIALOG_SETTINGS_BEFORE_TEXT = "Before text";
    private static final String DIALOG_SETTINGS_AFTER_TEXT = "After text";
    private final GitClientConfiguration clientConfig;
    private Wizard wizard;
    private GitBranchesBlock block;

    public GitBranchesDiffBuilder(IScmClientConfiguration clientConfig) {
        this.clientConfig = (GitClientConfiguration)clientConfig;
    }

    @Override
    public void createControl(Composite parent, Shell parentShell, IDiffBuilderListener listener) {
        this.block = new GitBranchesBlock(parent, 0);
        this.block.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.block.beforeGitBranchesCombo.addModifyListener((ModifyListener)listener);
        this.block.afterGitBranchesCombo.addModifyListener((ModifyListener)listener);
        ((ProgressWizardDialog)this.wizard.getContainer()).runAsync(new ProgressWizardDialog.ISimpleRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                List branchesList;
                monitor.beginTask("Loading branches", 100);
                try {
                    branchesList = GitBranchesDiffBuilder.this.clientConfig.listBranches((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                catch (ScmCommunicationException e) {
                    return;
                }
                monitor.done();
                final String[] branches = branchesList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (GitBranchesDiffBuilder.this.block.isDisposed()) {
                            return;
                        }
                        GitBranchesDiffBuilder.this.block.beforeGitBranchesCombo.setItems(branches);
                        GitBranchesDiffBuilder.this.block.afterGitBranchesCombo.setItems(branches);
                    }
                });
            }
        });
    }

    @Override
    public String getDescription() {
        return "Compare two branches";
    }

    @Override
    public String getDiffArgs() {
        if (null == this.block) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.block.beforeGitBranchesCombo.getText());
        b.append(" ");
        b.append(this.block.afterGitBranchesCombo.getText());
        return b.toString();
    }

    @Override
    public String getName() {
        return "Branches";
    }

    @Override
    public String getWarningMessage() {
        if (null == this.block) {
            return null;
        }
        if (StringUtils.isBlank((String)this.block.beforeGitBranchesCombo.getText())) {
            return "Before branch must be specified";
        }
        if (StringUtils.isBlank((String)this.block.afterGitBranchesCombo.getText())) {
            return "After branch must be specified";
        }
        return null;
    }

    @Override
    public void init(IDialogSettings dialogSettings) {
        if (this.block == null) {
            return;
        }
        this.block.beforeGitBranchesCombo.setText(StringUtils.defaultString((String)dialogSettings.get(DIALOG_SETTINGS_BEFORE_TEXT)));
        this.block.afterGitBranchesCombo.setText(StringUtils.defaultString((String)dialogSettings.get(DIALOG_SETTINGS_AFTER_TEXT)));
    }

    @Override
    public void save(IDialogSettings dialogSettings) {
        if (this.block == null) {
            return;
        }
        dialogSettings.put(DIALOG_SETTINGS_BEFORE_TEXT, this.block.beforeGitBranchesCombo.getText());
        dialogSettings.put(DIALOG_SETTINGS_AFTER_TEXT, this.block.afterGitBranchesCombo.getText());
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }
}

