/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.editors;

import com.google.common.collect.Maps;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.client.commands.admin.review.AbstractReviewCommand;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewEdit;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IReviewChecklist;
import com.smartbear.ccollab.datamodel.client.IReviewGeneralInfo;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryChangelist;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryFile;
import com.smartbear.ccollab.datamodel.client.IScmMaterials;
import com.smartbear.ccollab.datamodel.client.IVersionLocatable;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.OverallLocator;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.jobs.ReviewRefreshJob;
import com.smartbear.collaborator.ui.ActivityListener;
import com.smartbear.collaborator.ui.AutomaticLinkStyledTextDecorator;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.ReviewCommandRunner;
import com.smartbear.collaborator.ui.actions.ClientModelRefreshAction;
import com.smartbear.collaborator.ui.editors.ReviewEditorInput;
import com.smartbear.collaborator.ui.review.GeneralInfoWidget;
import com.smartbear.collaborator.ui.review.IConversationContext;
import com.smartbear.collaborator.ui.review.IConversationContextListener;
import com.smartbear.collaborator.ui.review.MovingOnWidget;
import com.smartbear.collaborator.ui.review.ParticipantCustomFieldsWidget;
import com.smartbear.collaborator.ui.review.ParticipantsWidget;
import com.smartbear.collaborator.ui.review.ReviewSummaryChecklistSectionWidget;
import com.smartbear.collaborator.ui.review.ReviewSummaryDefectLogWidget;
import com.smartbear.collaborator.ui.review.ReviewSummaryRemoteSystemLinkWidget;
import com.smartbear.collaborator.ui.review.compare.LinkToFileStyledTextDecorator;
import com.smartbear.collaborator.ui.review.materials.MaterialsWidget;
import com.smartbear.collaborator.ui.util.URLStyledTextDecorator;
import com.smartbear.collaborator.ui.views.AbstractContextView;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.TableWrapData2;
import com.smartbear.swt.TableWrapLayout2;
import com.smartbear.swt.text.CompositeStyledTextDecorator;
import com.smartbear.swt.text.IStyledTextDecorator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.services.IServiceLocator;

public class ReviewEditor
extends EditorPart
implements IReusableEditor {
    public static final String ID = "com.smartbear.collaborator.ui.editors.ReviewEditor";
    private final ISaveableListener saveableListener = new ISaveableListener(){

        @Override
        public void dirtyStateMayHaveChanged() {
            ReviewEditor.this.firePropertyChange(257);
        }
    };
    private IReviewSummary model;
    private IClientSystemGlobals clientSystemGlobals;
    private ReviewRefreshJob refreshJob;
    private ActivityListener activityListener;
    private ManagedForm managedForm;
    private ReviewCommandRunner commandRunner;
    private GeneralInfoWidget generalInfoWidget;
    private ParticipantsWidget participantsWidget;
    private ParticipantCustomFieldsWidget participantCustomFieldsWidget;
    private ReviewSummaryChecklistSectionWidget checklistSectionWidget;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ReviewEditorInput)) {
            throw new PartInitException("Invalid Input: Must be " + ReviewEditorInput.class.getName());
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.fetchModel((IProgressMonitor)new NullProgressMonitor());
        this.startRefreshJob();
    }

    public void dispose() {
        if (this.refreshJob != null) {
            this.refreshJob.stop();
        }
        if (this.managedForm != null) {
            this.managedForm.getForm().dispose();
        }
    }

    public Object getAdapter(Class adapter) {
        if (IReviewSummary.class.equals((Object)adapter) || IConversationProvider.class.equals((Object)adapter)) {
            return this.model;
        }
        if (IClientSystemGlobals.class.equals((Object)adapter)) {
            return this.clientSystemGlobals;
        }
        if (IConversationContext.class.equals((Object)adapter)) {
            return new IConversationContext(){

                @Override
                public ILocator getCurrentLocator() {
                    return OverallLocator.INSTANCE;
                }

                @Override
                public ILocator getLocator(IVersionLocatable locatable) {
                    return OverallLocator.INSTANCE;
                }

                @Override
                public String getWhyNotAllowedToStartNewConversation() {
                    return "Only one conversation is allowed for the overall Review";
                }

                @Override
                public boolean allowsLabelLocators() {
                    return false;
                }

                @Override
                public IStyledTextDecorator getUserTextDecorator() {
                    return ReviewEditor.this.createUserTextDecorator(false);
                }

                @Override
                public void addConversationContextListener(IConversationContextListener listener) {
                }

                @Override
                public void removeConversationContextListener(IConversationContextListener listener) {
                }

                @Override
                public void addKeyListener(KeyListener listener) {
                }

                @Override
                public void removeKeyListener(KeyListener listener) {
                }
            };
        }
        if (ActivityListener.class.equals((Object)adapter)) {
            return this.activityListener;
        }
        return super.getAdapter(adapter);
    }

    public void setInput(IEditorInput input) {
        super.setInputWithNotify(input);
    }

    public boolean isDirty() {
        return this.generalInfoWidget != null && this.generalInfoWidget.isDirty() || this.participantsWidget != null && this.participantsWidget.isDirty() || this.participantCustomFieldsWidget != null && this.participantCustomFieldsWidget.isDirty() || this.checklistSectionWidget != null && this.checklistSectionWidget.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor monitor) {
        block15: {
            try {
                List<AbstractReviewCommand> cmds;
                CommandReviewEdit cmd;
                monitor.beginTask("Saving changes to " + this.getTitle(), 100);
                boolean refresh = null != this.generalInfoWidget && (this.generalInfoWidget.templateDirty() || this.generalInfoWidget.groupDirty());
                refresh = refresh || this.checklistSectionWidget != null && this.checklistSectionWidget.isDirty();
                ArrayList<Object> commands = new ArrayList<Object>(2);
                if (this.generalInfoWidget != null && this.generalInfoWidget.isDirty()) {
                    cmd = this.generalInfoWidget.getSaveCommand();
                    cmd.setReview(Integer.toString(this.model.getId()));
                    commands.add(cmd);
                }
                if (this.participantsWidget != null && this.participantsWidget.isDirty()) {
                    cmds = this.participantsWidget.getSaveCommands();
                    for (AbstractReviewCommand cmd2 : cmds) {
                        cmd2.setReview(Integer.toString(this.model.getId()));
                    }
                    commands.addAll(cmds);
                }
                if (this.participantCustomFieldsWidget != null && this.participantCustomFieldsWidget.isDirty()) {
                    cmd = this.participantCustomFieldsWidget.getSaveCommand();
                    if (cmd instanceof CommandReviewEdit) {
                        cmd.setReview(Integer.toString(this.model.getId()));
                    }
                    commands.add(cmd);
                }
                if (this.checklistSectionWidget != null && this.checklistSectionWidget.isDirty()) {
                    cmds = this.checklistSectionWidget.getSaveCommand();
                    for (AbstractReviewCommand cmd2 : cmds) {
                        if (!(cmd2 instanceof CommandReviewEdit)) continue;
                        ((CommandReviewEdit)cmd2).setReview(Integer.toString(this.model.getId()));
                        commands.add(cmd2);
                    }
                }
                if (!commands.isEmpty()) {
                    CollaboratorUI.executeServerCommands(commands, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                } else {
                    monitor.worked(30);
                }
                if (null != this.generalInfoWidget && refresh) {
                    this.setInput(new ReviewEditorInput(((ReviewEditorInput)this.getEditorInput()).getReviewId()));
                    this.refreshForm((IProgressMonitor)new SubProgressMonitor(monitor, 70));
                    break block15;
                }
                this.refreshJob.start();
                try {
                    this.refreshJob.join();
                }
                catch (InterruptedException e) {
                    CollaboratorUI.log("Interrupted waiting for refresh job to finish", e);
                }
                monitor.worked(70);
            }
            finally {
                monitor.done();
            }
        }
    }

    private void startRefreshJob() {
        if (null != this.model) {
            this.refreshJob = new ReviewRefreshJob(this.model, this.clientSystemGlobals, SwtUtils.DISPLAY_SYNC_EXECUTOR);
            this.refreshJob.start();
        }
    }

    private void refreshForm(IProgressMonitor monitor) {
        if (null != this.refreshJob) {
            this.refreshJob.stop();
            this.refreshJob = null;
        }
        try {
            this.fetchModel(monitor);
        }
        catch (PartInitException e) {
            CollaboratorUI.openError(this.getSite().getShell(), e.getMessage(), e, false, true);
        }
        this.startRefreshJob();
        Composite parent = this.managedForm.getForm().getParent();
        ManagedForm oldForm = this.managedForm;
        this.createPartControl(parent);
        oldForm.getForm().dispose();
        oldForm.dispose();
        parent.layout(true);
        AbstractContextView.broadcastReconsiderPart(this.getEditorSite().getPart());
    }

    private void fetchModel(IProgressMonitor monitor) throws PartInitException {
        monitor.beginTask("Fetching Review Summary Model", 100);
        int reviewId = ((ReviewEditorInput)this.getEditorInput()).getReviewId();
        try {
            monitor.subTask("Connecting to " + Product.current.getProductName() + " Server");
            monitor.worked(50);
            this.clientSystemGlobals = JsonAPIHandler.getClientSystemGlobals();
            monitor.subTask("Fetching review summary model");
            this.model = JsonAPIHandler.getReviewSummary((int)reviewId);
            monitor.worked(50);
        }
        catch (ParseException e) {
            throw new PartInitException("Error for getting ReviewSummary", (Throwable)e);
        }
        catch (CollabClientServerConnectivityException e) {
            throw new PartInitException("Error connecting to " + Product.current.getProductName() + " Server: " + e.getMessage(), (Throwable)e);
        }
        catch (NoLicenseAvailableException e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
        catch (CollabClientException e) {
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    public void doSaveAs() {
        throw new RuntimeException("Save As not supported");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.managedForm.getForm().setFocus();
    }

    public void createPartControl(Composite parent) {
        this.activityListener = new ActivityListener((ClientModelRefreshJob)this.refreshJob);
        this.managedForm = new ManagedForm(parent);
        this.commandRunner = new ReviewCommandRunner(this.model.getId(), (IWorkbenchSite)this.getSite());
        this.initForm();
        this.createGeneralInfoSection();
        this.createParticipantsSection();
        this.createParticipantCustomFieldsSection();
        this.createChecklistSection((IWorkbenchSite)this.getSite());
        this.createRemoteSystemItemsSection((IWorkbenchSite)this.getSite());
        this.createDefectLogSection((IWorkbenchSite)this.getSite());
        this.createMaterialsSection();
        this.createMovingOnSection();
        Display display = Display.getDefault();
        final ScrolledForm form = this.managedForm.getForm();
        display.addFilter(37, new Listener(){

            public void handleEvent(Event event) {
                if (form != null && !form.isDisposed() && !form.isFocusControl()) {
                    ReviewEditor.this.managedForm.getForm().setFocus();
                }
            }
        });
    }

    private void createMovingOnSection() {
        Section section = this.createSection("Moving On");
        this.createToolBar(section, "movingOn");
        IReviewMovingOn movingOn = this.model.getMovingOn();
        MovingOnWidget movingOnWidget = new MovingOnWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.clientSystemGlobals, movingOn, this.commandRunner);
        SwtUtils.recursiveAdapt(this.managedForm.getToolkit(), (Control)movingOnWidget, false, false, false, false);
        section.setClient((Control)movingOnWidget);
    }

    private void createMaterialsSection() {
        Section section = this.createSection("Review Materials");
        this.createToolBar(section, "materials");
        MaterialsWidget widget = new MaterialsWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, (IToolBarManager)this.createToolBar(section, "materials"), this.model, this.refreshJob, this.getSite());
        section.setClient((Control)widget);
    }

    private void createDefectLogSection(IWorkbenchSite site) {
        Section section = this.createSection(WordUtils.capitalize((String)this.clientSystemGlobals.getDefectLabelSingular()) + " Log");
        this.createToolBar(section, "defectLog");
        ReviewSummaryDefectLogWidget widget = new ReviewSummaryDefectLogWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.model, (IServiceLocator)this.getSite(), site);
        Table control = widget.getControl();
        SwtUtils.recursiveAdapt(this.managedForm.getToolkit(), (Control)control, false, false, false, false);
        section.setClient((Control)control);
    }

    private void createParticipantsSection() {
        Section section = this.createSection("Participants");
        this.createToolBar(section, "participants");
        this.participantsWidget = new ParticipantsWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.createToolBar(section, "participants"), this.saveableListener, this.clientSystemGlobals, this.model, this.commandRunner);
        SwtUtils.recursiveAdapt(this.managedForm.getToolkit(), (Control)this.participantsWidget, false, false, false, true);
        section.setClient((Control)this.participantsWidget);
    }

    private void createParticipantCustomFieldsSection() {
        final ArrayList customFields = this.model.getGeneralInfo().getTemplate().getParticipantCustomFields();
        if (customFields.isEmpty()) {
            return;
        }
        final Section section = this.createSection("Participant Custom Fields");
        this.createToolBar(section, "participantCustomFields");
        this.participantCustomFieldsWidget = new ParticipantCustomFieldsWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.clientSystemGlobals, this.model, this.saveableListener, this.createUserTextDecorator(true));
        SwtUtils.recursiveAdapt(this.managedForm.getToolkit(), (Control)this.participantCustomFieldsWidget, false, false, false, false);
        section.setClient((Control)this.participantCustomFieldsWidget);
        ReviewMovingOnAdapter phaseVisibilityListener = new ReviewMovingOnAdapter(){

            public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
                section.setVisible(false);
                for (ICustomField customField : customFields) {
                    section.setVisible(section.isVisible() || customField.getVisiblePhases().contains(phase));
                }
                TableWrapData2 layoutData = (TableWrapData2)section.getLayoutData();
                if (layoutData.exclude == section.getVisible()) {
                    layoutData.exclude = !section.getVisible();
                    SwtUtils.reflowForm((Control)section);
                }
            }
        };
        this.model.getMovingOn().addMovingOnListener((IReviewMovingOnListener)phaseVisibilityListener);
        section.addDisposeListener(new DisposeListener((IReviewMovingOnListener)phaseVisibilityListener){
            final /* synthetic */ IReviewMovingOnListener val$phaseVisibilityListener;
            {
                this.val$phaseVisibilityListener = iReviewMovingOnListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                ReviewEditor.this.model.getMovingOn().removeMovingOnListener(this.val$phaseVisibilityListener);
            }
        });
        ReviewMovingOnAdapter.init((IReviewMovingOn)this.model.getMovingOn(), (IReviewMovingOnListener)phaseVisibilityListener);
    }

    private void createChecklistSection(IWorkbenchSite site) {
        IReviewChecklist reviewChecklist = this.model.getReviewChecklists().stream().findFirst().orElse(null);
        List customFields = reviewChecklist != null ? reviewChecklist.getChecklistCustomFields() : Collections.EMPTY_LIST;
        final Section section = this.createSection("Checklist");
        this.createToolBar(section, "checklist");
        this.checklistSectionWidget = new ReviewSummaryChecklistSectionWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.clientSystemGlobals, this.model, this.saveableListener, this.createUserTextDecorator(true));
        SwtUtils.recursiveAdapt(this.managedForm.getToolkit(), (Control)this.checklistSectionWidget, false, false, false, false);
        section.setClient((Control)this.checklistSectionWidget);
        ReviewMovingOnAdapter phaseVisibilityListener = new ReviewMovingOnAdapter(){

            public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
                List reviewChecklistList = ReviewEditor.this.model.getReviewChecklists();
                if (reviewChecklistList.size() > 0) {
                    section.setVisible(true);
                } else {
                    section.setVisible(false);
                }
                TableWrapData2 layoutData = (TableWrapData2)section.getLayoutData();
                if (layoutData.exclude == section.getVisible()) {
                    layoutData.exclude = !section.getVisible();
                    SwtUtils.reflowForm((Control)section);
                }
            }
        };
        this.model.getMovingOn().addMovingOnListener((IReviewMovingOnListener)phaseVisibilityListener);
        section.addDisposeListener(new DisposeListener((IReviewMovingOnListener)phaseVisibilityListener){
            final /* synthetic */ IReviewMovingOnListener val$phaseVisibilityListener;
            {
                this.val$phaseVisibilityListener = iReviewMovingOnListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                ReviewEditor.this.model.getMovingOn().removeMovingOnListener(this.val$phaseVisibilityListener);
            }
        });
        ReviewMovingOnAdapter.init((IReviewMovingOn)this.model.getMovingOn(), (IReviewMovingOnListener)phaseVisibilityListener);
    }

    private void createRemoteSystemItemsSection(IWorkbenchSite site) {
        Section section = this.createSection(WordUtils.capitalize((String)"Remote System Links"));
        this.createToolBar(section, "Remote System Links");
        ReviewSummaryRemoteSystemLinkWidget widget = new ReviewSummaryRemoteSystemLinkWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.saveableListener, this.model, site);
        SwtUtils.recursiveAdapt(this.managedForm.getToolkit(), (Control)widget, false, false, false, false);
        section.setClient((Control)widget);
    }

    private void createGeneralInfoSection() {
        Section section = this.createSection("General Information");
        ToolBarManager toolBar = this.createToolBar(section, "generalInfo");
        toolBar.add((IAction)new ClientModelRefreshAction((ClientModelRefreshJob)this.refreshJob));
        IReviewGeneralInfo generalInfo = this.model.getGeneralInfo();
        this.generalInfoWidget = new GeneralInfoWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.saveableListener, this.clientSystemGlobals, generalInfo, this.getSite(), (IToolBarManager)toolBar, this.commandRunner, this.createUserTextDecorator(true));
        SwtUtils.recursiveAdapt(this.managedForm.getToolkit(), (Control)this.generalInfoWidget, false, false, false, false);
        section.setClient((Control)this.generalInfoWidget);
    }

    private Section createSection(String text) {
        Section section = this.managedForm.getToolkit().createSection(this.managedForm.getForm().getBody(), ReviewEditor.getSectionStyle());
        section.addExpansionListener((IExpansionListener)this.activityListener);
        section.setLayoutData((Object)new TableWrapData2(256, 256));
        section.setText(text);
        return section;
    }

    private ToolBarManager createToolBar(Section section, String symbolicName) {
        final ToolBarManager toolBarManager = new ToolBarManager(131328);
        section.setTextClient((Control)toolBarManager.createControl((Composite)section));
        final IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)toolBarManager, "toolbar:com.smartbear.collaborator.ui.editors.ReviewEditor." + symbolicName);
            toolBarManager.update(false);
            toolBarManager.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    menuService.releaseContributions((ContributionManager)toolBarManager);
                }
            });
        }
        return toolBarManager;
    }

    private void initForm() {
        ScrolledForm form = this.managedForm.getForm();
        form.getBody().setLayout((Layout)new TableWrapLayout2());
        form.getHorizontalBar().addSelectionListener((SelectionListener)this.activityListener);
        form.getVerticalBar().addSelectionListener((SelectionListener)this.activityListener);
    }

    private IStyledTextDecorator createUserTextDecorator(boolean linkifyUrls) {
        CompositeStyledTextDecorator decorator = new CompositeStyledTextDecorator();
        decorator.add(AutomaticLinkStyledTextDecorator.create(this.model.getGeneralInfo().getTemplate().getAutomaticLinks(), (IWorkbenchSite)this.getEditorSite()));
        HashMap pathToFile = Maps.newHashMap();
        for (IScmMaterials materials : this.model.getMaterials()) {
            for (IReviewSummaryChangelist changelist : materials.getChangelists()) {
                for (IReviewSummaryFile file : changelist.getFiles()) {
                    pathToFile.put(file.getPath(), file);
                }
            }
        }
        decorator.add(new LinkToFileStyledTextDecorator(pathToFile, (IWorkbenchSite)this.getSite()));
        if (linkifyUrls) {
            decorator.add(new URLStyledTextDecorator((IWorkbenchSite)this.getSite()));
        }
        return decorator;
    }

    private static int getSectionStyle() {
        return 322;
    }
}

