/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.messages;

import com.smartbear.ccollab.datamodel.Assignment;
import com.smartbear.ccollab.datamodel.Review;
import com.smartbear.ccollab.datamodel.User;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.displaymodel.ChatThreadSet;

public class ReviewDisplayMessages {
    private Review review;
    private User user;

    public ReviewDisplayMessages(Review review, User currentUser) {
        this.review = review;
        this.user = currentUser;
    }

    private Review requireReview() {
        if (this.review == null) {
            throw new RuntimeException("No review specified");
        }
        return this.review;
    }

    private User requireUser() {
        if (this.user == null) {
            throw new RuntimeException("No current user specified");
        }
        return this.user;
    }

    public String getMovingOnHeader() {
        Review review = this.requireReview();
        if (review.getPhase() == Phase.INSPECTING) {
            return "Finishing the review";
        }
        if (review.getPhase() == Phase.REWORK) {
            return "Completing the rework phase";
        }
        if (review.getPhase() == Phase.PLANNING) {
            return "Completing the planning phase";
        }
        return null;
    }

    public String getMovingOnMessage() {
        Review review = this.requireReview();
        if (review.getPhase() == Phase.INSPECTING) {
            return this.getMovingOnMessageForInspecting();
        }
        if (review.getPhase() == Phase.REWORK) {
            User user = this.requireUser();
            Assignment assignment = review.getAssignmentForUser(user);
            if (assignment == null) {
                return "Because you are not assigned to this review, you cannot take any action here.";
            }
            if (assignment.getRole().isAuthor()) {
                return "Upload your fixes.  When you are finished, the other participants will be invited back to verify your fixes.";
            }
            return "The author is responsible for uploading fixes for the defects above.  When this happens, you will get a notification and the review will become active again for you.";
        }
        if (review.getPhase() == Phase.PLANNING) {
            return "When you have completed annotating the review materials, return to the review creation wizard begin the inspection phase.";
        }
        return null;
    }

    private String getMovingOnMessageForInspecting() {
        Review review = this.requireReview();
        User user = this.requireUser();
        Object whyCannotFinishReview = null;
        Assignment assignment = review.getAssignmentForUser(user);
        ChatThreadSet chat = review.getConversations();
        if (assignment == null) {
            whyCannotFinishReview = "You are not assigned to this review.  Only participants can finish reviews.";
        } else if (!assignment.getRole().isAllowedToFinishReviews()) {
            whyCannotFinishReview = "Your role, " + assignment.getRole().getDisplayName() + ", cannot finish reviews.  When all other participants have finished the review it will automatically go to the next phase.";
        } else if (assignment.isFinished()) {
            whyCannotFinishReview = "You have already indicated that you are finished with this review.  You can still make comments or open defects.";
        } else if (chat.hasNewConversations(user)) {
            whyCannotFinishReview = "You have unread comments.  You must either post a response or mark the comment as \"read\" before you can finish the review.";
        }
        if (whyCannotFinishReview == null) {
            if (review.getDefects().size() == 0) {
                return "No defects have been opened.  If you finish the review now, you are accepting these changes as-is.";
            }
            if (review.hasOpenDefects()) {
                return "There are open defects.  If you finish the review now, you are instructing the author to fix these defects.  You will be re-invited to the review when the author has uploaded fixes.";
            }
            return "All defects have been fixed.  If you finish the review now, you are accepting these changes as-is.  If another participant makes a significant additional comment, you will be re-invited to the review.";
        }
        return "Cannot complete the review: " + (String)whyCannotFinishReview;
    }
}

