/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.preferences;

import com.smartbear.collaborator.ui.preferences.ComboFieldEditor;
import com.smartbear.util.commons.ArrayUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;

public class ComboFieldEditorWithMRU
extends ComboFieldEditor {
    private static final String DIALOG_SETTINGS_MRU_SUFFIX = "MRU";
    private final String name;
    private final IDialogSettings dialogSettings;
    private final int mruSize;

    public ComboFieldEditorWithMRU(String name, String labelText, boolean caseSensitive, IDialogSettings dialogSettings, int mruSize, Composite parent) {
        super(name, labelText, dialogSettings.getArray(ComboFieldEditorWithMRU.getMRUDialogSettingsKey(name)), caseSensitive, false, parent);
        this.name = name;
        this.dialogSettings = dialogSettings;
        this.mruSize = mruSize;
    }

    private static String getMRUDialogSettingsKey(String name) {
        return name + DIALOG_SETTINGS_MRU_SUFFIX;
    }

    @Override
    protected void doStore() {
        String value = this.comboField.getText();
        if (StringUtils.isNotBlank((String)value)) {
            LinkedHashMap<String, String> mru = new LinkedHashMap<String, String>(this.mruSize, 1.0f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                    return this.size() > ComboFieldEditorWithMRU.this.mruSize;
                }
            };
            String[] items = this.comboField.getItems();
            for (int i = items.length - 1; i >= 0; --i) {
                mru.put(items[i], null);
            }
            mru.put(value, null);
            Object[] mruArray = mru.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
            ArrayUtils.reverse((Object[])mruArray);
            this.dialogSettings.put(ComboFieldEditorWithMRU.getMRUDialogSettingsKey(this.name), (String[])mruArray);
            this.comboField.setItems((String[])mruArray);
            this.comboField.setText(value);
        }
        super.doStore();
    }
}

