/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.preferences;

import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.utils.Hashing;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PasswordFieldEditor
extends StringFieldEditor {
    public PasswordFieldEditor(String labelText, Composite parent) {
        this.setLabelText(labelText);
        this.setValidateStrategy(0);
        this.createControl(parent);
        this.getTextControl().setEchoChar('*');
    }

    public void store() {
        String password = this.getTextControl().getText();
        this.getPreferenceStore().setToDefault("password");
        try {
            this.getPreferenceStore().setValue("serverPassKey", Hashing.getSecureHash((byte[])password.getBytes(), (boolean)true));
        }
        catch (GeneralSecurityException e) {
            CollaboratorUI.openError(CollaboratorUI.getShell(), "Error encrypting password", e, false, true);
        }
    }

    protected void doLoad() {
        Text textField = this.getTextControl();
        if (textField != null) {
            String value = PrefsHelper.getPrefs().getPassword();
            textField.setText(StringUtils.defaultString((String)value));
        }
    }

    protected void doLoadDefault() {
    }
}

