/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.preferences;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.ISimpleSaveDialogSettings;
import com.smartbear.util.commons.ArrayUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.apache.commons.lang.SerializationUtils;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesDialogSettings
implements ISimpleSaveDialogSettings {
    private Preferences prefs;

    public PreferencesDialogSettings(Preferences prefs) {
        this.prefs = prefs;
    }

    public IDialogSettings addNewSection(String name) {
        return new PreferencesDialogSettings(this.prefs.node(name));
    }

    public void addSection(IDialogSettings sectionToBeAdded) {
        if (!(sectionToBeAdded instanceof PreferencesDialogSettings)) {
            throw new UnsupportedOperationException("Could not add dialog settings section");
        }
        PreferencesDialogSettings prefsSectionToBeAdded = (PreferencesDialogSettings)sectionToBeAdded;
        PreferencesDialogSettings newSection = new PreferencesDialogSettings(this.prefs.node(prefsSectionToBeAdded.getName()));
        for (IDialogSettings iDialogSettings : prefsSectionToBeAdded.getSections()) {
            newSection.addSection(iDialogSettings);
        }
        try {
            for (String string : prefsSectionToBeAdded.prefs.keys()) {
                newSection.put(string, prefsSectionToBeAdded.prefs.get(string, null));
            }
        }
        catch (BackingStoreException backingStoreException) {
            CollaboratorUI.log("Could not copy Dialog Preferences section", backingStoreException);
        }
    }

    public String get(String key) {
        return this.prefs.get(key, null);
    }

    public String[] getArray(String key) {
        byte[] bytes = this.prefs.getByteArray(key, null);
        return bytes == null ? null : (String[])SerializationUtils.deserialize((byte[])bytes);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, false);
    }

    private String getNotNullValue(String key) throws NumberFormatException {
        String value = this.prefs.get(key, null);
        if (value == null) {
            throw new NumberFormatException("Key " + key + " not present");
        }
        return value;
    }

    public double getDouble(String key) throws NumberFormatException {
        return Double.parseDouble(this.getNotNullValue(key));
    }

    public float getFloat(String key) throws NumberFormatException {
        return Float.parseFloat(this.getNotNullValue(key));
    }

    public int getInt(String key) throws NumberFormatException {
        return Integer.parseInt(this.getNotNullValue(key));
    }

    public long getLong(String key) throws NumberFormatException {
        return Long.parseLong(this.getNotNullValue(key));
    }

    public String getName() {
        return this.prefs.name();
    }

    public IDialogSettings getSection(String sectionName) {
        try {
            if (this.prefs.nodeExists(sectionName)) {
                return new PreferencesDialogSettings(this.prefs.node(sectionName));
            }
        }
        catch (BackingStoreException e) {
            CollaboratorUI.log("Could not determine if section named '" + sectionName + "' exists", e);
        }
        return null;
    }

    public IDialogSettings[] getSections() {
        String[] childrenNames;
        try {
            childrenNames = this.prefs.childrenNames();
        }
        catch (BackingStoreException e) {
            CollaboratorUI.log("Could not get sub-sections", e);
            childrenNames = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        IDialogSettings[] sections = new IDialogSettings[childrenNames.length];
        for (int i = 0; i < childrenNames.length; ++i) {
            sections[i] = new PreferencesDialogSettings(this.prefs.node(childrenNames[i]));
        }
        return sections;
    }

    public void load(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void load(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void put(String key, String[] value) {
        this.prefs.putByteArray(key, SerializationUtils.serialize((Serializable)value));
    }

    public void put(String key, double value) {
        this.prefs.putDouble(key, value);
    }

    public void put(String key, float value) {
        this.prefs.putFloat(key, value);
    }

    public void put(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public void put(String key, long value) {
        this.prefs.putLong(key, value);
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public void put(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public void save(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void save(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            CollaboratorUI.log("Could not save dialog settings", e);
        }
    }
}

