/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.preferences;

import com.smartbear.CollabClientRuntimeException;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.preferences.PrefsWrapper;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.UIName;
import com.smartbear.collaborator.ui.preferences.ComboFieldEditor;
import com.smartbear.collaborator.ui.preferences.ComboFieldEditorWithMRU;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.URIUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ServerConnectionPage
extends FieldEditorPreferencePage {
    public static final String ID = "com.smartbear.collaborator.ui.ide.preferences.ServerConnectionPage";
    private static final String DIALOG_SETTINGS_SECTION = "Server Connection PrefPage";
    private static final int URLS_MRU_SIZE = 4;
    private static final String NETWORK_PREFS_PAGE_ID = "org.eclipse.ui.net.NetPreferences";
    private static final String USER_TIMEOUT_OVERRIDE = "smartbear.codecollaborator.test.connection.timeout";
    private static final String TIMEOUT = "smartbear.codecollaborator.xmlrpc.connection.timeout";
    private ComboFieldEditor url;
    private StringFieldEditor userLogin;
    private StringFieldEditor httpProxyUrl;
    private StringFieldEditor httpProxyPort;
    private BooleanFieldEditor overwriteTrustStoreInSSL;
    private final SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            final HashMap<String, Object> testPrefsStore = new HashMap<String, Object>();
            testPrefsStore.put("url", ServerConnectionPage.this.url.getStringValue());
            testPrefsStore.put("user", ServerConnectionPage.this.userLogin.getStringValue());
            testPrefsStore.put("overwriteTrustStoreInSSL", ServerConnectionPage.this.overwriteTrustStoreInSSL.getBooleanValue());
            if (ServerConnectionPage.this.getProxyStrategy() != ProxyStrategy.HIDE) {
                testPrefsStore.put("proxy", ServerConnectionPage.this.httpProxyUrl.getStringValue());
                testPrefsStore.put("port", ServerConnectionPage.this.httpProxyPort.getStringValue());
            }
            testPrefsStore.put("password", PrefsHelper.getPrefs().getPassword());
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(ServerConnectionPage.this.getShell());
                dialog.setOpenOnRun(true);
                dialog.setCancelable(false);
                dialog.run(true, false, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        CollabClientRuntimeException exception;
                        monitor.beginTask("Trying to connect to " + CollaboratorUI.PRODUCT_NAME + " Server", -1);
                        PrefsHelper testPrefsHelper = new PrefsHelper(new PrefsWrapper(){

                            public String getString(String key) {
                                return (String)testPrefsStore.get(key);
                            }

                            public String getString(String key, String defaultValue) {
                                if (testPrefsStore.containsKey(key)) {
                                    return this.getString(key);
                                }
                                return defaultValue;
                            }

                            public long getLong(String key) {
                                String value = this.getString(key);
                                return value != null ? Long.parseLong(value) : 0L;
                            }

                            public boolean getBoolean(String key) {
                                Boolean value = (Boolean)testPrefsStore.get(key);
                                return value;
                            }
                        });
                        Integer oldTimeout = System.getProperties().containsKey(ServerConnectionPage.TIMEOUT) ? Integer.getInteger(ServerConnectionPage.TIMEOUT) : null;
                        if (System.getProperties().containsKey(ServerConnectionPage.USER_TIMEOUT_OVERRIDE)) {
                            System.setProperty(ServerConnectionPage.TIMEOUT, Integer.getInteger(ServerConnectionPage.USER_TIMEOUT_OVERRIDE).toString());
                        } else {
                            System.setProperty(ServerConnectionPage.TIMEOUT, Integer.toString(1000));
                        }
                        try {
                            Collaborator.testClientConnection((PrefsHelper)testPrefsHelper);
                            exception = null;
                        }
                        catch (CollabClientRuntimeException e) {
                            exception = e;
                        }
                        finally {
                            if (oldTimeout != null) {
                                System.setProperty(ServerConnectionPage.TIMEOUT, oldTimeout.toString());
                            } else {
                                System.getProperties().remove(ServerConnectionPage.TIMEOUT);
                            }
                        }
                        CollabClientRuntimeException finalException = exception;
                        Display.getDefault().asyncExec(new Runnable((Exception)((Object)finalException)){
                            final /* synthetic */ Exception val$finalException;
                            {
                                this.val$finalException = exception;
                            }

                            @Override
                            public void run() {
                                if (this.val$finalException == null) {
                                    MessageDialog.openInformation((Shell)ServerConnectionPage.this.getShell(), (String)"Test", (String)("Successfully connected to the " + CollaboratorUI.PRODUCT_NAME + " Server."));
                                } else {
                                    CollaboratorUI.openError(ServerConnectionPage.this.getShell(), "Could not verify connection to " + CollaboratorUI.PRODUCT_NAME + " Server", this.val$finalException, false, false);
                                }
                            }
                        });
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                CollaboratorUI.log("Could not test connection to " + CollaboratorUI.PRODUCT_NAME + " server", e);
            }
            catch (InterruptedException e) {
                CollaboratorUI.log("Could not test connection to " + CollaboratorUI.PRODUCT_NAME + " server", e);
            }
        }
    };
    private ProxyStrategy proxyStrategy;

    public ServerConnectionPage() {
        super(1);
        this.setTitle("Server Connection");
        this.setDescription("Enter Collaborator Server URL and credentials\n\n");
    }

    public IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.smartbear.collaborator");
    }

    private ProxyStrategy getProxyStrategy() {
        if (this.proxyStrategy == null) {
            PrefsHelper prefs;
            boolean hasNetworkPrefsPage = false;
            for (Object preferenceNode : ((PreferenceDialog)this.getContainer()).getPreferenceManager().getElements(0)) {
                if (!StringUtils.equals((String)((IPreferenceNode)preferenceNode).getId(), (String)NETWORK_PREFS_PAGE_ID)) continue;
                hasNetworkPrefsPage = true;
                break;
            }
            this.proxyStrategy = !hasNetworkPrefsPage ? ProxyStrategy.SHOW : (StringUtils.isNotBlank((String)(prefs = PrefsHelper.getPrefs()).getHttpProxy()) || StringUtils.isNotBlank((String)prefs.getHttpPort()) ? ProxyStrategy.DEPRECATE : ProxyStrategy.HIDE);
        }
        return this.proxyStrategy;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        SwtUtils.setName((Widget)composite, UIName.PREFS_SERVER_CONNECTION_PAGE);
        GridDataFactory gridDataFactory = GridDataFactory.swtDefaults().span(2, 1);
        if (this.getProxyStrategy().isShowLink()) {
            Control preferenceLinkArea = new PreferenceLinkArea(composite, 0, NETWORK_PREFS_PAGE_ID, "Set up your proxy settings in <a>{0}</a>.", (IWorkbenchPreferenceContainer)this.getContainer(), null).getControl();
            preferenceLinkArea.setLayoutData((Object)gridDataFactory.create());
        }
        Button test = new Button(composite, 0);
        test.setLayoutData((Object)gridDataFactory.create());
        test.setText("&Test Connection");
        SwtUtils.setName((Widget)test, UIName.PREFS_SERVER_CONNECTION_PAGE_TEST_CONNECTION);
        test.addSelectionListener((SelectionListener)this.selectionAdapter);
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Button defaults = this.getDefaultsButton();
        if (defaults != null) {
            defaults.setVisible(false);
        }
    }

    private IDialogSettings getDialogSettingsSection() {
        return CollaboratorUI.getDialogSettingsSection(CollaboratorUI.getDialogSettings(), DIALOG_SETTINGS_SECTION);
    }

    public void dispose() {
        super.dispose();
        CollaboratorUI.saveDialogSettings();
    }

    protected void createFieldEditors() {
        Composite fieldEditorParent = this.getFieldEditorParent();
        this.url = new ComboFieldEditorWithMRU("url", "&Server URL:", true, this.getDialogSettingsSection(), 4, fieldEditorParent){

            @Override
            protected boolean doCheckState() {
                String value = this.getStringValue();
                if (StringUtils.isBlank((String)value)) {
                    this.setErrorMessage("Must specify a Server URL");
                    return false;
                }
                try {
                    URL url = new URL(value);
                    URIUtils.validateUrl((URL)url);
                    return true;
                }
                catch (MalformedURLException e) {
                    this.setErrorMessage(e.getMessage());
                    return false;
                }
            }
        };
        SwtUtils.setName((Widget)this.url.getComboControl(fieldEditorParent), UIName.PREFS_SERVER_CONNECTION_PAGE_URL);
        this.addField(this.url);
        fieldEditorParent = this.getFieldEditorParent();
        this.userLogin = new StringFieldEditor("user", "Username:", fieldEditorParent);
        this.addField((FieldEditor)this.userLogin);
        SwtUtils.setName((Widget)this.userLogin.getTextControl(fieldEditorParent), UIName.PREFS_SERVER_CONNECTION_PAGE_USERNAME);
        if (this.getProxyStrategy() != ProxyStrategy.HIDE) {
            String nameSuffix = this.getProxyStrategy() == ProxyStrategy.DEPRECATE ? " (deprecated)" : "";
            Composite fieldEditorParent2 = this.getFieldEditorParent();
            this.httpProxyUrl = new StringFieldEditor("proxy", "Proxy Host:" + nameSuffix, fieldEditorParent2);
            this.addField((FieldEditor)this.httpProxyUrl);
            SwtUtils.setName((Widget)this.httpProxyUrl.getTextControl(fieldEditorParent2), UIName.PREFS_SERVER_CONNECTION_PAGE_PROXY_HOST);
            fieldEditorParent2 = this.getFieldEditorParent();
            this.httpProxyPort = new StringFieldEditor("port", "Proxy Port:" + nameSuffix, fieldEditorParent2){

                protected boolean doCheckState() {
                    try {
                        String value = this.getStringValue();
                        if (value == null) {
                            return true;
                        }
                        value.trim();
                        if ("".equals(value)) {
                            return true;
                        }
                        Integer.parseInt(this.getStringValue());
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            };
            this.httpProxyPort.setErrorMessage("Proxy Port must be an integer");
            this.addField((FieldEditor)this.httpProxyPort);
            SwtUtils.setName((Widget)this.httpProxyPort.getTextControl(fieldEditorParent2), UIName.PREFS_SERVER_CONNECTION_PAGE_PROXY_PORT);
        }
        this.overwriteTrustStoreInSSL = new BooleanFieldEditor("overwriteTrustStoreInSSL", "Overwrite Trust Store in SSL", this.getFieldEditorParent());
        this.addField((FieldEditor)this.overwriteTrustStoreInSSL);
        SwtUtils.setName((Widget)this.overwriteTrustStoreInSSL.getDescriptionControl(this.getFieldEditorParent()), UIName.PREFS_SERVER_CONNECTION_PAGE_OVERWRITE_TRUST_STORE_INSSL);
    }

    private static enum ProxyStrategy {
        SHOW(false),
        HIDE(true),
        DEPRECATE(true);

        private final boolean showLink;

        private ProxyStrategy(boolean showLink) {
            this.showLink = showLink;
        }

        public boolean isShowLink() {
            return this.showLink;
        }
    }
}

