/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.jface.CellLabelProvider2;
import com.smartbear.jface.IStructuredContentProvider2;
import com.smartbear.jface.TableViewer2;
import com.smartbear.jface.TableViewerColumn2;
import com.smartbear.jface.ViewerComparator2;
import java.util.LinkedHashMap;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchSite;

public abstract class BaseTableViewerWidget<I, E> {
    protected final LinkedHashMap<Integer, Column> columnByIndex = new LinkedHashMap();
    protected final TableViewer2<I, E> tableViewer;
    protected final I input;
    protected IWorkbenchSite site;

    public BaseTableViewerWidget(Composite parent, int style, I input, IWorkbenchSite site) {
        this.input = input;
        this.site = site;
        this.tableViewer = TableViewer2.create(new Table(parent, style | 0x800 | 2 | 0x10000));
        this.initTable();
        this.initColumns();
        this.initTableViewer();
    }

    public BaseTableViewerWidget(Composite parent, int style, I input, IWorkbenchSite site, Composite left) {
        this.input = input;
        this.site = site;
        this.tableViewer = TableViewer2.create(new Table(left, style | 0x800 | 2 | 0x10000));
        this.initTable();
        this.initColumns();
        this.initTableViewer();
    }

    protected abstract Iterable<? extends Column> createColumns();

    protected abstract IStructuredContentProvider2<I, E> createContentProvider();

    protected ViewerComparator2<E> getComparator() {
        return null;
    }

    protected Table initTable() {
        Table table = this.tableViewer.getControl();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        return table;
    }

    private void initTableViewer() {
        this.tableViewer.setContentProvider(this.createContentProvider());
        this.tableViewer.setInput(this.input);
        this.tableViewer.setComparator(this.getComparator());
    }

    protected void initColumns() {
        Table table = this.tableViewer.getControl();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer.getInner());
        for (final Column c : this.createColumns()) {
            TableColumn col = new TableColumn(table, 0);
            col.setText(c.getLabel());
            col.setMoveable(true);
            col.setResizable(true);
            TableViewerColumn2<E> viewerColumn = new TableViewerColumn2<E>(this.tableViewer, col);
            viewerColumn.setLabelProvider(new CellLabelProvider2<E>(){

                @Override
                public void update(ViewerCell cell, E element) {
                    cell.setText(c.getSingleLineText(element));
                    cell.setImage(c.getImage(element));
                }

                @Override
                public String getToolTipText(E element) {
                    return c.getFullText(element);
                }
            });
            TableLayout layout = (TableLayout)table.getLayout();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(c.getWeight(), true));
        }
    }

    public Table getControl() {
        return this.tableViewer.getControl();
    }

    protected abstract class Column {
        protected Column() {
        }

        protected abstract int getWeight();

        protected abstract String getLabel();

        protected String getSingleLineText(E element) {
            return this.getFullText(element).replaceAll("\n", " ");
        }

        protected abstract String getFullText(E var1);

        protected Image getImage(E e) {
            return null;
        }
    }
}

