/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.conversation.CommandConversationAccept;
import com.smartbear.ccollab.client.commands.admin.review.conversation.CommandConversationMarkRead;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.IReviewConversation;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.swt.Button2;
import com.smartbear.swt.SwtUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

class CommentLogButtonsWidget
extends Composite {
    private final IConversation conversation;
    private final Button2 acceptButton;
    private final Button2 markReadButton;
    private final IConversationListener conversationListener = new ReviewConversationAdapter(){

        public void isReadChanged(IReviewConversation conversation, boolean isRead) {
            CommentLogButtonsWidget.this.updateButtons();
        }

        public void whyNotAllowedToAcceptChanged(IReviewConversation conversation, String whyNotAllowedToAccept) {
            CommentLogButtonsWidget.this.updateButtons();
        }
    };

    public CommentLogButtonsWidget(Composite parent, int style, final IConversation conversation, final ICommandRunner commandRunner) {
        super(parent, style);
        this.conversation = conversation;
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.numColumns = 2;
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        this.setLayout((Layout)buttonsLayout);
        this.acceptButton = new Button2(this, 8);
        this.acceptButton.setText("Accept");
        this.acceptButton.setLayoutData(new GridData());
        this.acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                commandRunner.run((Command)new CommandConversationAccept(), true);
            }
        });
        this.markReadButton = new Button2(this, 8);
        this.markReadButton.setText("Mark Read");
        this.markReadButton.setDisabledToolTipText("No unread comments");
        this.markReadButton.setLayoutData(new GridData());
        this.markReadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                commandRunner.run((Command)new CommandConversationMarkRead(), true);
            }
        });
        conversation.addConversationListener(this.conversationListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                conversation.removeConversationListener(CommentLogButtonsWidget.this.conversationListener);
            }
        });
        ReviewConversationAdapter.init((IReviewConversation)((IReviewConversation)conversation), (IReviewConversationListener)((IReviewConversationListener)this.conversationListener));
    }

    protected void updateButtons() {
        String whyNotAllowedToAccept = this.conversation.getWhyNotAllowedToAccept();
        this.acceptButton.setDisabledToolTipText(SwtUtils.escapeMnemonics(whyNotAllowedToAccept));
        this.acceptButton.setEnabled(StringUtils.isBlank((String)whyNotAllowedToAccept));
        this.markReadButton.setEnabled(!this.conversation.isRead());
    }
}

