/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.comment.CommandCommentRedact;
import com.smartbear.ccollab.client.commands.argrefs.CommentRefById;
import com.smartbear.ccollab.client.commands.argrefs.ICommentRef;
import com.smartbear.ccollab.datamodel.client.IComment;
import com.smartbear.ccollab.datamodel.client.IContributor;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.PublishState;
import com.smartbear.ccollab.datamodel.client.listener.ICommentListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.CommentAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.ZeroDefaultSizeComposite;
import com.smartbear.swt.text.IStyledTextDecorator;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

class CommentLogWidget
extends ZeroDefaultSizeComposite {
    private final IConversationListener conversationListener = new ReviewConversationAdapter(){

        public void commentsAdded(IConversation conversation, ArrayList<? extends IComment> newComments) {
            for (IComment iComment : newComments) {
                CommentLogWidget.this.addComment(iComment);
            }
            SwtUtils.reflowForm((Control)CommentLogWidget.this);
        }
    };
    private final ICommandRunner commandRunner;
    private final IStyledTextDecorator userTextDecorator;

    public CommentLogWidget(Composite parent, int style, final IConversation conversation, ICommandRunner commandRunner, IStyledTextDecorator userTextDecorator) {
        super(parent, style);
        this.commandRunner = commandRunner;
        this.userTextDecorator = userTextDecorator;
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        SwtUtils.setMargins(layout, 0);
        this.setLayout((Layout)layout);
        for (IComment comment : conversation.getComments()) {
            this.addComment(comment);
        }
        conversation.addConversationListener(this.conversationListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                conversation.removeConversationListener(CommentLogWidget.this.conversationListener);
            }
        });
    }

    private void addComment(final IComment comment) {
        final StyledText authorText = new StyledText((Composite)this, 8);
        authorText.setLayoutData((Object)new TableWrapData(128));
        IContributor creator = (IContributor)comment.getCreator();
        authorText.setText((String)(creator == null ? "" : StringUtils.defaultString((String)creator.getInitials()) + ":"));
        final StyledText commentText = new StyledText((Composite)this, 74);
        commentText.setLayoutData((Object)new TableWrapData(256));
        commentText.setText(StringUtils.defaultString((String)comment.getText()));
        this.userTextDecorator.decorate(commentText);
        authorText.setBackground(Display.getDefault().getSystemColor(7));
        commentText.setBackground(Display.getDefault().getSystemColor(7));
        Menu contextMenu = new Menu((Decorations)commentText.getShell(), 8);
        commentText.setMenu(contextMenu);
        final MenuItem redactMenuItem = new MenuItem(contextMenu, 8);
        redactMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandCommentRedact cmd = new CommandCommentRedact();
                cmd.setComment((ICommentRef)new CommentRefById(comment.getId()));
                CommentLogWidget.this.commandRunner.run((Command)cmd, true);
            }
        });
        CommentAdapter commentListener = new CommentAdapter(){

            public void markedRead(IComment comment) {
                authorText.setBackground(null);
                commentText.setBackground(null);
            }

            public void publishStateChanged(IComment comment, PublishState publishState) {
                publishState.accept((PublishState.IPublishStateVisitor)new PublishState.IPublishStateVisitor<Void>(){

                    public Void visitSent() {
                        return null;
                    }

                    public Void visitRedacted() {
                        StyleRange styleRange = new StyleRange();
                        styleRange.strikeout = true;
                        styleRange.fontStyle = 2;
                        styleRange.foreground = Display.getDefault().getSystemColor(15);
                        styleRange.start = 0;
                        styleRange.length = authorText.getText().length();
                        SwtUtils.addStyle(authorText, styleRange);
                        styleRange.length = commentText.getText().length();
                        SwtUtils.addStyle(commentText, styleRange);
                        return null;
                    }
                });
            }

            public void whyNotAllowedToRedactChanged(IComment comment, String whyNotAllowedToRedact) {
                if (StringUtils.isBlank((String)whyNotAllowedToRedact)) {
                    redactMenuItem.setEnabled(true);
                    redactMenuItem.setText("&Redact");
                } else {
                    redactMenuItem.setEnabled(false);
                    redactMenuItem.setText("&Redact (" + SwtUtils.escapeMnemonics(whyNotAllowedToRedact) + ")");
                }
            }
        };
        comment.addCommentListener((ICommentListener)commentListener);
        this.addDisposeListener(new DisposeListener((ICommentListener)commentListener){
            final /* synthetic */ ICommentListener val$commentListener;
            {
                this.val$commentListener = iCommentListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                comment.removeCommentListener(this.val$commentListener);
            }
        });
        CommentAdapter.init((IComment)comment, (ICommentListener)commentListener);
    }

    public void setEditable(boolean editable) {
        for (Control child : this.getChildren()) {
            child.setEnabled(editable);
        }
    }
}

