/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.CommentLogButtonsWidget;
import com.smartbear.collaborator.ui.review.CommentLogWidget;
import com.smartbear.collaborator.ui.review.CreateCommentWidget;
import com.smartbear.collaborator.ui.review.CreateDefectWidget;
import com.smartbear.collaborator.ui.review.DefectLogWidget;
import com.smartbear.collaborator.ui.review.ITextReciever;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.TopStackLayout;
import com.smartbear.swt.ZeroDefaultSizeComposite;
import com.smartbear.swt.text.IStyledTextDecorator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ConversationWidget
extends Composite {
    private CommentLogWidget commentLog;
    private Button createCommentRadioButton;
    private Button createDefectRadioButton;
    private CreateCommentWidget createCommentWidget;
    private CreateDefectWidget createDefectWidget;
    private DefectLogWidget defectLog;
    private TopStackLayout createLayout;

    public ConversationWidget(Composite parent, int compositeStyle, Set<Style> style, FormToolkit formToolkit, IClientSystemGlobals clientSystemGlobals, IConversationProvider conversationProvider, IConversation conversation, List<? extends ICustomField> defectCustomFields, ICommandRunner commandRunner, IStyledTextDecorator userTextDecorator, ISaveableListener saveableListener) {
        super(parent, compositeStyle);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        SwtUtils.setMargins(layout, 0);
        this.setLayout((Layout)layout);
        if (conversation != null && style.contains((Object)Style.COMMENTS)) {
            this.commentLog = new CommentLogWidget(this, SwtUtils.BASE_COMPOSITE_STYLE, conversation, commandRunner, userTextDecorator);
            this.commentLog.setLayoutData(new TableWrapData(128, 128));
        }
        ZeroDefaultSizeComposite buttonsComposite = new ZeroDefaultSizeComposite(this, SwtUtils.BASE_COMPOSITE_STYLE);
        buttonsComposite.setLayoutData(new TableWrapData(256));
        GridLayout layout2 = GridLayoutFactory.swtDefaults().numColumns(2).create();
        SwtUtils.setMargins(layout2, 0);
        buttonsComposite.setLayout((Layout)layout2);
        if (conversation != null && style.contains((Object)Style.COMMENTS)) {
            CommentLogButtonsWidget commentLogButtons = new CommentLogButtonsWidget(buttonsComposite, SwtUtils.BASE_COMPOSITE_STYLE, conversation, commandRunner);
            commentLogButtons.setLayoutData(GridDataFactory.swtDefaults().span(2, 1).create());
        }
        if (style.contains((Object)Style.COMMENTS) && style.contains((Object)Style.DEFECTS)) {
            this.createCommentRadioButton = new Button((Composite)buttonsComposite, 16);
            this.createCommentRadioButton.setText("&Comment");
            this.createDefectRadioButton = new Button((Composite)buttonsComposite, 16);
            this.createDefectRadioButton.setText("&" + WordUtils.capitalize((String)clientSystemGlobals.getDefectLabelSingular()));
            this.createCommentRadioButton.setSelection(true);
        } else {
            this.createCommentRadioButton = null;
            this.createDefectRadioButton = null;
        }
        final Composite createComposite = new Composite((Composite)this, SwtUtils.BASE_COMPOSITE_STYLE);
        createComposite.setLayoutData((Object)new TableWrapData(256, 256));
        this.createLayout = new TopStackLayout();
        createComposite.setLayout((Layout)this.createLayout);
        this.createCommentWidget = new CreateCommentWidget(createComposite, SwtUtils.BASE_COMPOSITE_STYLE, conversationProvider, commandRunner, userTextDecorator);
        this.createDefectWidget = new CreateDefectWidget(createComposite, SwtUtils.BASE_COMPOSITE_STYLE, clientSystemGlobals, conversationProvider, commandRunner, userTextDecorator);
        if (style.contains((Object)Style.COMMENTS)) {
            this.createLayout.topControl = this.createCommentWidget;
        } else if (style.contains((Object)Style.DEFECTS)) {
            this.createLayout.topControl = this.createDefectWidget;
        }
        if (style.contains((Object)Style.COMMENTS) && style.contains((Object)Style.DEFECTS)) {
            SelectionAdapter toggleListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Composite visibleControl;
                    if (ConversationWidget.this.createDefectRadioButton.getSelection()) {
                        visibleControl = ConversationWidget.this.createDefectWidget;
                        ConversationWidget.this.createDefectWidget.setText(ConversationWidget.this.createCommentWidget.getText());
                    } else {
                        visibleControl = ConversationWidget.this.createCommentWidget;
                        ConversationWidget.this.createCommentWidget.setText(ConversationWidget.this.createDefectWidget.getText());
                    }
                    ConversationWidget.this.createLayout.topControl = visibleControl;
                    createComposite.layout();
                    SwtUtils.reflowForm((Control)visibleControl);
                }
            };
            this.createCommentRadioButton.addSelectionListener((SelectionListener)toggleListener);
            this.createDefectRadioButton.addSelectionListener((SelectionListener)toggleListener);
        }
        if (conversation != null && style.contains((Object)Style.DEFECTS)) {
            this.defectLog = new DefectLogWidget(this, SwtUtils.BASE_COMPOSITE_STYLE, formToolkit, clientSystemGlobals, conversation, defectCustomFields, commandRunner, saveableListener, userTextDecorator);
            this.defectLog.setData(new TableWrapData(256, 256));
        }
    }

    public DefectLogWidget getDefectLog() {
        return this.defectLog;
    }

    public void setEditable(boolean editable) {
        if (this.commentLog != null) {
            this.commentLog.setEditable(editable);
        }
        if (this.createCommentRadioButton != null) {
            this.createCommentRadioButton.setEnabled(editable);
        }
        if (this.createDefectRadioButton != null) {
            this.createDefectRadioButton.setEnabled(editable);
        }
        this.createCommentWidget.setEditable(editable);
        this.createDefectWidget.setEditable(editable);
        if (this.defectLog != null) {
            this.defectLog.setEditable(editable);
        }
    }

    public boolean setFocus() {
        return this.createLayout.topControl.setFocus();
    }

    public void keyPressed(KeyEvent e) {
        if (this.isDisposed()) {
            return;
        }
        ((ITextReciever)this.createLayout.topControl).keyPressed(e);
    }

    public static enum Style {
        COMMENTS{

            @Override
            public boolean isImportant(IConversation conversation) {
                return !conversation.getComments().isEmpty();
            }
        }
        ,
        DEFECTS{

            @Override
            public boolean isImportant(IConversation conversation) {
                return !conversation.getDefects().isEmpty();
            }
        };


        public abstract boolean isImportant(IConversation var1);

        public static boolean isImportant(Set<Style> styles, IConversation conversation) {
            for (Style style : styles) {
                if (!style.isImportant(conversation)) continue;
                return true;
            }
            return false;
        }
    }
}

