/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.comment.CommandCommentCreate;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.listener.IConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationProviderAdapter;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.collaborator.ui.review.ITextReciever;
import com.smartbear.swt.Button2;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.IStyledTextDecorator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

class CreateCommentWidget
extends Composite
implements ITextReciever {
    private final IConversationProvider conversationProvider;
    private final ICommandRunner commandRunner;
    private final StyledText newChatText;
    private final Button2 submitButton;
    private boolean editable = true;
    private final IConversationProviderListener listener = new ConversationProviderAdapter(){

        public void whyNotAllowedToCreateCommentChanged(IConversationProvider conversationProvider, String whyNotAllowedToCreateComment) {
            CreateCommentWidget.this.updateEnablement();
        }
    };

    public CreateCommentWidget(Composite parent, int style, final IConversationProvider conversationProvider, ICommandRunner commandRunner, final IStyledTextDecorator userTextDecorator) {
        super(parent, style);
        this.conversationProvider = conversationProvider;
        this.commandRunner = commandRunner;
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        SwtUtils.setMargins(layout, 0);
        this.setLayout((Layout)layout);
        this.newChatText = new StyledText((Composite)this, 2114);
        this.newChatText.setLayoutData((Object)new TableWrapData(256));
        this.newChatText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwtUtils.clearStylesAndLinks(CreateCommentWidget.this.newChatText);
                userTextDecorator.decorate(CreateCommentWidget.this.newChatText);
                SwtUtils.resizeVerticalIfNecessary((Control)CreateCommentWidget.this.newChatText);
                CreateCommentWidget.this.updateEnablement();
            }
        });
        this.submitButton = new Button2(this, 8);
        this.submitButton.setLayoutData(new TableWrapData(8));
        this.submitButton.setText("Submit");
        this.submitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateCommentWidget.this.submit();
            }
        });
        this.newChatText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
                    e.doit = false;
                    if (CreateCommentWidget.this.submitButton.isEnabled()) {
                        CreateCommentWidget.this.submit();
                    }
                }
            }
        });
        conversationProvider.addConversationProviderListener(this.listener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                conversationProvider.removeConversationProviderListener(CreateCommentWidget.this.listener);
            }
        });
        ConversationProviderAdapter.init((IConversationProvider)conversationProvider, (IConversationProviderListener)this.listener);
    }

    private void submit() {
        CommandCommentCreate command = new CommandCommentCreate();
        command.setComment(this.newChatText.getText());
        this.commandRunner.run((Command)command, true);
        this.newChatText.setText("");
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.updateEnablement();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean setFocus() {
        return this.newChatText.setFocus();
    }

    private void updateEnablement() {
        String whyNot = this.conversationProvider.getWhyNotAllowedToCreateComment();
        if (StringUtils.isBlank((String)whyNot) && StringUtils.isBlank((String)this.newChatText.getText())) {
            whyNot = "Comment text must not be blank";
        }
        if (StringUtils.isBlank((String)whyNot)) {
            whyNot = null;
        }
        this.submitButton.setDisabledToolTipText(SwtUtils.escapeMnemonics(whyNot));
        this.newChatText.setEnabled(this.isEditable());
        this.submitButton.setEnabled(this.isEditable() && StringUtils.isBlank((String)whyNot));
    }

    @Override
    public void setText(String text) {
        this.newChatText.setText(StringUtils.defaultString((String)text));
        this.updateEnablement();
    }

    @Override
    public String getText() {
        return this.newChatText.getText();
    }

    public void keyPressed(KeyEvent e) {
        ITextReciever.Util.handleKeyPress(this, e, (Control)this.newChatText);
    }

    public void keyReleased(KeyEvent e) {
    }
}

