/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectCreate;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.listener.IConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationProviderAdapter;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.DefectWidget;
import com.smartbear.collaborator.ui.review.ITextReciever;
import com.smartbear.swt.Button2;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.SmartBearUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CreateDefectWidget
extends Composite
implements ITextReciever {
    private final IConversationProvider conversationProvider;
    private final ICommandRunner commandRunner;
    private final DefectWidget newDefectWidget;
    private final Button2 createButton;
    private boolean editable = true;
    private final ISaveableListener saveableListener = new ISaveableListener(){

        @Override
        public void dirtyStateMayHaveChanged() {
            CreateDefectWidget.this.updateEnablement();
        }
    };

    public CreateDefectWidget(Composite parent, int style, IClientSystemGlobals clientSystemGlobals, final IConversationProvider conversationProvider, ICommandRunner commandRunner, IStyledTextDecorator textDecorator) {
        super(parent, style);
        this.conversationProvider = conversationProvider;
        this.commandRunner = commandRunner;
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        SwtUtils.setMargins(layout, 0);
        this.setLayout((Layout)layout);
        this.newDefectWidget = new DefectWidget(this, SwtUtils.BASE_COMPOSITE_STYLE, conversationProvider.getDefectCustomFields(), clientSystemGlobals, commandRunner, this.saveableListener, textDecorator, new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
                    e.doit = false;
                    if (CreateDefectWidget.this.createButton != null && CreateDefectWidget.this.createButton.isEnabled()) {
                        CreateDefectWidget.this.create();
                    }
                }
            }
        });
        this.newDefectWidget.setLayoutData(new TableWrapData(256));
        this.createButton = new Button2(this, 8);
        this.createButton.setLayoutData(new TableWrapData(8));
        this.createButton.setText("Create");
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateDefectWidget.this.create();
            }
        });
        ConversationProviderAdapter conversationProviderListener = new ConversationProviderAdapter(){

            public void whyNotAllowedToCreateDefectChanged(IConversationProvider conversationProvider, String whyNotAllowedToCreateDefect) {
                CreateDefectWidget.this.updateEnablement();
            }
        };
        conversationProvider.addConversationProviderListener((IConversationProviderListener)conversationProviderListener);
        this.addDisposeListener(new DisposeListener((IConversationProviderListener)conversationProviderListener){
            final /* synthetic */ IConversationProviderListener val$conversationProviderListener;
            {
                this.val$conversationProviderListener = iConversationProviderListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                conversationProvider.removeConversationProviderListener(this.val$conversationProviderListener);
            }
        });
        ConversationProviderAdapter.init((IConversationProvider)conversationProvider, (IConversationProviderListener)conversationProviderListener);
    }

    private void create() {
        CommandDefectCreate createCommand = this.newDefectWidget.getCreateCommand();
        this.commandRunner.run((Command)createCommand, true);
        this.newDefectWidget.setText("");
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.updateEnablement();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean setFocus() {
        return this.newDefectWidget.setFocus();
    }

    private void updateEnablement() {
        String whyNot = this.conversationProvider.getWhyNotAllowedToCreateDefect();
        if (StringUtils.isBlank((String)whyNot)) {
            whyNot = (String)SmartBearUtils.getFirstObject(this.newDefectWidget.getErrorMessages());
        }
        if (StringUtils.isBlank((String)whyNot)) {
            whyNot = null;
        }
        this.newDefectWidget.setEditable(this.isEditable());
        this.createButton.setDisabledToolTipText(SwtUtils.escapeMnemonics(whyNot));
        this.createButton.setEnabled(this.isEditable() && StringUtils.isBlank((String)whyNot));
    }

    @Override
    public void setText(String text) {
        this.newDefectWidget.setText(text);
        this.updateEnablement();
    }

    @Override
    public String getText() {
        return this.newDefectWidget.getText();
    }

    public void keyPressed(KeyEvent e) {
        this.newDefectWidget.keyPressed(e);
        this.updateEnablement();
    }

    public void keyReleased(KeyEvent e) {
        this.newDefectWidget.keyReleased(e);
        this.updateEnablement();
    }
}

