/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.smartbear.ccollab.client.commands.argrefs.ICustomFieldRef;
import com.smartbear.ccollab.datamodel.client.IChecklistItem;
import com.smartbear.ccollab.datamodel.client.IContributor;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.ICustomFieldTarget;
import com.smartbear.ccollab.datamodel.client.IReviewGeneralInfo;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewParticipant;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IUser;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.listener.ICustomFieldListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewGeneralInfoListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.CustomFieldAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewGeneralInfoAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.user.request.UserIdRequest;
import com.smartbear.collaborator.json.interfaces.user.response.UserLoginResponse;
import com.smartbear.collaborator.json.utils.JsonUtils;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.customfield.CustomFieldWidgetFactory;
import com.smartbear.collaborator.ui.customfield.ICustomFieldWidget;
import com.smartbear.collections.Pair;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.TableWrapData2;
import com.smartbear.swt.TableWrapLayout2;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class CustomFieldTargetWidget
extends Composite {
    private final ICustomFieldWidget.ICustomFieldWidgetModifyListener widgetModifyListener = new ICustomFieldWidget.ICustomFieldWidgetModifyListener(){

        @Override
        public void widgetModified(ICustomFieldWidget widget, HashSet<String> newValue) {
            CustomFieldTargetWidget.this.saveableListener.dirtyStateMayHaveChanged();
        }
    };
    private final IReviewGeneralInfoListener modifyListener = new ReviewGeneralInfoAdapter(){

        public void whyNotAllowedToModifyChanged(IReviewGeneralInfo generalInfo, String whyNotAllowedToModify) {
            boolean editable = StringUtils.isBlank((String)whyNotAllowedToModify);
            for (ICustomFieldWidget widget : CustomFieldTargetWidget.this.customFieldWidgets.values()) {
                widget.setEditable(editable);
            }
        }
    };
    private final IReviewMovingOnListener phaseVisiblityListener = new ReviewMovingOnAdapter(){

        public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
            CustomFieldTargetWidget.this.updateVisibility();
        }
    };
    private final ICustomFieldListener customFieldListener = new ICustomFieldListener(){

        public void customFieldChanged(ICustomFieldTarget target, ICustomField customField, HashSet<String> newValue) {
            CustomFieldTargetWidget.this.customFieldWidgets.get(customField).setValue(newValue);
            CustomFieldTargetWidget.this.saveableListener.dirtyStateMayHaveChanged();
        }
    };
    private ICustomFieldTarget target;
    private final IReviewSummary reviewSummary;
    private final ISaveableListener saveableListener;
    private final Map<ICustomField, Label> customFieldLabels = Maps.newHashMap();
    private final Map<ICustomField, ICustomFieldWidget> customFieldWidgets = Maps.newHashMap();
    protected IReviewParticipant currentParticipant;

    public CustomFieldTargetWidget(Composite parent, int style, final IReviewSummary reviewSummary, ISaveableListener saveableListener) {
        super(parent, style);
        this.reviewSummary = reviewSummary;
        this.saveableListener = saveableListener;
        super.setLayout((Layout)this.createLayout());
        reviewSummary.getGeneralInfo().addReviewGeneralInfoListener(this.modifyListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.getGeneralInfo().removeReviewGeneralInfoListener(CustomFieldTargetWidget.this.modifyListener);
            }
        });
        reviewSummary.getMovingOn().addMovingOnListener(this.phaseVisiblityListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.getMovingOn().removeMovingOnListener(CustomFieldTargetWidget.this.phaseVisiblityListener);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CustomFieldTargetWidget.this.target != null) {
                    CustomFieldAdapter.removeListener((ICustomFieldTarget)CustomFieldTargetWidget.this.target, CustomFieldTargetWidget.this.customFieldWidgets.keySet(), (ICustomFieldListener)CustomFieldTargetWidget.this.customFieldListener);
                }
            }
        });
    }

    protected TableWrapLayout2 createLayout() {
        TableWrapLayout2 layout = new TableWrapLayout2();
        layout.numColumns = 4;
        layout.horizontalSpacing = 8;
        return layout;
    }

    protected void addCustomFieldControls(Collection<? extends ICustomField> customFields, IStyledTextDecorator userTextDecorator) {
        for (ICustomField iCustomField : customFields) {
            this.addCustomFieldControl(iCustomField, userTextDecorator);
        }
        ReviewMovingOnAdapter.init((IReviewMovingOn)this.reviewSummary.getMovingOn(), (IReviewMovingOnListener)this.phaseVisiblityListener);
        this.setTarget(this.target);
    }

    private void addCustomFieldControl(ICustomField field, IStyledTextDecorator userTextDecorator) {
        Pair<Label, ICustomFieldWidget> controls = CustomFieldWidgetFactory.layoutWithLabel(this, 2048, field, userTextDecorator, this.reviewSummary.getMovingOn());
        this.customFieldLabels.put(field, (Label)controls.getA());
        this.customFieldWidgets.put(field, (ICustomFieldWidget)controls.getB());
        ((ICustomFieldWidget)controls.getB()).addModifyListener(this.widgetModifyListener);
    }

    public final void setTarget(ICustomFieldTarget newTarget) {
        boolean updateVisibility;
        if (newTarget instanceof IReviewParticipant) {
            for (ICustomField customField : this.customFieldWidgets.keySet()) {
                IContributor targetUser = ((IReviewParticipant)newTarget).getUser();
                boolean allowToModifyCustomField = customField.getModifyRole() != null ? customField.getModifyRole().isAllowToModify(this.currentParticipant, (IUser)targetUser) : true;
                ICustomFieldWidget widget = this.customFieldWidgets.get(customField);
                if (allowToModifyCustomField) {
                    widget.setEditable(true);
                    continue;
                }
                widget.setEditable(false);
            }
        }
        boolean bl = updateVisibility = this.target == null != (newTarget == null);
        if (this.target != null) {
            CustomFieldAdapter.removeListener((ICustomFieldTarget)this.target, this.customFieldWidgets.keySet(), (ICustomFieldListener)this.customFieldListener);
        }
        this.target = newTarget;
        if (newTarget != null) {
            CustomFieldAdapter.addListener((ICustomFieldTarget)newTarget, this.customFieldWidgets.keySet(), (ICustomFieldListener)this.customFieldListener);
            CustomFieldAdapter.init((ICustomFieldTarget)newTarget, this.customFieldWidgets.keySet(), (ICustomFieldListener)this.customFieldListener);
        }
        if (updateVisibility) {
            this.updateVisibility();
        }
    }

    private boolean isCustomFieldValueChanged(ICustomFieldWidget widget) {
        if (this.target == null) {
            return false;
        }
        Control control = widget.getControl();
        if (control == null) {
            return false;
        }
        if (control.isDisposed() || !control.getVisible()) {
            return false;
        }
        HashSet<String> valueSet = widget.getValue();
        HashSet targetSet = this.target.getCustomFieldValue(widget.getCustomField());
        if (valueSet != null) {
            for (String value : valueSet) {
                if (Strings.isNullOrEmpty((String)value) && targetSet != null && targetSet.size() == 0) {
                    return false;
                }
                if (valueSet.equals(targetSet)) continue;
                return true;
            }
        }
        return false;
    }

    protected ICustomFieldRef[] getCustomFieldValueRefs(ICustomFieldTarget customFieldTarget) {
        ArrayList<ICustomFieldWidget> widgetsList = new ArrayList<ICustomFieldWidget>();
        for (ICustomFieldWidget widget : this.customFieldWidgets.values()) {
            if (!this.isCustomFieldValueChanged(widget)) continue;
            widgetsList.add(widget);
        }
        Collection widgets = widgetsList;
        if (customFieldTarget instanceof IReviewParticipant) {
            IContributor user;
            IReviewParticipant participant = (IReviewParticipant)customFieldTarget;
            if (participant != null && (user = participant.getUser()) != null) {
                try {
                    JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
                    CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
                    UserIdRequest request = (UserIdRequest)JsonUtils.create(UserIdRequest.class);
                    request.setId(Integer.valueOf(user.getId()));
                    UserLoginResponse response = jsonApi.systemAdminApi().usersApi().findLoginByUserId(request);
                    final String login = response.getLogin();
                    for (ICustomFieldWidget widget : widgets) {
                        widget.setUser(login);
                    }
                    widgets = Collections2.filter(widgets, (Predicate)new Predicate<ICustomFieldWidget>(){

                        public boolean apply(ICustomFieldWidget widget) {
                            widget.setUser(login);
                            return widget.getControl().getVisible();
                        }
                    });
                }
                catch (CollabClientException ex) {
                    this.getDisplay().syncExec(new Runnable((IUser)user, ex){
                        final /* synthetic */ IUser val$user;
                        final /* synthetic */ CollabClientException val$ex;
                        {
                            this.val$user = iUser;
                            this.val$ex = collabClientException;
                        }

                        @Override
                        public void run() {
                            CollaboratorUI.openError(CustomFieldTargetWidget.this.getShell(), "Error loading possible participants From Json" + this.val$user.getId(), this.val$ex, false, false);
                        }
                    });
                }
            }
        } else if (customFieldTarget instanceof IChecklistItem) {
            final IChecklistItem checklistItem = (IChecklistItem)customFieldTarget;
            for (ICustomFieldWidget widget : widgets) {
                widget.setChecklistItemId(checklistItem.getId());
            }
            widgets = Collections2.filter(widgets, (Predicate)new Predicate<ICustomFieldWidget>(){

                public boolean apply(ICustomFieldWidget widget) {
                    widget.setChecklistItemId(checklistItem.getId());
                    return widget.getControl().getVisible();
                }
            });
        }
        return CustomFieldWidgetFactory.toValueRefs(widgets);
    }

    protected boolean isCustomFieldsDirty() {
        if (this.target == null) {
            return false;
        }
        for (ICustomFieldWidget widget : this.customFieldWidgets.values()) {
            if (!this.isCustomFieldValueChanged(widget)) continue;
            return true;
        }
        return false;
    }

    private void updateVisibility() {
        Phase phase = this.reviewSummary.getMovingOn().getPhase();
        boolean visibilityChanged = false;
        for (ICustomField customField : this.customFieldWidgets.keySet()) {
            boolean visible;
            Label label = this.customFieldLabels.get(customField);
            ICustomFieldWidget widget = this.customFieldWidgets.get(customField);
            boolean bl = visible = customField.getVisiblePhases().contains(phase) && this.target != null;
            if (widget.getControl().getVisible() == visible) continue;
            visibilityChanged = true;
            label.setVisible(visible);
            ((TableWrapData2)label.getLayoutData()).exclude = !visible;
            widget.getControl().setVisible(visible);
            ((TableWrapData2)widget.getControl().getLayoutData()).exclude = !visible;
        }
        if (visibilityChanged) {
            SwtUtils.reflowForm((Control)this);
            this.saveableListener.dirtyStateMayHaveChanged();
        }
    }
}

