/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.collect.Lists;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.defect.AbstractDefectCommand;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectEdit;
import com.smartbear.ccollab.client.commands.argrefs.DefectRefById;
import com.smartbear.ccollab.client.commands.argrefs.IDefectRef;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.IDefect;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.DefectWidget;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.ZeroDefaultSizeComposite;
import com.smartbear.swt.text.IStyledTextDecorator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DefectLogWidget
extends ZeroDefaultSizeComposite {
    private final IClientSystemGlobals clientSystemGlobals;
    private final ICommandRunner commandRunner;
    private final ISaveableListener saveableListener;
    private final IStyledTextDecorator userTextDecorator;
    private final FormToolkit formToolkit;
    private final List<? extends ICustomField> customFields;
    private final Map<Integer, DefectWidget> defectWidgetsById = new HashMap<Integer, DefectWidget>();
    private final IConversationListener conversationListener = new ReviewConversationAdapter(){

        public void defectsDeleted(IConversation conversation, ArrayList<? extends IDefect> deletedDefects) {
            for (IDefect iDefect : deletedDefects) {
                if (!DefectLogWidget.this.defectWidgetsById.containsKey(iDefect.getId())) continue;
                DefectLogWidget.this.defectWidgetsById.remove(iDefect.getId()).dispose();
            }
            SwtUtils.reflowForm((Control)DefectLogWidget.this);
        }

        public void defectsAdded(IConversation conversation, ArrayList<? extends IDefect> newDefects) {
            for (IDefect iDefect : newDefects) {
                DefectLogWidget.this.addDefect(iDefect);
            }
            SwtUtils.reflowForm((Control)DefectLogWidget.this);
        }
    };

    public DefectLogWidget(Composite parent, int style, FormToolkit formToolkit, IClientSystemGlobals clientSystemGlobals, final IConversation conversation, List<? extends ICustomField> customFields, ICommandRunner commandRunner, ISaveableListener saveableListener, IStyledTextDecorator userTextDecorator) {
        super(parent, style);
        this.clientSystemGlobals = clientSystemGlobals;
        this.commandRunner = commandRunner;
        this.saveableListener = saveableListener;
        this.userTextDecorator = userTextDecorator;
        this.formToolkit = formToolkit;
        this.customFields = customFields;
        TableWrapLayout layout = new TableWrapLayout();
        SwtUtils.setMargins(layout, 0);
        this.setLayout((Layout)layout);
        for (IDefect defect : conversation.getDefects()) {
            this.addDefect(defect);
        }
        conversation.addConversationListener(this.conversationListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                conversation.removeConversationListener(DefectLogWidget.this.conversationListener);
            }
        });
    }

    public void setEditable(boolean editable) {
        for (DefectWidget defectWidget : this.defectWidgetsById.values()) {
            defectWidget.setEditable(editable);
        }
    }

    private void addDefect(IDefect defect) {
        DefectWidget defectWidget = new DefectWidget(this, SwtUtils.BASE_COMPOSITE_STYLE, this.formToolkit, true, defect, this.customFields, this.clientSystemGlobals, this.createCommandRunner(defect), this.saveableListener, this.userTextDecorator);
        defectWidget.setLayoutData(new TableWrapData(256));
        this.defectWidgetsById.put(defect.getId(), defectWidget);
    }

    private ICommandRunner createCommandRunner(final IDefect defect) {
        return new ICommandRunner(){

            @Override
            public void run(Command command, boolean async) {
                if (command instanceof AbstractDefectCommand) {
                    ((AbstractDefectCommand)command).setDefect((IDefectRef)new DefectRefById(defect.getId()));
                }
                DefectLogWidget.this.commandRunner.run(command, async);
            }
        };
    }

    public boolean isDirty() {
        for (DefectWidget defectWidget : this.defectWidgetsById.values()) {
            if (!defectWidget.isDirty()) continue;
            return true;
        }
        return false;
    }

    public List<String> getSaveErrorMessages() {
        ArrayList saveErrorMessages = Lists.newArrayList();
        for (DefectWidget defectWidget : this.defectWidgetsById.values()) {
            saveErrorMessages.addAll(defectWidget.getErrorMessages());
        }
        return saveErrorMessages;
    }

    public List<CommandDefectEdit> getSaveCommands() {
        ArrayList saveCommands = Lists.newArrayList();
        for (DefectWidget defectWidget : this.defectWidgetsById.values()) {
            if (!defectWidget.isDirty()) continue;
            saveCommands.add(defectWidget.getSaveCommand());
        }
        return saveCommands;
    }
}

