/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectCreate;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectDelete;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectEdit;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectMarkExternal;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectMarkFixed;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectMarkNotExternal;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectMarkOpen;
import com.smartbear.ccollab.client.commands.argrefs.DefectRefById;
import com.smartbear.ccollab.client.commands.argrefs.ICustomFieldRef;
import com.smartbear.ccollab.client.commands.argrefs.IDefectRef;
import com.smartbear.ccollab.datamodel.MetaDataDescription;
import com.smartbear.ccollab.datamodel.client.DefectState;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.ICustomFieldTarget;
import com.smartbear.ccollab.datamodel.client.IDefect;
import com.smartbear.ccollab.datamodel.client.listener.ICustomFieldListener;
import com.smartbear.ccollab.datamodel.client.listener.IDefectListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.CustomFieldAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.DefectAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.customfield.CustomFieldWidgetFactory;
import com.smartbear.collaborator.ui.customfield.ICustomFieldWidget;
import com.smartbear.collaborator.ui.review.ITextReciever;
import com.smartbear.collaborator.ui.review.TrackExternallyDialog;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.TableWrapLayout2;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.commons.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DefectWidget
extends Composite
implements ITextReciever {
    private final IDefectListener defectListener = new DefectAdapter(){

        public void whyNotAllowedToModifyChanged(IDefect defect, String whyNotAllowedToModify) {
            DefectWidget.this.updateEnablement();
            String toolTip = StringUtils.defaultString((String)SwtUtils.escapeMnemonics(whyNotAllowedToModify), null);
            DefectWidget.this.text.setToolTipText(toolTip);
        }

        public void whyNotAllowedToDeleteChanged(IDefect defect, String whyNotAllowedToDelete) {
            DefectWidget.this.updateEnablement();
        }

        public void textChanged(IDefect defect, String newText) {
            DefectWidget.this.text.setText(StringUtils.defaultString((String)newText));
            SwtUtils.resizeVerticalIfNecessary((Control)DefectWidget.this.text);
            DefectWidget.this.saveableListener.dirtyStateMayHaveChanged();
        }

        public void stateChanged(IDefect defect, DefectState newState) {
            if (DefectWidget.this.defectImage.isDisposed()) {
                return;
            }
            DefectWidget.this.defectImage.setImage(DefectWidget.getImage(newState));
            DefectWidget.this.toggleOpenFixedLink.setText("<a>" + (newState == DefectState.FIXED ? "Mark Open" : "Mark Fixed") + "</a>");
            DefectWidget.this.toggleExternalLink.setText("<a>" + (newState == DefectState.EXTERNAL ? "Not External" : "Track Externally") + "</a>");
            DefectWidget.this.layout(new Control[]{DefectWidget.this.toggleOpenFixedLink, DefectWidget.this.toggleExternalLink});
            DefectWidget.this.updateEnablement();
        }
    };
    private final ICustomFieldListener customFieldListener = new ICustomFieldListener(){

        public void customFieldChanged(ICustomFieldTarget target, ICustomField customField, HashSet<String> newValue) {
            DefectWidget.this.customFieldWidgets.get(customField).setValue(newValue);
            DefectWidget.this.customFieldsExpando.setText(StringUtils.defaultString((String)SwtUtils.escapeMnemonics(DefectWidget.getCustomFieldsSummary((ICustomFieldTarget)DefectWidget.this.defect, DefectWidget.this.customFieldWidgets.keySet()))));
            DefectWidget.this.saveableListener.dirtyStateMayHaveChanged();
        }
    };
    private final ICustomFieldWidget.ICustomFieldWidgetModifyListener customFieldWidgetModifyListener = new ICustomFieldWidget.ICustomFieldWidgetModifyListener(){

        @Override
        public void widgetModified(ICustomFieldWidget widget, HashSet<String> newValue) {
            DefectWidget.this.saveableListener.dirtyStateMayHaveChanged();
        }
    };
    private final IClientSystemGlobals clientSystemGlobals;
    private final IDefect defect;
    private final ICommandRunner commandRunner;
    private final ISaveableListener saveableListener;
    private CLabel defectImage;
    private Link toggleOpenFixedLink;
    private Link toggleExternalLink;
    private Link deleteLink;
    private StyledText text;
    private ExpandableComposite customFieldsExpando;
    private final LinkedHashMap<ICustomField, ICustomFieldWidget> customFieldWidgets = Maps.newLinkedHashMap();
    private boolean editable = true;
    private static final DefectState.IDefectStateVisitor<String> DEFECT_ICON_KEY_VISITOR = new DefectState.IDefectStateVisitor<String>(){

        public String visitOpen() {
            return "IMG_DEFECT_OPEN";
        }

        public String visitFixed() {
            return "IMG_DEFECT_FIXED";
        }

        public String visitReject() {
            return "IMG_DEFECT_REJECT";
        }

        public String visitExternal() {
            return "IMG_DEFECT_EXTERNALIZED";
        }
    };

    public DefectWidget(Composite parent, int style, List<? extends ICustomField> customFields, IClientSystemGlobals clientSystemGlobals, ICommandRunner commandRunner, ISaveableListener saveableListener, IStyledTextDecorator userTextDecorator, TraverseListener traverseListener) {
        this(parent, style, null, false, null, customFields, clientSystemGlobals, commandRunner, saveableListener, userTextDecorator);
        this.text.addTraverseListener(traverseListener);
        for (ICustomFieldWidget widget : this.customFieldWidgets.values()) {
            widget.getControl().addTraverseListener(traverseListener);
        }
    }

    public DefectWidget(Composite parent, int style, FormToolkit formToolkit, boolean separator, IDefect defect, List<? extends ICustomField> customFields, IClientSystemGlobals clientSystemGlobals, ICommandRunner commandRunner, ISaveableListener saveableListener, IStyledTextDecorator userTextDecorator) {
        super(parent, style);
        this.clientSystemGlobals = clientSystemGlobals;
        this.defect = defect;
        this.commandRunner = commandRunner;
        this.saveableListener = saveableListener;
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.bottomMargin = 0;
        this.setLayout((Layout)layout);
        if (separator && formToolkit != null) {
            Composite separatorControl = formToolkit.createCompositeSeparator((Composite)this);
            TableWrapData tableWrapData = new TableWrapData(256);
            tableWrapData.heightHint = 1;
            tableWrapData.colspan = 2;
            separatorControl.setLayoutData((Object)tableWrapData);
        }
        if (defect != null) {
            Control buttons = this.createButtonsControl(this);
            buttons.setLayoutData((Object)new TableWrapData(128));
        }
        StyledText textControl = this.createTextControl(this, userTextDecorator);
        TableWrapData tableWrapData = new TableWrapData(256, 256);
        if (defect == null) {
            tableWrapData.colspan = 2;
        }
        textControl.setLayoutData((Object)tableWrapData);
        if (!customFields.isEmpty()) {
            Control customFieldsControl = this.createCustomFieldsControl(this, customFields, userTextDecorator);
            customFieldsControl.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        }
        if (defect != null) {
            defect.addDefectListener(this.defectListener);
            for (ICustomField iCustomField : customFields) {
                defect.addCustomFieldListener(iCustomField, this.customFieldListener);
            }
            DefectAdapter.init((IDefect)defect, (IDefectListener)this.defectListener);
            CustomFieldAdapter.init((ICustomFieldTarget)defect, customFields, (ICustomFieldListener)this.customFieldListener);
        }
    }

    private Control createButtonsControl(Composite parent) {
        Preconditions.checkState((this.defect != null ? 1 : 0) != 0, (Object)"createButtonsControl() assumes defect exists");
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        SwtUtils.setMargins(layout, 0);
        buttons.setLayout((Layout)layout);
        this.defectImage = new CLabel(buttons, 0);
        this.defectImage.setText("D" + this.defect.getId());
        this.defectImage.setLayoutData((Object)new GridData());
        this.toggleOpenFixedLink = new Link(buttons, 0);
        this.toggleOpenFixedLink.setLayoutData((Object)new GridData());
        this.toggleOpenFixedLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object command = DefectWidget.this.defect.getState() == DefectState.OPEN ? new CommandDefectMarkFixed() : new CommandDefectMarkOpen();
                DefectWidget.this.commandRunner.run((Command)command, true);
            }
        });
        this.toggleExternalLink = new Link(buttons, 0);
        this.toggleExternalLink.setLayoutData((Object)new GridData());
        this.toggleExternalLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DefectWidget.this.defect.getState() == DefectState.EXTERNAL) {
                    CommandDefectMarkNotExternal command = new CommandDefectMarkNotExternal();
                    DefectWidget.this.commandRunner.run((Command)command, true);
                } else {
                    TrackExternallyDialog dialog = new TrackExternallyDialog(DefectWidget.this.getShell(), DefectWidget.this.getText(), DefectWidget.this.clientSystemGlobals);
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0) {
                        CommandDefectMarkExternal command = new CommandDefectMarkExternal();
                        command.setExternalName(dialog.getExternalName());
                        DefectWidget.this.commandRunner.run((Command)command, true);
                    }
                }
            }
        });
        this.deleteLink = new Link(buttons, 0);
        this.deleteLink.setText("<a>Delete</a>");
        this.deleteLink.setLayoutData((Object)new GridData());
        this.deleteLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefectWidget.this.commandRunner.run((Command)new CommandDefectDelete(), true);
            }
        });
        return buttons;
    }

    private StyledText createTextControl(Composite parent, final IStyledTextDecorator decorator) {
        this.text = new StyledText(parent, 2112);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwtUtils.clearStylesAndLinks(DefectWidget.this.text);
                decorator.decorate(DefectWidget.this.text);
                SwtUtils.resizeVerticalIfNecessary((Control)DefectWidget.this.text);
                DefectWidget.this.saveableListener.dirtyStateMayHaveChanged();
            }
        });
        return this.text;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.updateEnablement();
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void updateEnablement() {
        boolean canModify;
        boolean bl = canModify = this.defect == null || StringUtils.isBlank((String)this.defect.getWhyNotAllowedToModify());
        if (this.defect != null) {
            boolean canDelete = StringUtils.isBlank((String)this.defect.getWhyNotAllowedToDelete());
            DefectState state = this.defect.getState();
            this.toggleOpenFixedLink.setEnabled(this.isEditable() && canModify && (state == DefectState.FIXED || state == DefectState.OPEN));
            this.toggleExternalLink.setEnabled(this.isEditable() && canModify && (state == DefectState.OPEN || state == DefectState.EXTERNAL));
            this.deleteLink.setEnabled(this.isEditable() && canDelete && state == DefectState.OPEN || state == DefectState.EXTERNAL);
        }
        this.text.setEnabled(this.isEditable());
        this.text.setEditable(canModify && (this.defect == null || this.defect.getState() == DefectState.OPEN));
        for (ICustomFieldWidget customFieldWidget : this.customFieldWidgets.values()) {
            customFieldWidget.setEditable(this.isEditable() && canModify && (this.defect == null || this.defect.getState() == DefectState.OPEN));
        }
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    @Override
    public String getText() {
        return this.text.getText();
    }

    @Override
    public void setText(String text) {
        this.text.setText(StringUtils.defaultString((String)text));
        SwtUtils.resizeVerticalIfNecessary((Control)this.text);
        this.saveableListener.dirtyStateMayHaveChanged();
    }

    public void keyPressed(KeyEvent e) {
        ITextReciever.Util.handleKeyPress(this, e, (Control)this.text);
    }

    public void keyReleased(KeyEvent e) {
    }

    List<String> getErrorMessages() {
        ArrayList<String> errorMessages = new ArrayList<String>(1 + this.customFieldWidgets.size());
        if (StringUtils.isBlank((String)this.text.getText())) {
            errorMessages.add(WordUtils.capitalize((String)this.clientSystemGlobals.getDefectLabelSingular()) + " text can not be blank");
        }
        for (ICustomFieldWidget customFieldWidget : this.customFieldWidgets.values()) {
            String customFieldErrorMessage = customFieldWidget.getCustomField().getErrorMessage(customFieldWidget.getValue(), false, true);
            if (!StringUtils.isNotBlank((String)customFieldErrorMessage)) continue;
            errorMessages.add(customFieldErrorMessage);
        }
        return errorMessages;
    }

    private Control createCustomFieldsControl(final Composite parent, List<? extends ICustomField> customFields, IStyledTextDecorator userTextDecorator) {
        this.customFieldsExpando = new ExpandableComposite(parent, 0);
        if (this.defect == null) {
            this.customFieldsExpando.setExpanded(true);
        }
        this.customFieldsExpando.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SwtUtils.reflowForm((Control)parent);
            }
        });
        Composite customFieldsComposite = new Composite((Composite)this.customFieldsExpando, 0);
        TableWrapLayout2 customFieldsLayout = new TableWrapLayout2();
        customFieldsLayout.numColumns = 2;
        customFieldsLayout.rightMargin = 0;
        customFieldsLayout.horizontalSpacing = 8;
        customFieldsComposite.setLayout((Layout)customFieldsLayout);
        for (ICustomField iCustomField : customFields) {
            ICustomFieldWidget widget = (ICustomFieldWidget)CustomFieldWidgetFactory.layoutWithLabel(customFieldsComposite, 2048, iCustomField, userTextDecorator, null).getB();
            widget.addModifyListener(this.customFieldWidgetModifyListener);
            this.customFieldWidgets.put(iCustomField, widget);
        }
        this.customFieldsExpando.setClient((Control)customFieldsComposite);
        return this.customFieldsExpando;
    }

    public CommandDefectCreate getCreateCommand() {
        Preconditions.checkState((this.defect == null ? 1 : 0) != 0);
        CommandDefectCreate command = new CommandDefectCreate();
        command.setComment(this.text.getText());
        command.setCustomFields(DefectWidget.toRefs(this.customFieldWidgets.values()));
        return command;
    }

    public CommandDefectEdit getSaveCommand() {
        Preconditions.checkState((this.defect != null ? 1 : 0) != 0);
        CommandDefectEdit command = new CommandDefectEdit();
        command.setDefect((IDefectRef)new DefectRefById(this.defect.getId()));
        command.setComment(this.text.getText());
        command.setCustomFields(DefectWidget.toRefs(this.customFieldWidgets.values()));
        return command;
    }

    public boolean isDirty() {
        if (this.defect == null) {
            return false;
        }
        if (!this.text.getText().equals(this.defect.getText())) {
            return true;
        }
        for (ICustomFieldWidget customFieldWidget : this.customFieldWidgets.values()) {
            if (ObjectUtils.equals(customFieldWidget.getValue(), (Object)this.defect.getCustomFieldValue(customFieldWidget.getCustomField()))) continue;
            return true;
        }
        return false;
    }

    private static ICustomFieldRef[] toRefs(Collection<ICustomFieldWidget> customFieldWidgets) {
        ArrayList<9> customFieldRefs = new ArrayList<9>(customFieldWidgets.size());
        for (final ICustomFieldWidget customFieldWidget : customFieldWidgets) {
            final String key = customFieldWidget.getCustomField().getTitle();
            final HashSet<String> values = customFieldWidget.getValue();
            customFieldRefs.add(new ICustomFieldRef(){

                public String getTitle() {
                    return key;
                }

                public Set<String> getValues(MetaDataDescription.Type type) {
                    return this.getValues();
                }

                public Set<String> getValues() {
                    return values;
                }

                public Set<String> getRawValues() {
                    return values;
                }

                public String getUser() {
                    return customFieldWidget.getUser();
                }

                public Integer getChecklistItemId() {
                    return customFieldWidget.getChecklistItemId();
                }
            });
        }
        return customFieldRefs.toArray(ICustomFieldRef.EMPTY_ARRAY);
    }

    private static String getCustomFieldsSummary(ICustomFieldTarget target, Collection<? extends ICustomField> customFields) {
        StringBuilder summary = new StringBuilder();
        boolean first = true;
        for (ICustomField iCustomField : customFields) {
            if (!first) {
                summary.append(" / ");
            }
            first = false;
            summary.append(StringUtils.join((Collection)target.getCustomFieldValue(iCustomField), (String)", "));
        }
        return summary.toString();
    }

    static Image getImage(DefectState state) {
        String iconKey = (String)state.accept(DEFECT_ICON_KEY_VISITOR);
        return CollaboratorUI.getImage(iconKey);
    }
}

