/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.base.Function;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewCancel;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewDelete;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewEdit;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewReject;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewReopen;
import com.smartbear.ccollab.client.commands.argrefs.GroupRefByGuid;
import com.smartbear.ccollab.client.commands.argrefs.IGroupRef;
import com.smartbear.ccollab.client.commands.argrefs.IReviewTemplateRef;
import com.smartbear.ccollab.client.commands.argrefs.ReviewTemplateRefByName;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.ICustomFieldTarget;
import com.smartbear.ccollab.datamodel.client.IGroup;
import com.smartbear.ccollab.datamodel.client.IReviewGeneralInfo;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewTemplate;
import com.smartbear.ccollab.datamodel.client.IRole;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.ReviewParticipantHelper;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewTemplate;
import com.smartbear.ccollab.datamodel.client.listener.IReviewGeneralInfoListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewGeneralInfoAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.ReviewCommandRunner;
import com.smartbear.collaborator.ui.review.CustomFieldTargetWidget;
import com.smartbear.jface.CollectionContentProvider;
import com.smartbear.jface.ComboViewer2;
import com.smartbear.jface.IBaseLabelProvider2;
import com.smartbear.jface.LabelProvider2;
import com.smartbear.jface.ViewerComparator2;
import com.smartbear.jface.ViewerFilter2;
import com.smartbear.swt.RightSizeText;
import com.smartbear.swt.TableWrapData2;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.SmartBearUtils;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralInfoWidget
extends CustomFieldTargetWidget {
    private final IReviewGeneralInfoListener generalInfoListener;
    private final IReviewMovingOnListener movingOnListener;
    private final ISaveableListener saveableListener;
    private final IClientSystemGlobals clientSystemGlobals;
    private final IReviewGeneralInfo generalInfo;
    private final ReviewCommandRunner commandRunner;
    private final IWorkbenchPartSite site;
    private IAction openReviewInBrowserAction;
    private IAction abortReviewAction;
    private IAction rejectReviewAction;
    private IAction reopenReviewAction;
    private static String DELETE = "Delete Review";
    private static String CANCEL = "Cancel Review";
    private static String HINT_OPEN_IN_BROWSER = "Open Review in the system's default browser";
    private static String ERROR_OPEN_REVIEW_IN_BROWSER = "Error opening a review in the external browser.";
    private static String ERROR_BROWSE_NOT_SUPPORTED = "Unable to open a review in the external browser. Browse action is not supported by the current desktop environment.";
    private RightSizeText titleControl;
    private RightSizeText roleText;
    private RightSizeText creationDateText;
    private RightSizeText completedDateText;
    private ComboViewer2<List<? extends IReviewTemplate>, IReviewTemplate> templateViewer;
    private ComboViewer2<List<? extends IGroup>, IGroup> groupViewerJson;
    private Composite parent;

    public GeneralInfoWidget(Composite parent, int style, ISaveableListener saveableListener, IClientSystemGlobals clientSystemGlobals, final IReviewGeneralInfo generalInfo, IWorkbenchPartSite site, IToolBarManager toolBarManager, ReviewCommandRunner commandRunner, IStyledTextDecorator userTextDecorator) {
        super(parent, style, generalInfo.getReviewSummary(), saveableListener);
        this.setTarget((ICustomFieldTarget)generalInfo);
        this.saveableListener = saveableListener;
        this.clientSystemGlobals = clientSystemGlobals;
        this.generalInfo = generalInfo;
        this.commandRunner = commandRunner;
        this.site = site;
        this.generalInfoListener = this.newGeneralInfoListener();
        this.movingOnListener = this.newMovingOnListener();
        this.parent = parent;
        this.initToolBar(toolBarManager);
        this.createTitleArea();
        this.createRoleArea();
        this.createCreatedDateArea();
        this.createTemplateArea();
        this.createCompletedDateArea();
        this.createGroupAreaJson();
        this.addCustomFieldControls(generalInfo.getTemplate().getReviewCustomFields(), userTextDecorator);
        generalInfo.addReviewGeneralInfoListener(this.generalInfoListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                generalInfo.removeReviewGeneralInfoListener(GeneralInfoWidget.this.generalInfoListener);
            }
        });
        generalInfo.getReviewSummary().getMovingOn().addMovingOnListener(this.movingOnListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                generalInfo.getReviewSummary().getMovingOn().removeMovingOnListener(GeneralInfoWidget.this.movingOnListener);
            }
        });
        ReviewGeneralInfoAdapter.init((IReviewGeneralInfo)generalInfo, (IReviewGeneralInfoListener)this.generalInfoListener);
    }

    private void disableButtonArea(String explanation) {
        this.rejectReviewAction.setEnabled(false);
        this.abortReviewAction.setEnabled(false);
        this.abortReviewAction.setText(explanation);
        this.rejectReviewAction.setText(explanation);
        ((Section)this.parent).setText("\t\t\t\t\t" + explanation + "!");
        Display display = Display.getCurrent();
        Color red = display.getSystemColor(3);
        ((Section)this.parent).setTitleBarBorderColor(red);
        ((Section)this.parent).setTitleBarForeground(red);
        ((Section)this.parent).redraw();
    }

    private void initToolBar(IToolBarManager toolBarManager) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.openReviewInBrowserAction = new Action(){

            public void run() {
                Desktop desktop;
                URI reviewUrl = null;
                try {
                    reviewUrl = Collaborator.getUrl((IReviewSummary)GeneralInfoWidget.this.generalInfo.getReviewSummary()).toURI();
                }
                catch (URISyntaxException e) {
                    CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), ERROR_OPEN_REVIEW_IN_BROWSER, e, false, true);
                    return;
                }
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(reviewUrl);
                    }
                    catch (Exception e) {
                        CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), ERROR_OPEN_REVIEW_IN_BROWSER, e, false, true);
                    }
                } else {
                    CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), ERROR_BROWSE_NOT_SUPPORTED, null, false, true);
                }
            }
        };
        this.openReviewInBrowserAction.setImageDescriptor(CollaboratorUI.getImageDescriptor("IMG_WEB"));
        this.openReviewInBrowserAction.setText(HINT_OPEN_IN_BROWSER);
        toolBarManager.add(this.openReviewInBrowserAction);
        this.abortReviewAction = new Action(){

            public void run() {
                boolean shouldCancelOrDelete = MessageDialog.openQuestion((Shell)GeneralInfoWidget.this.getShell(), (String)("Confirm " + this.getText()), (String)("Are you sure you want to " + (CANCEL.equalsIgnoreCase(this.getText()) ? "cancel" : "delete") + " this Review?\n\nThis operation can only be undone by a system administrator."));
                if (shouldCancelOrDelete) {
                    String explanation;
                    if (CANCEL.equalsIgnoreCase(this.getText())) {
                        GeneralInfoWidget.this.commandRunner.run((Command)new CommandReviewCancel(), false);
                        explanation = "This Review has been cancelled";
                    } else {
                        GeneralInfoWidget.this.commandRunner.run((Command)new CommandReviewDelete(), false);
                        explanation = "This Review has been deleted";
                    }
                    GeneralInfoWidget.this.disableButtonArea(explanation);
                }
            }
        };
        this.abortReviewAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_DELETE"));
        toolBarManager.add(this.abortReviewAction);
        this.rejectReviewAction = new Action(){

            public void run() {
                boolean shouldReject = MessageDialog.openQuestion((Shell)GeneralInfoWidget.this.getShell(), (String)"Confirm Reject Review", (String)"Are you sure you want to reject this Review?");
                if (shouldReject) {
                    GeneralInfoWidget.this.commandRunner.run((Command)new CommandReviewReject(), false);
                    GeneralInfoWidget.this.disableButtonArea("This Review has been rejected");
                }
            }
        };
        this.rejectReviewAction.setImageDescriptor(CollaboratorUI.getImageDescriptor("IMG_REJECT"));
        toolBarManager.add(this.rejectReviewAction);
        this.reopenReviewAction = new Action(){

            public void run() {
                boolean shouldReopen = MessageDialog.openQuestion((Shell)GeneralInfoWidget.this.getShell(), (String)"Confirm Reopen Review", (String)"This Review has been completed. Are you sure you want to reopen this Review?");
                if (shouldReopen) {
                    GeneralInfoWidget.this.commandRunner.run((Command)new CommandReviewReopen(), false);
                }
            }
        };
        this.reopenReviewAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_OPEN_MARKER"));
        toolBarManager.add(this.reopenReviewAction);
        toolBarManager.update(true);
    }

    private void updateAbortReviewAction() {
        String whyNot = this.generalInfo.getWhyNotAllowedToCancel();
        Phase phase = this.generalInfo.getReviewSummary().getMovingOn().getPhase();
        if (phase == Phase.PLANNING) {
            this.abortReviewAction.setEnabled(true);
        } else if (phase != Phase.PLANNING && !phase.isTerminal()) {
            this.abortReviewAction.setEnabled(true);
        } else {
            this.abortReviewAction.setEnabled(false);
        }
        if (StringUtils.isNotBlank((String)whyNot)) {
            this.abortReviewAction.setText(whyNot);
            this.abortReviewAction.setEnabled(false);
        } else {
            String abortText = this.generalInfo.getReviewSummary().getMovingOn().getPhase() == Phase.PLANNING ? DELETE : CANCEL;
            this.abortReviewAction.setText(abortText);
        }
    }

    private void updateReopenReviewAction() {
        String whyNot = this.generalInfo.getWhyNotAllowedToReopen();
        if (StringUtils.isNotBlank((String)whyNot)) {
            this.reopenReviewAction.setText(whyNot);
            this.reopenReviewAction.setEnabled(false);
        } else {
            this.reopenReviewAction.setText("Reopen Review");
            Phase phase = this.generalInfo.getReviewSummary().getMovingOn().getPhase();
            if (phase == Phase.COMPLETED) {
                this.reopenReviewAction.setEnabled(true);
            } else {
                this.reopenReviewAction.setEnabled(false);
            }
        }
    }

    private void updateRejectReviewAction() {
        String whyNot = this.generalInfo.getWhyNotAllowedToReject();
        if (StringUtils.isNotBlank((String)whyNot)) {
            this.rejectReviewAction.setText(whyNot);
            this.rejectReviewAction.setEnabled(false);
        } else {
            this.rejectReviewAction.setText("Reject Review");
            this.rejectReviewAction.setEnabled(true);
        }
    }

    private Action getDeleteAction() {
        return new Action("Delete this Review"){

            public void run() {
                boolean shouldDelete = MessageDialog.openQuestion((Shell)GeneralInfoWidget.this.getShell(), (String)"Confirm Delete Review", (String)"Are you sure you want to delete this Review?\n\nThis operation cannot be undone.");
                if (shouldDelete) {
                    GeneralInfoWidget.this.commandRunner.run((Command)new CommandReviewDelete(), false);
                }
            }
        };
    }

    private void createCompletedDateArea() {
        Label completedDateLabel = new Label((Composite)this, 0);
        completedDateLabel.setText("Completed On:");
        completedDateLabel.setLayoutData((Object)new TableWrapData2(8, 16));
        this.completedDateText = new RightSizeText(this, 2056);
        this.completedDateText.setEnabled(false);
        this.completedDateText.setLayoutData(new TableWrapData2(256, 16));
    }

    private void createTemplateArea() {
        if (Product.getFeatures().supportsMultipleWorkflows()) {
            Label templateLabel = new Label((Composite)this, 0);
            templateLabel.setText("Template:");
            templateLabel.setLayoutData((Object)new TableWrapData2(8, 16));
            Combo combo = new Combo((Composite)this, 8);
            combo.setLayoutData((Object)new TableWrapData2(256, 256));
            this.templateViewer = ComboViewer2.create(combo);
            this.templateViewer.setComparator(new ViewerComparator2());
            this.templateViewer.setContentProvider(CollectionContentProvider.getInstance());
            this.templateViewer.setLabelProvider((IBaseLabelProvider2<IReviewTemplate>)new LabelProvider2<IReviewTemplate>(){

                @Override
                public String getText(IReviewTemplate template) {
                    return template.getName();
                }
            });
            this.initializeViewer("templates", this.getGetTemplatesFunc(), this.getInitTemplateViewerFunc());
        }
    }

    private Function<Void, List<? extends IReviewTemplate>> getGetTemplatesFunc() {
        return new Function<Void, List<? extends IReviewTemplate>>(){

            public List<? extends IReviewTemplate> apply(Void param) {
                try {
                    List reviewTemplates = JsonAPIHandler.getReviewTemplates();
                    return reviewTemplates;
                }
                catch (CollabClientServerConnectivityException e) {
                    CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), "Error connecting to server to load Templates", e, false, false);
                    return Collections.emptyList();
                }
                catch (CollabClientException e) {
                    CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), "Error connecting to server to load Templates", e, false, false);
                    return Collections.emptyList();
                }
            }
        };
    }

    private Function<List<? extends IReviewTemplate>, Void> getInitTemplateViewerFunc() {
        return new Function<List<? extends IReviewTemplate>, Void>(){

            public Void apply(List<? extends IReviewTemplate> possibleTemplates) {
                IReviewTemplate template = GeneralInfoWidget.this.generalInfo.getTemplate();
                ArrayList<IReviewTemplate> templateList = new ArrayList<IReviewTemplate>();
                for (IReviewTemplate iReviewTemplate : possibleTemplates) {
                    templateList.add(iReviewTemplate);
                    if (iReviewTemplate.getId() != template.getId()) continue;
                    template = iReviewTemplate;
                }
                if (!template.isActive()) {
                    template = new DMReviewTemplate(template.getId(), template.getName() + "(Disabled)", template.getDescription(), template.isDefault(), null, null, null, null, null, null, template.isActive(), template.isRemoteSystemLinksEnabled(), template.isCommentsDuringReworkEnabled(), template.isCommentsAfterDeadlineEnabled(), template.isReopenReviewIfCommentAdded(), template.isAllowToAssignDefects(), template.isRemoveHeadersAndFooters(), template.isOverrideGlobalReviewDeadline(), template.getReviewDeadlineDays(), template.isOverrideGlobalEnableEditableComments(), template.isEnableEditableComments(), template.isOverrideGlobalReviewAccessRestriction(), template.getReviewAccessRestriction());
                    templateList.add(template);
                }
                GeneralInfoWidget.this.templateViewer.setInput(templateList);
                GeneralInfoWidget.this.templateViewer.setSelection(Collections.singletonList(template));
                GeneralInfoWidget.this.templateViewer.getCombo().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        GeneralInfoWidget.this.saveableListener.dirtyStateMayHaveChanged();
                    }
                });
                return null;
            }
        };
    }

    private void createGroupAreaJson() {
        if (this.clientSystemGlobals.shouldShowGroupSelect() || this.generalInfo.getGroup() != null) {
            Label groupLabel = new Label((Composite)this, 0);
            groupLabel.setText("Group:");
            groupLabel.setLayoutData((Object)new TableWrapData2(8, 16));
            Combo combo = new Combo((Composite)this, 8);
            combo.setLayoutData((Object)new TableWrapData2(256, 16));
            this.groupViewerJson = ComboViewer2.create(combo);
            this.groupViewerJson.setComparator(new ViewerComparator2());
            this.groupViewerJson.setContentProvider(CollectionContentProvider.getInstance());
            this.groupViewerJson.setLabelProvider((IBaseLabelProvider2<IGroup>)new LabelProvider2<IGroup>(){

                @Override
                public String getText(IGroup group) {
                    return group.getTitle();
                }
            });
            this.groupViewerJson.addFilter(new ViewerFilter2<IGroup>(){

                @Override
                public boolean select(Viewer viewer, Object parentElement, IGroup group) {
                    return true;
                }
            });
            this.initializeViewer("groups", this.getGetGroupsFuncJson(), this.getInitGroupViewerFuncJson());
        }
    }

    private Function<Void, List<? extends IGroup>> getGetGroupsFuncJson() {
        return new Function<Void, List<? extends IGroup>>(){

            public List<? extends IGroup> apply(Void param) {
                try {
                    List groups = JsonAPIHandler.getGroups((int)GeneralInfoWidget.this.generalInfo.getReviewSummary().getId());
                    return groups;
                }
                catch (CollabClientServerConnectivityException e) {
                    CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), "Error connecting to server to load Groups", e, false, false);
                    return Collections.EMPTY_LIST;
                }
                catch (CollabClientException ex) {
                    CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), "Error connecting to server to load Groups from Json", ex, false, false);
                    return Collections.EMPTY_LIST;
                }
            }
        };
    }

    private Function<List<? extends IGroup>, Void> getInitGroupViewerFuncJson() {
        return new Function<List<? extends IGroup>, Void>(){

            public Void apply(List<? extends IGroup> groups) {
                GeneralInfoWidget.this.groupViewerJson.setInput(groups);
                IGroup group = GeneralInfoWidget.this.generalInfo.getGroup();
                GeneralInfoWidget.this.groupViewerJson.setSelection(Collections.singletonList(group));
                GeneralInfoWidget.this.groupViewerJson.getCombo().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        GeneralInfoWidget.this.saveableListener.dirtyStateMayHaveChanged();
                    }
                });
                return null;
            }
        };
    }

    private <T> void initializeViewer(final String datamodelType, final Function<Void, T> getDatamodelInstancesFunc, final Function<T, Void> initializeViewerFunc) {
        Job job = new Job("Retrieving " + datamodelType){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Retrieving " + datamodelType, 100);
                try {
                    monitor.subTask("Connecting to server");
                    monitor.worked(30);
                    monitor.subTask("Retrieving possible " + datamodelType);
                    final Object types = getDatamodelInstancesFunc.apply(null);
                    monitor.worked(70);
                    GeneralInfoWidget.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            initializeViewerFunc.apply(types);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CollabClientServerConnectivityException e) {
                    String message = "Error loading possible " + datamodelType;
                    CollaboratorUI.openError(GeneralInfoWidget.this.getShell(), message, e, false, true);
                    return Status.OK_STATUS;
                }
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    private void createCreatedDateArea() {
        if (null != this.generalInfo.getCreationDate()) {
            Label creationDateLabel = new Label((Composite)this, 0);
            creationDateLabel.setText("Created:");
            creationDateLabel.setLayoutData((Object)new TableWrapData2(8, 16));
            this.creationDateText = new RightSizeText(this, 2056);
            this.creationDateText.setEnabled(false);
            String creationDateString = DateFormat.getDateTimeInstance().format(this.generalInfo.getCreationDate());
            this.creationDateText.setText(creationDateString);
            this.creationDateText.setLayoutData(new TableWrapData2(256, 16));
        }
    }

    private void createRoleArea() {
        Label roleLabel = new Label((Composite)this, 0);
        roleLabel.setText("Your Role:");
        roleLabel.setLayoutData((Object)new TableWrapData2(8, 16));
        this.roleText = new RightSizeText(this, 2056);
        this.roleText.setEnabled(false);
        this.roleText.setLayoutData(new TableWrapData2(256, 16));
        final ReviewParticipantHelper roleHelper = new ReviewParticipantHelper(this.clientSystemGlobals.getSelf()){

            public void roleChanged(IRole role) {
                if (role == null) {
                    GeneralInfoWidget.this.roleText.setText("(not participating)");
                } else {
                    GeneralInfoWidget.this.roleText.setText(StringUtils.defaultString((String)role.getName()));
                }
            }
        };
        final IReviewSummary reviewSummary = this.generalInfo.getReviewSummary();
        reviewSummary.addReviewSummaryListener((IReviewSummaryListener)roleHelper);
        roleHelper.roleChanged(null);
        ReviewSummaryAdapter.init((IReviewSummary)reviewSummary, (IReviewSummaryListener)roleHelper);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReviewSummaryAdapter.deInit((IReviewSummary)reviewSummary, (IReviewSummaryListener)roleHelper);
                reviewSummary.removeReviewSummaryListener((IReviewSummaryListener)roleHelper);
            }
        });
    }

    private void createTitleArea() {
        Label titleLabel = new Label((Composite)this, 0);
        titleLabel.setText("Title:");
        TableWrapData2 labelData = new TableWrapData2(8, 16);
        titleLabel.setLayoutData((Object)labelData);
        this.titleControl = new RightSizeText(this, 2114);
        TableWrapData2 controlData = new TableWrapData2(256, 256);
        this.titleControl.setLayoutData(controlData);
        this.titleControl.setText(this.generalInfo.getTitle());
        this.titleControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralInfoWidget.this.saveableListener.dirtyStateMayHaveChanged();
            }
        });
    }

    public CommandReviewEdit getSaveCommand() {
        boolean shouldChangeTemplate;
        CommandReviewEdit cmd = new CommandReviewEdit();
        if (this.titleDirty()) {
            cmd.setTitle(this.titleControl.getText());
        }
        if (this.isCustomFieldsDirty()) {
            cmd.setCustomFields(this.getCustomFieldValueRefs(null));
        }
        if (this.templateDirty() && (shouldChangeTemplate = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Confirm Review Template Change", (String)"Please confirm that you would like to change the template on this review."))) {
            cmd.setTemplate((IReviewTemplateRef)new ReviewTemplateRefByName(((IReviewTemplate)SmartBearUtils.getFirstObject(this.templateViewer.getSelection())).getName()));
        }
        if (this.groupDirty()) {
            cmd.setGroup((IGroupRef)new GroupRefByGuid(((IGroup)SmartBearUtils.getFirstObject(this.groupViewerJson.getSelection())).getGuid()));
        }
        return cmd;
    }

    public boolean isDirty() {
        return this.titleDirty() || this.templateDirty() || this.groupDirty() || this.isCustomFieldsDirty();
    }

    public boolean groupDirty() {
        if (null == this.groupViewerJson) {
            return false;
        }
        if (null == this.groupViewerJson.getInput()) {
            return false;
        }
        if (null == this.groupViewerJson.getSelection()) {
            return false;
        }
        IGroup selectedGroup = (IGroup)SmartBearUtils.getFirstObject(this.groupViewerJson.getSelection());
        if (null == selectedGroup) {
            return false;
        }
        return !selectedGroup.getGuid().equalsIgnoreCase(this.generalInfo.getGroup().getGuid());
    }

    public boolean templateDirty() {
        if (null == this.templateViewer) {
            return false;
        }
        if (null == this.templateViewer.getInput()) {
            return false;
        }
        if (this.generalInfo.getTemplate() == null) {
            return false;
        }
        if (SmartBearUtils.getFirstObject(this.templateViewer.getSelection()) == null) {
            return false;
        }
        return this.generalInfo.getTemplate().getId() != ((IReviewTemplate)SmartBearUtils.getFirstObject(this.templateViewer.getSelection())).getId();
    }

    private boolean titleDirty() {
        return !this.titleControl.getText().equalsIgnoreCase(this.generalInfo.getTitle());
    }

    private final IReviewGeneralInfoListener newGeneralInfoListener() {
        return new ReviewGeneralInfoAdapter(){

            public void titleChanged(IReviewGeneralInfo generalInfo, String title) {
                GeneralInfoWidget.this.titleControl.setText(StringUtils.defaultString((String)title));
                GeneralInfoWidget.this.saveableListener.dirtyStateMayHaveChanged();
            }

            public void reviewTemplateChanged(IReviewGeneralInfo generalInfo, IReviewTemplate template) {
                GeneralInfoWidget.this.initializeViewer("templates", GeneralInfoWidget.this.getGetTemplatesFunc(), GeneralInfoWidget.this.getInitTemplateViewerFunc());
                GeneralInfoWidget.this.saveableListener.dirtyStateMayHaveChanged();
            }

            public void completionDateChanged(IReviewGeneralInfo generalInfo, Date completionDate) {
                String completionDateString = completionDate != null ? DateFormat.getDateTimeInstance().format(completionDate) : "(In Progress)";
                GeneralInfoWidget.this.completedDateText.setText(StringUtils.defaultString((String)completionDateString));
            }

            public void whyNotAllowedToCancelChanged(IReviewGeneralInfo generalInfo, String whyNotAllowedToCancel) {
                GeneralInfoWidget.this.updateAbortReviewAction();
            }

            public void whyNotAllowedToReopenChanged(IReviewGeneralInfo generalInfo, String whyNotAllowedToReopen) {
                GeneralInfoWidget.this.updateReopenReviewAction();
            }

            public void whyNotAllowedToRejectChanged(IReviewGeneralInfo generalInfo, String whyNotAllowedToReject) {
                GeneralInfoWidget.this.updateRejectReviewAction();
            }

            public void whyNotAllowedToModifyGeneralInfoChanged(IReviewGeneralInfo generalInfo, String whyNotAllowedToModify) {
                boolean editable = StringUtils.isBlank((String)whyNotAllowedToModify);
                GeneralInfoWidget.this.titleControl.setEnabled(editable);
                if (null != GeneralInfoWidget.this.templateViewer) {
                    GeneralInfoWidget.this.templateViewer.getControl().setEnabled(editable);
                }
                if (null != GeneralInfoWidget.this.groupViewerJson) {
                    GeneralInfoWidget.this.groupViewerJson.getControl().setEnabled(editable);
                } else if (null != GeneralInfoWidget.this.groupViewerJson) {
                    GeneralInfoWidget.this.groupViewerJson.getControl().setEnabled(editable);
                }
            }
        };
    }

    private final IReviewMovingOnListener newMovingOnListener() {
        return new ReviewMovingOnAdapter(){

            public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
                GeneralInfoWidget.this.updateAbortReviewAction();
                GeneralInfoWidget.this.updateReopenReviewAction();
            }
        };
    }
}

