/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.base.Strings;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewAnnotate;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewDeclineSignature;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewFinish;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewSign;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewWait;
import com.smartbear.ccollab.datamodel.client.ActivityType;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewParticipant;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IUser;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.ReviewParticipantHelper;
import com.smartbear.ccollab.datamodel.client.SignatureStatus;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.swt.Button2;
import com.smartbear.swt.RightSizeText;
import com.smartbear.swt.SingleTypeLabelProvider;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.TopStackLayout;
import com.smartbear.util.commons.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MovingOnWidget
extends Composite {
    private final IClientSystemGlobals clientSystemGlobals;
    private final IReviewMovingOn movingOn;
    private final ICommandRunner commandRunner;
    private final TopStackLayout stackLayout;

    public MovingOnWidget(Composite parent, int style, final IClientSystemGlobals clientSystemGlobals, IReviewMovingOn movingOn, ICommandRunner commandRunner) {
        super(parent, style);
        this.clientSystemGlobals = clientSystemGlobals;
        this.movingOn = movingOn;
        this.commandRunner = commandRunner;
        this.stackLayout = new TopStackLayout();
        this.setLayout((Layout)this.stackLayout);
        final Control inspectingControl = this.createInspectingControl(this, SwtUtils.BASE_COMPOSITE_STYLE);
        final Control reworkControl = this.createReworkControl(this, SwtUtils.BASE_COMPOSITE_STYLE);
        final Control planningControl = this.createPlanningControl(this, SwtUtils.BASE_COMPOSITE_STYLE);
        final Control annotationControl = this.createAnnotatingControl(this, SwtUtils.BASE_COMPOSITE_STYLE);
        final Control completedControl = this.createTerminalControl(this);
        final Control signOffControl = this.createSignOffControl(this, SwtUtils.BASE_COMPOSITE_STYLE);
        final Control cancelledControl = this.createTerminalControl(this);
        final Control rejectedControl = this.createTerminalControl(this);
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void phaseChanged(final IReviewMovingOn movingOn, Phase phase) {
                Control control;
                MovingOnWidget.this.stackLayout.topControl = control = (Control)phase.accept((Phase.IPhaseVisitor)new Phase.IPhaseVisitor<Control>(){

                    public Control visitRework() {
                        return reworkControl;
                    }

                    public Control visitPlanning() {
                        return planningControl;
                    }

                    public Control visitAnnotating() {
                        return annotationControl;
                    }

                    public Control visitInspecting() {
                        return inspectingControl;
                    }

                    public Control visitCompleted() {
                        IReviewParticipant selfParticipant = ReviewParticipantHelper.findParticipant((IReviewSummary)movingOn.getReviewSummary(), (IUser)clientSystemGlobals.getSelf());
                        if (selfParticipant != null && selfParticipant.getRole().isRequiredToSign() || movingOn.isNeedsSignatures()) {
                            return signOffControl;
                        }
                        return completedControl;
                    }

                    public Control visitCancelled() {
                        return cancelledControl;
                    }

                    public Control visitRejected() {
                        return rejectedControl;
                    }
                });
                MovingOnWidget.this.layout();
                SwtUtils.resizeVerticalIfNecessary((Control)MovingOnWidget.this);
            }
        });
    }

    private Control createTerminalControl(Composite parent) {
        final Label control = new Label(parent, 0x1000040);
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
                control.setText("This Review has been " + phase.getName());
            }
        });
        return control;
    }

    private Control createInspectingControl(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new TableWrapLayout());
        final RightSizeText explanationText = new RightSizeText(composite, SwtUtils.BASE_COMPOSITE_STYLE | 0x1000000 | 0x40 | 2);
        explanationText.setLayoutData(new TableWrapData(256, 256));
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void explanationChanged(IReviewMovingOn movingOn, String explanation) {
                explanationText.setText(StringUtils.defaultString((String)explanation));
            }
        });
        GridLayoutFactory compositeLayoutFactory = GridLayoutFactory.swtDefaults().numColumns(4);
        Composite waitingComposite = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        waitingComposite.setLayoutData((Object)new TableWrapData(4, 32));
        waitingComposite.setLayout((Layout)compositeLayoutFactory.create());
        Label iAmLabel = new Label(waitingComposite, 0);
        iAmLabel.setText("I am ");
        iAmLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        final Button2 waitingButton = new Button2(waitingComposite, 8);
        waitingButton.setLayoutData(GridDataFactory.swtDefaults().create());
        waitingButton.setText("Waiting");
        waitingButton.setToolTipText("If you choose to wait, you will be notified when the specified action occurs.");
        Label untilLabel = new Label(waitingComposite, 0);
        untilLabel.setText(" until ");
        untilLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        final ComboViewer combo = this.createActivityTypeCombo(waitingComposite);
        combo.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().create());
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActivityType activityType = SwtUtils.getSelection(combo.getSelection(), ActivityType.class);
                String whyNotAllowed = MovingOnWidget.this.movingOn.getWhyNotAllowedToWait(activityType);
                waitingButton.setEnabled(StringUtils.isBlank((String)whyNotAllowed));
                waitingButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)whyNotAllowed, null));
            }
        });
        waitingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityType activityType = SwtUtils.getSelection(combo.getSelection(), ActivityType.class);
                CommandReviewWait command = new CommandReviewWait();
                command.setUntil(activityType);
                MovingOnWidget.this.commandRunner.run((Command)command, false);
            }
        });
        ActivityType initialActivityType = null;
        for (ActivityType activityType : ActivityType.values()) {
            if (!StringUtils.isBlank((String)this.movingOn.getWhyNotAllowedToWait(activityType))) continue;
            initialActivityType = activityType;
            break;
        }
        initialActivityType = (ActivityType)ObjectUtils.defaultIfNull(initialActivityType, (Object)ActivityType.Any);
        combo.setSelection((ISelection)new StructuredSelection((Object)initialActivityType), true);
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void whyNotAllowedToWaitChanged(IReviewMovingOn movingOn, ActivityType activityType, String whyNotAllowedToWait) {
                ActivityType selectedActivityType = SwtUtils.getSelection(combo.getSelection(), ActivityType.class);
                if (selectedActivityType == activityType) {
                    waitingButton.setEnabled(StringUtils.isBlank((String)whyNotAllowedToWait));
                    waitingButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)whyNotAllowedToWait, null));
                }
            }
        });
        Composite finishedComposite = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        finishedComposite.setLayoutData((Object)new TableWrapData(4, 32));
        finishedComposite.setLayout((Layout)compositeLayoutFactory.create());
        iAmLabel = new Label(finishedComposite, 0);
        iAmLabel.setText("I am ");
        iAmLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        final Button2 finishedButton = new Button2(finishedComposite, 8);
        finishedButton.setLayoutData(GridDataFactory.swtDefaults().create());
        finishedButton.setText("Finished");
        untilLabel = new Label(finishedComposite, 0);
        untilLabel.setText(" until ");
        untilLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        combo = this.createActivityTypeCombo(finishedComposite);
        combo.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().create());
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActivityType activityType = SwtUtils.getSelection(combo.getSelection(), ActivityType.class);
                String whyNot = MovingOnWidget.this.movingOn.getWhyNotAllowedToFinish(activityType);
                finishedButton.setEnabled(StringUtils.isBlank((String)whyNot));
                finishedButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)whyNot, null));
                String enabledToolTip = (String)activityType.accept((ActivityType.IActivityTypeVisitor)new ActivityType.IActivityTypeVisitor<String>(){

                    public String visitAny() {
                        return "If another participant makes an additional comment, uploads a file, or modifies a " + MovingOnWidget.this.clientSystemGlobals.getDefectLabelSingular() + ", you will be re-invited to the Review.";
                    }

                    public String visitAuthor() {
                        return "If the " + MovingOnWidget.this.movingOn.getAuthorRoleName() + " comments or uploads a file, you will be re-invited to the Review.";
                    }

                    public String visitFile() {
                        return "If another participant uploads a file, you will be re-invited to the Review.";
                    }

                    public String visitPoke() {
                        return "If another participant pokes you, you will be re-invited to the Review.";
                    }
                });
                finishedButton.setEnabledToolTipText(StringUtils.defaultIfEmpty((String)enabledToolTip, null));
            }
        });
        finishedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityType activityType = SwtUtils.getSelection(combo.getSelection(), ActivityType.class);
                CommandReviewFinish command = new CommandReviewFinish();
                command.setUntil(activityType);
                MovingOnWidget.this.commandRunner.run((Command)command, false);
            }
        });
        initialActivityType = null;
        for (ActivityType activityType : ActivityType.values()) {
            if (!StringUtils.isBlank((String)this.movingOn.getWhyNotAllowedToFinish(activityType))) continue;
            initialActivityType = activityType;
            break;
        }
        initialActivityType = (ActivityType)ObjectUtils.defaultIfNull((Object)initialActivityType, (Object)ActivityType.Any);
        combo.setSelection((ISelection)new StructuredSelection((Object)initialActivityType), true);
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void whyNotAllowedToFinishChanged(IReviewMovingOn movingOn, ActivityType activityType, String whyNotAllowedToFinish) {
                ActivityType selectedActivityType = SwtUtils.getSelection(combo.getSelection(), ActivityType.class);
                if (selectedActivityType == activityType) {
                    finishedButton.setEnabled(StringUtils.isBlank((String)whyNotAllowedToFinish));
                    finishedButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)whyNotAllowedToFinish, null));
                }
            }
        });
        return composite;
    }

    private ComboViewer createActivityTypeCombo(Composite parent) {
        ComboViewer combo = new ComboViewer(parent);
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new SingleTypeLabelProvider<ActivityType>(ActivityType.class){

            @Override
            public String doGetText(ActivityType activityType) {
                return activityType.getDisplayName(MovingOnWidget.this.movingOn.getAuthorRoleName());
            }
        });
        combo.setInput((Object)ActivityType.values());
        return combo;
    }

    private Control createReworkControl(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new TableWrapLayout());
        final RightSizeText explanationText = new RightSizeText(composite, 0x1000040);
        explanationText.setLayoutData(new TableWrapData(256, 256));
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void explanationChanged(IReviewMovingOn movingOn, String explanation) {
                explanationText.setText(StringUtils.defaultString((String)explanation));
            }
        });
        final Button2 finishButton = new Button2(composite, 8);
        TableWrapData layoutData = new TableWrapData();
        layoutData.align = 4;
        layoutData.valign = 4;
        layoutData.grabHorizontal = true;
        layoutData.grabVertical = true;
        finishButton.setLayoutData(layoutData);
        finishButton.setText(WordUtils.capitalize((String)this.clientSystemGlobals.getDefectsLabelPlural()) + " fixed; Proceed to Verification");
        finishButton.setDisabledToolTipText("An " + this.movingOn.getAuthorRoleName() + " can indicate that " + this.clientSystemGlobals.getDefectsLabelPlural() + " have been fixed and move this Review back to the 'Inspection' phase");
        finishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandReviewFinish command = new CommandReviewFinish();
                MovingOnWidget.this.commandRunner.run((Command)command, false);
            }
        });
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void isAuthorRoleChanged(IReviewMovingOn movingOn, boolean isAuthorRole) {
                finishButton.setEnabled(isAuthorRole);
            }
        });
        return composite;
    }

    private Control createPlanningControl(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        final RightSizeText explanationText = new RightSizeText(composite, SwtUtils.BASE_COMPOSITE_STYLE | 0x1000000 | 0x40);
        TableWrapData textLayoutData = new TableWrapData(256, 256);
        textLayoutData.colspan = 2;
        explanationText.setLayoutData(textLayoutData);
        final Button2 beginButton = new Button2(composite, 8);
        TableWrapData layoutData = new TableWrapData();
        layoutData.align = 4;
        layoutData.valign = 4;
        layoutData.grabHorizontal = true;
        layoutData.grabVertical = true;
        beginButton.setLayoutData(layoutData);
        beginButton.setText("Begin Review");
        beginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandReviewFinish command = new CommandReviewFinish();
                MovingOnWidget.this.commandRunner.run((Command)command, false);
            }
        });
        final Button2 annotateButton = new Button2(composite, 8);
        TableWrapData layoutData2 = new TableWrapData();
        layoutData2.align = 4;
        layoutData2.valign = 4;
        layoutData2.grabHorizontal = true;
        layoutData2.grabVertical = true;
        annotateButton.setLayoutData(layoutData2);
        annotateButton.setText("Annotate Review");
        annotateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandReviewAnnotate command = new CommandReviewAnnotate();
                MovingOnWidget.this.commandRunner.run((Command)command, false);
            }
        });
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void explanationChanged(IReviewMovingOn movingOn, String explanation) {
                explanationText.setText(StringUtils.defaultString((String)explanation));
            }

            public void whyNotAllowedToFinishChanged(IReviewMovingOn movingOn, ActivityType activityType, String whyNotAllowedToFinish) {
                if (activityType == ActivityType.Any) {
                    beginButton.setEnabled(StringUtils.isBlank((String)whyNotAllowedToFinish));
                    beginButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)whyNotAllowedToFinish, null));
                }
            }

            public void whyNotAllowedToAnnotateChanged(IReviewMovingOn movingOn, String whyNotAllowedToAnnotate) {
                annotateButton.setEnabled(StringUtils.isBlank((String)whyNotAllowedToAnnotate));
                annotateButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)whyNotAllowedToAnnotate, null));
            }
        });
        return composite;
    }

    private Control createAnnotatingControl(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new TableWrapLayout());
        final RightSizeText explanationText = new RightSizeText(composite, SwtUtils.BASE_COMPOSITE_STYLE | 0x1000000 | 0x40);
        explanationText.setLayoutData(new TableWrapData(256, 256));
        final Button2 beginButton = new Button2(composite, 8);
        TableWrapData layoutData = new TableWrapData();
        layoutData.align = 4;
        layoutData.valign = 4;
        layoutData.grabHorizontal = true;
        layoutData.grabVertical = true;
        beginButton.setLayoutData(layoutData);
        beginButton.setText("Begin Review");
        beginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandReviewFinish command = new CommandReviewFinish();
                MovingOnWidget.this.commandRunner.run((Command)command, false);
            }
        });
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void explanationChanged(IReviewMovingOn movingOn, String explanation) {
                explanationText.setText(StringUtils.defaultString((String)explanation));
            }

            public void whyNotAllowedToFinishChanged(IReviewMovingOn movingOn, ActivityType activityType, String whyNotAllowedToFinish) {
                if (activityType == ActivityType.Any) {
                    beginButton.setEnabled(StringUtils.isBlank((String)whyNotAllowedToFinish));
                    beginButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)whyNotAllowedToFinish, null));
                }
            }
        });
        return composite;
    }

    private Control createSignOffControl(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        final RightSizeText informationText = new RightSizeText(composite, SwtUtils.BASE_COMPOSITE_STYLE | 0x1000000 | 0x40);
        TableWrapData textLayoutData = new TableWrapData(256, 256);
        textLayoutData.colspan = 2;
        informationText.setLayoutData(textLayoutData);
        final Button2 signButton = new Button2(composite, 8);
        TableWrapData layoutData = new TableWrapData();
        layoutData.align = 4;
        layoutData.valign = 4;
        layoutData.grabHorizontal = true;
        layoutData.grabVertical = true;
        signButton.setLayoutData(layoutData);
        signButton.setText("Sign");
        signButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MovingOnWidget.this.commandRunner.run((Command)new CommandReviewSign(), false);
            }
        });
        final Button2 declineButton = new Button2(composite, 8);
        TableWrapData layoutData2 = new TableWrapData();
        layoutData2.align = 4;
        layoutData2.valign = 4;
        layoutData2.grabHorizontal = true;
        layoutData2.grabVertical = true;
        declineButton.setLayoutData(layoutData2);
        declineButton.setText("Decline");
        declineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MovingOnWidget.this.commandRunner.run((Command)new CommandReviewDeclineSignature(), false);
            }
        });
        this.processMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void signatureStatusChanged(IReviewMovingOn movingOn, SignatureStatus reviewSignatureStatus) {
                MovingOnWidget.this.updateSignOffControls(informationText, signButton, declineButton);
            }
        });
        final ReviewParticipantHelper selfListener = new ReviewParticipantHelper(this.clientSystemGlobals.getSelf()){

            public void signatureStatusChanged(SignatureStatus status) {
                MovingOnWidget.this.updateSignOffControls(informationText, signButton, declineButton);
            }

            public void requiredToSignChanged(boolean isRequiredToSign) {
                MovingOnWidget.this.updateSignOffControls(informationText, signButton, declineButton);
            }
        };
        this.movingOn.getReviewSummary().addReviewSummaryListener((IReviewSummaryListener)selfListener);
        ReviewSummaryAdapter.init((IReviewSummary)this.movingOn.getReviewSummary(), (IReviewSummaryListener)selfListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReviewSummaryAdapter.deInit((IReviewSummary)MovingOnWidget.this.movingOn.getReviewSummary(), (IReviewSummaryListener)selfListener);
                MovingOnWidget.this.movingOn.getReviewSummary().removeReviewSummaryListener((IReviewSummaryListener)selfListener);
            }
        });
        return composite;
    }

    private void updateSignOffControls(Text informationText, Button2 signButton, Button2 declineButton) {
        IReviewParticipant selfParticipant = ReviewParticipantHelper.findParticipant((IReviewSummary)this.movingOn.getReviewSummary(), (IUser)this.clientSystemGlobals.getSelf());
        String status = SignatureStatus.getNoSignStatusText((SignatureStatus)this.movingOn.getSignatureStatus(), (SignatureStatus)(selfParticipant == null ? null : selfParticipant.getSignatureStatus()), (boolean)(selfParticipant == null ? false : selfParticipant.getRole().isRequiredToSign()));
        informationText.setText(Strings.nullToEmpty((String)status));
        boolean sigNeeded = Strings.isNullOrEmpty((String)status);
        informationText.setVisible(!sigNeeded);
        signButton.setVisible(sigNeeded);
        declineButton.setVisible(sigNeeded);
    }

    private void processMovingOnListener(final IReviewMovingOnListener listener) {
        this.movingOn.addMovingOnListener(listener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MovingOnWidget.this.movingOn.removeMovingOnListener(listener);
            }
        });
        ReviewMovingOnAdapter.init((IReviewMovingOn)this.movingOn, (IReviewMovingOnListener)listener);
    }
}

