/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.CommandNoop;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewEdit;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IContributor;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.ICustomFieldTarget;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewParticipant;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IUser;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.listener.ICustomFieldListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.CustomFieldAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.CustomFieldTargetWidget;
import com.smartbear.jface.ColumnLabelProvider2;
import com.smartbear.jface.ISelectionChangedListener2;
import com.smartbear.jface.LabelProviderChangedEvent2;
import com.smartbear.jface.StructuredContentProvider2;
import com.smartbear.jface.TableViewer2;
import com.smartbear.jface.TableViewerColumn2;
import com.smartbear.jface.ViewerFilter2;
import com.smartbear.swt.TableWrapData2;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.SmartBearUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParticipantCustomFieldsWidget
extends CustomFieldTargetWidget {
    private static final String COLUMN_VISIBLE_KEY = ParticipantCustomFieldsWidget.class.getName() + ".columnVisible";
    private static final String CUSTOM_FIELD_KEY = ParticipantCustomFieldsWidget.class.getName() + ".customField";
    private final IReviewSummaryListener reviewSummaryListener = new ReviewSummaryAdapter(){

        public void participantsAdded(IReviewSummary reviewSummary, ArrayList<? extends IReviewParticipant> addedParticipants) {
            for (IReviewParticipant iReviewParticipant : addedParticipants) {
                IContributor user = iReviewParticipant.getUser();
                if (user == null || !user.equals(ParticipantCustomFieldsWidget.this.self)) continue;
                ParticipantCustomFieldsWidget.this.setTarget((ICustomFieldTarget)iReviewParticipant);
                break;
            }
        }

        public void participantsRemoved(IReviewSummary reviewSummary, ArrayList<? extends IReviewParticipant> removedParticipants) {
            for (IReviewParticipant iReviewParticipant : removedParticipants) {
                IContributor user = iReviewParticipant.getUser();
                if (user == null || !user.equals(ParticipantCustomFieldsWidget.this.self)) continue;
                ParticipantCustomFieldsWidget.this.setTarget(null);
                break;
            }
        }
    };
    private final IReviewMovingOnListener phaseVisibilityListener = new ReviewMovingOnAdapter(){

        public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
            TableLayout tableLayout = new TableLayout();
            boolean visibilityChanged = false;
            for (TableColumn column : ParticipantCustomFieldsWidget.this.tableViewer.getControl().getColumns()) {
                boolean columnVisible = Boolean.TRUE.equals(column.getData(COLUMN_VISIBLE_KEY));
                ICustomField customField = (ICustomField)column.getData(CUSTOM_FIELD_KEY);
                if (customField != null && columnVisible != customField.getVisiblePhases().contains(phase)) {
                    visibilityChanged = true;
                }
                if (customField == null) {
                    tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(0));
                    continue;
                }
                if (customField.getVisiblePhases().contains(phase)) {
                    tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(0));
                } else {
                    tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(0, false, false));
                }
                column.setData(COLUMN_VISIBLE_KEY, (Object)customField.getVisiblePhases().contains(phase));
            }
            if (visibilityChanged) {
                ParticipantCustomFieldsWidget.this.tableViewer.getControl().setLayout((Layout)tableLayout);
                ParticipantCustomFieldsWidget.this.tableViewer.getControl().layout();
            }
        }
    };
    private IReviewParticipant selectedParticipant;
    private IUser self;
    private final TableViewer2<IReviewSummary, IReviewParticipant> tableViewer;

    public ParticipantCustomFieldsWidget(Composite parent, int style, IClientSystemGlobals clientSystemGlobals, final IReviewSummary reviewSummary, ISaveableListener saveableListener, IStyledTextDecorator userTextDecorator) {
        super(parent, style, reviewSummary, saveableListener);
        this.self = clientSystemGlobals.getSelf();
        ArrayList customFields = reviewSummary.getGeneralInfo().getTemplate().getParticipantCustomFields();
        this.tableViewer = TableViewer2.create(this, 68352);
        this.tableViewer.getControl().setLayoutData((Object)new TableWrapData2(256, 256, 1, 4));
        this.tableViewer.getControl().setHeaderVisible(true);
        this.tableViewer.getControl().setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer.getInner());
        TableViewerColumn2<IReviewParticipant> nameColumn = TableViewerColumn2.create(this.tableViewer);
        ((TableColumn)nameColumn.getColumn()).setText("Name");
        ((TableColumn)nameColumn.getColumn()).setToolTipText("Name of participant");
        nameColumn.setLabelProvider(new ColumnLabelProvider2<IReviewParticipant>(){

            @Override
            public String getText(IReviewParticipant participant) {
                return participant.getUser().getDisplayName();
            }
        });
        for (ICustomField field : customFields) {
            TableViewerColumn2<IReviewParticipant> fieldColumn = TableViewerColumn2.create(this.tableViewer);
            ((TableColumn)fieldColumn.getColumn()).setText(field.getTitle());
            ((TableColumn)fieldColumn.getColumn()).setToolTipText(field.getDescription());
            ((TableColumn)fieldColumn.getColumn()).setData(CUSTOM_FIELD_KEY, (Object)field);
            fieldColumn.setLabelProvider(new CustomFieldColumnLabelProvider(field));
        }
        reviewSummary.getMovingOn().addMovingOnListener(this.phaseVisibilityListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.getMovingOn().removeMovingOnListener(ParticipantCustomFieldsWidget.this.phaseVisibilityListener);
            }
        });
        ReviewMovingOnAdapter.init((IReviewMovingOn)reviewSummary.getMovingOn(), (IReviewMovingOnListener)this.phaseVisibilityListener);
        this.tableViewer.setContentProvider(new ParticipantContentProvider());
        this.tableViewer.addFilter(new ViewerFilter2<IReviewParticipant>(){

            @Override
            public boolean select(Viewer viewer, Object parentElement, IReviewParticipant participant) {
                IContributor user = participant.getUser();
                return user != null;
            }
        });
        this.tableViewer.setInput(reviewSummary);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener2<IReviewParticipant>(){

            @Override
            public void selectionChanged(List<IReviewParticipant> selection) {
                IReviewParticipant reviewParticipant;
                ParticipantCustomFieldsWidget.this.selectedParticipant = reviewParticipant = (IReviewParticipant)SmartBearUtils.getFirstObject(selection);
                ParticipantCustomFieldsWidget.this.setTarget((ICustomFieldTarget)reviewParticipant);
            }
        });
        TableItem[] items = this.tableViewer.getTable().getItems();
        for (int i = 0; i < items.length; ++i) {
            IReviewParticipant participant = (IReviewParticipant)items[i].getData();
            IContributor user = participant.getUser();
            if (user == null || !user.equals(this.self)) continue;
            this.currentParticipant = participant;
            this.selectedParticipant = participant;
            this.tableViewer.getTable().setSelection(i);
            break;
        }
        this.addCustomFieldControls(customFields, userTextDecorator);
        reviewSummary.addReviewSummaryListener(this.reviewSummaryListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.removeReviewSummaryListener(ParticipantCustomFieldsWidget.this.reviewSummaryListener);
            }
        });
        ReviewSummaryAdapter.init((IReviewSummary)reviewSummary, (IReviewSummaryListener)this.reviewSummaryListener);
    }

    public boolean isDirty() {
        return this.isCustomFieldsDirty();
    }

    public Command getSaveCommand() {
        if (this.isDirty()) {
            CommandReviewEdit cmd = new CommandReviewEdit();
            cmd.setParticipantCustomFields(this.getCustomFieldValueRefs((ICustomFieldTarget)this.selectedParticipant));
            return cmd;
        }
        return CommandNoop.INSTANCE;
    }

    private static final class CustomFieldColumnLabelProvider
    extends ColumnLabelProvider2<ICustomFieldTarget> {
        private final ICustomFieldListener listener = new CustomFieldAdapter(){

            public void customFieldChanged(ICustomFieldTarget target, ICustomField customField, HashSet<String> newValue) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent2<ICustomFieldTarget>(this, target));
            }
        };
        private final ICustomField field;

        private CustomFieldColumnLabelProvider(ICustomField field) {
            this.field = field;
        }

        @Override
        public void update(ViewerCell cell, final ICustomFieldTarget target) {
            super.update(cell, target);
            target.addCustomFieldListener(this.field, this.listener);
            cell.getItem().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    target.removeCustomFieldListener(field, listener);
                }
            });
        }

        @Override
        public String getText(ICustomFieldTarget target) {
            return StringUtils.join((Collection)target.getCustomFieldValue(this.field), (String)", ").replaceAll("\n", " ");
        }

        @Override
        public String getToolTipText(ICustomFieldTarget target) {
            return StringUtils.join((Collection)target.getCustomFieldValue(this.field), (String)"\n");
        }
    }

    private static final class ParticipantContentProvider
    extends StructuredContentProvider2<IReviewSummary, IReviewParticipant> {
        private final IReviewSummaryListener listener = new ReviewSummaryAdapter(){

            public void participantsAdded(IReviewSummary reviewSummary, ArrayList<? extends IReviewParticipant> addedParticipants) {
                this.getViewer().refresh();
            }

            public void participantsRemoved(IReviewSummary reviewSummary, ArrayList<? extends IReviewParticipant> removedParticipants) {
                this.getViewer().refresh();
            }
        };

        private ParticipantContentProvider() {
        }

        @Override
        protected void doInputChanged(IReviewSummary oldReviewSummary, IReviewSummary newReviewSummary) {
            if (oldReviewSummary != null) {
                oldReviewSummary.removeReviewSummaryListener(this.listener);
            }
            if (newReviewSummary != null) {
                newReviewSummary.addReviewSummaryListener(this.listener);
            }
        }

        @Override
        public Collection<? extends IReviewParticipant> getElements(IReviewSummary reviewSummary) {
            return reviewSummary.getParticipants();
        }
    }
}

