/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.AbstractReviewCommand;
import com.smartbear.ccollab.client.commands.admin.review.CommandSetParticipants;
import com.smartbear.ccollab.client.commands.admin.review.participant.CommandParticipantPoke;
import com.smartbear.ccollab.client.commands.admin.review.reviewpool.CommandReviewPoolTake;
import com.smartbear.ccollab.client.commands.argrefs.IParticipantRef;
import com.smartbear.ccollab.client.commands.argrefs.IReviewPoolParticipantRef;
import com.smartbear.ccollab.client.commands.argrefs.IUserRef;
import com.smartbear.ccollab.client.commands.argrefs.ParticipantRefById;
import com.smartbear.ccollab.client.commands.argrefs.ReviewPoolParticipantRefBySpec;
import com.smartbear.ccollab.client.commands.argrefs.UserRefById;
import com.smartbear.ccollab.datamodel.client.AssignmentState;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IContributor;
import com.smartbear.ccollab.datamodel.client.IGroup;
import com.smartbear.ccollab.datamodel.client.IRecentParticipants;
import com.smartbear.ccollab.datamodel.client.IReviewGeneralInfo;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewParticipant;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewTemplate;
import com.smartbear.ccollab.datamodel.client.IRole;
import com.smartbear.ccollab.datamodel.client.IUser;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.SignatureStatus;
import com.smartbear.ccollab.datamodel.client.impl.DMGroup;
import com.smartbear.ccollab.datamodel.client.impl.DMRecentParticipants;
import com.smartbear.ccollab.datamodel.client.listener.IReviewGeneralInfoListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewParticipantListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewGeneralInfoAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewParticipantAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.group.response.GroupDescription;
import com.smartbear.collaborator.json.interfaces.group.response.GroupListResponse;
import com.smartbear.collaborator.json.interfaces.review.request.ParticipantFilterRequest;
import com.smartbear.collaborator.json.interfaces.review.request.RecentParticipantRequest;
import com.smartbear.collaborator.json.interfaces.review.response.ParticipantResponse;
import com.smartbear.collaborator.json.interfaces.review.response.RecentParticipantsResponse;
import com.smartbear.collaborator.json.utils.JsonUtils;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.jface.CollectionContentProvider;
import com.smartbear.jface.IActionProvider;
import com.smartbear.jface.IBaseLabelProvider2;
import com.smartbear.jface.IStructuredContentProvider2;
import com.smartbear.jface.LabelProvider2;
import com.smartbear.jface.LinkListViewer2;
import com.smartbear.jface.StructuredContentProvider2;
import com.smartbear.jface.StructuredViewer2;
import com.smartbear.jface.StyledCellLabelProvider2;
import com.smartbear.jface.TableViewer2;
import com.smartbear.jface.ViewerComparator2;
import com.smartbear.jface.ViewerFilter2;
import com.smartbear.swt.Button2;
import com.smartbear.swt.IDragHandler;
import com.smartbear.swt.LocalDragAdapter;
import com.smartbear.swt.RightSizeText;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.DeepObject;
import com.smartbear.util.Strings;
import com.smartbear.util.commons.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ParticipantsWidget
extends Composite {
    private final ISaveableListener saveableListener;
    private RightSizeText filterText;
    private Label filterLabel;
    private Label label;
    private static final int MAX_FILTER_PARTICIPANT_RECORDS = 100;
    private final IReviewSummaryListener reviewSummaryListener = new ReviewSummaryAdapter(){

        public void participantsRemoved(IReviewSummary reviewSummary, ArrayList<? extends IReviewParticipant> removedParticipants) {
            ArrayList removedRecords = Lists.newArrayListWithCapacity((int)removedParticipants.size());
            for (IReviewParticipant iReviewParticipant : removedParticipants) {
                iReviewParticipant.removeParticipantListener(ParticipantsWidget.this.participantListener);
                if (iReviewParticipant.getUser() == null) continue;
                ParticipantRecord record = ParticipantsWidget.this.getRecordForUser((IUser)iReviewParticipant.getUser());
                if (record == null) {
                    record = new ParticipantRecord(iReviewParticipant);
                }
                removedRecords.add(record);
            }
            removedRecords.addAll(ParticipantsWidget.this.getPoolRecords());
            ParticipantsWidget.this.changeParticipants(ParticipantsWidget.createPoolParticipantRecords(reviewSummary), removedRecords);
        }

        public void participantsAdded(IReviewSummary reviewSummary, ArrayList<? extends IReviewParticipant> addedParticipants) {
            ArrayList addedRecords = Lists.newArrayListWithCapacity((int)addedParticipants.size());
            ArrayList recordsToRemove = Lists.newArrayListWithCapacity((int)addedParticipants.size());
            for (IReviewParticipant iReviewParticipant : addedParticipants) {
                iReviewParticipant.addParticipantListener(ParticipantsWidget.this.participantListener);
                if (iReviewParticipant.getUser() == null) continue;
                addedRecords.add(new ParticipantRecord(iReviewParticipant));
                ParticipantRecord record = ParticipantsWidget.this.getRecordForUser((IUser)iReviewParticipant.getUser());
                if (record == null) {
                    record = new ParticipantRecord(iReviewParticipant);
                }
                recordsToRemove.add(record);
            }
            recordsToRemove.addAll(ParticipantsWidget.this.getPoolRecords());
            addedRecords.addAll(ParticipantsWidget.createPoolParticipantRecords(reviewSummary));
            ParticipantsWidget.this.changeParticipants(addedRecords, recordsToRemove);
        }
    };
    private final IReviewParticipantListener participantListener = new ReviewParticipantAdapter(){

        public void roleChanged(IReviewParticipant participant, IRole role) {
            IContributor user = participant.getUser();
            IRole oldRole = null;
            if (user != null) {
                for (ParticipantRecord participantRecord : ParticipantsWidget.this.participants) {
                    if (!user.equals(participantRecord.user)) continue;
                    oldRole = participantRecord.role;
                    break;
                }
                if (oldRole == null) {
                    throw new IllegalArgumentException("User '" + user.getDisplayName() + "' does not have a role in this review");
                }
                ParticipantRecord record = ParticipantsWidget.this.getRecordForUser((IUser)participant.getUser());
                ArrayList<ParticipantRecord> recordToRemove = new ArrayList<ParticipantRecord>();
                if (record != null) {
                    recordToRemove.add(record);
                }
                ParticipantsWidget.this.changeParticipants(Collections.singletonList(new ParticipantRecord(role, (IUser)user, participant.getPoolGroup())), recordToRemove);
            } else {
                ParticipantsWidget.this.changeParticipants(ParticipantsWidget.createPoolParticipantRecords(ParticipantsWidget.this.reviewSummary), ParticipantsWidget.this.getPoolRecords());
            }
        }

        private void refreshLabel(IReviewParticipant participant) {
            for (ParticipantRecord participantRecord : ParticipantsWidget.this.participants) {
                IUser user = participantRecord.user;
                if (user != null && !user.equals(participant.getUser())) continue;
                ParticipantsWidget.this.roleViewers.get(participantRecord.role).refresh(participantRecord, true);
                break;
            }
        }

        public void stateChanged(IReviewParticipant participant, AssignmentState state) {
            this.refreshLabel(participant);
        }

        public void signatureStatusChanged(IReviewParticipant participant, SignatureStatus status) {
            this.refreshLabel(participant);
        }
    };
    private final IReviewGeneralInfoListener reviewGeneralInfoListener = new ReviewGeneralInfoAdapter(){

        public void whyNotAllowedToModifyParticipantsChanged(IReviewGeneralInfo generalInfo, String whyNotAllowedToModifyParticipants) {
            boolean canModify = StringUtils.isBlank((String)whyNotAllowedToModifyParticipants);
            ParticipantsWidget.this.addSelfViewer.getControl().setEnabled(canModify);
            ParticipantsWidget.this.addRecentViewer.getControl().setEnabled(canModify);
        }
    };
    private final IReviewMovingOnListener movingOnListener = new ReviewMovingOnAdapter(){

        public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
            if (ParticipantsWidget.this.clientSystemGlobals.isESigsEnabled()) {
                for (TableViewer2<List<? extends ParticipantRecord>, ParticipantRecord> roleViewer : ParticipantsWidget.this.roleViewers.values()) {
                    roleViewer.refresh(true);
                }
            }
        }
    };
    private final IClientSystemGlobals clientSystemGlobals;
    private final IReviewSummary reviewSummary;
    private final ICommandRunner commandRunner;
    private final Object cacheLock = new Object();
    private Font italicFont;
    private Color signedColor;
    private Color unsignedColor;
    private Color declinedColor;
    private List<? extends PossibleParticipant> possibleParticipantsCache;
    private IRecentParticipants recentParticipantsCache;
    private IGroup groupCache;
    private List<? extends PossibleParticipant> possibleParticipantsInGroupCache;
    private IRecentParticipants recentParticipantsInGroupCache;
    private final List<ParticipantRecord> participants = new ArrayList<ParticipantRecord>();
    private final Map<IRole, CLabel> roleLabels;
    private final Map<IRole, TableViewer2<List<? extends ParticipantRecord>, ParticipantRecord>> roleViewers;
    private final ExpandableComposite addParticipantsComposite;
    private TableViewer2<List<? extends PossibleParticipant>, PossibleParticipant> possibleParticipantsViewer;
    private LinkListViewer2<List<ParticipantRecord>, ParticipantRecord> addSelfViewer;
    private LinkListViewer2<IRecentParticipants, ParticipantRecord> addRecentViewer;
    private Button groupFilter;

    public ParticipantsWidget(Composite parent, int style, ToolBarManager toolBarManager, ISaveableListener saveableListener, IClientSystemGlobals clientSystemGlobals, final IReviewSummary reviewSummary, ICommandRunner commandRunner) {
        super(parent, style);
        this.saveableListener = saveableListener;
        this.clientSystemGlobals = clientSystemGlobals;
        this.reviewSummary = reviewSummary;
        this.commandRunner = commandRunner;
        ArrayList roles = reviewSummary.getGeneralInfo().getTemplate().getRoles();
        int numRoles = roles.size();
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(numRoles).spacing(LayoutConstants.getSpacing().x, 0).create());
        this.roleLabels = Maps.newHashMapWithExpectedSize((int)numRoles);
        GridDataFactory roleLabelLayoutFactory = GridDataFactory.fillDefaults().grab(true, false);
        for (Object role : roles) {
            CLabel label = new CLabel((Composite)this, 0);
            label.setToolTipText(role.getDescription());
            label.setLayoutData((Object)roleLabelLayoutFactory.create());
            this.roleLabels.put((IRole)role, label);
        }
        this.roleViewers = Maps.newHashMapWithExpectedSize((int)numRoles);
        GridDataFactory roleControlLayoutFactory = GridDataFactory.fillDefaults().grab(true, true);
        for (IRole role : roles) {
            Control control = this.createRoleControl(this, role);
            control.setLayoutData((Object)roleControlLayoutFactory.create());
        }
        this.addParticipantsComposite = new ExpandableComposite((Composite)this, SwtUtils.BASE_COMPOSITE_STYLE, 4128);
        this.addParticipantsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(numRoles, 1).grab(true, true).create());
        this.addParticipantsComposite.setClient(this.createAddParticipantsControl((Composite)this.addParticipantsComposite));
        Action addParticipantsAction = new Action("Add Participants...", 2){

            public void run() {
                ParticipantsWidget.this.addParticipantsComposite.setExpanded(this.isChecked());
                SwtUtils.reflowForm((Control)ParticipantsWidget.this.addParticipantsComposite);
            }
        };
        addParticipantsAction.setImageDescriptor(CollaboratorUI.getImageDescriptor("IMG_USER_ADD"));
        addParticipantsAction.setDescription("Add Participants to this Review");
        toolBarManager.add((IAction)addParticipantsAction);
        toolBarManager.update(true);
        reviewSummary.addReviewSummaryListener(this.reviewSummaryListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.removeReviewSummaryListener(ParticipantsWidget.this.reviewSummaryListener);
            }
        });
        reviewSummary.getGeneralInfo().addReviewGeneralInfoListener(this.reviewGeneralInfoListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.getGeneralInfo().removeReviewGeneralInfoListener(ParticipantsWidget.this.reviewGeneralInfoListener);
            }
        });
        reviewSummary.getMovingOn().addMovingOnListener(this.movingOnListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.getMovingOn().removeMovingOnListener(ParticipantsWidget.this.movingOnListener);
            }
        });
        ReviewSummaryAdapter.init((IReviewSummary)reviewSummary, (IReviewSummaryListener)this.reviewSummaryListener);
        ReviewGeneralInfoAdapter.init((IReviewGeneralInfo)reviewSummary.getGeneralInfo(), (IReviewGeneralInfoListener)this.reviewGeneralInfoListener);
        boolean initiallyShowParticipants = false;
        for (IRole role : roles) {
            if (!StringUtils.isNotBlank((String)this.getRoleError(role))) continue;
            initiallyShowParticipants = true;
            break;
        }
        this.addParticipantsComposite.setExpanded(initiallyShowParticipants);
        addParticipantsAction.setChecked(initiallyShowParticipants);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Resource resource : Arrays.asList(ParticipantsWidget.this.italicFont, ParticipantsWidget.this.signedColor, ParticipantsWidget.this.unsignedColor, ParticipantsWidget.this.declinedColor)) {
                    if (resource == null) continue;
                    resource.dispose();
                }
            }
        });
    }

    private Control createRoleControl(Composite parent, final IRole role) {
        Composite roleComposite = new Composite(parent, SwtUtils.BASE_COMPOSITE_STYLE);
        roleComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        TableViewer2<Object, ParticipantRecord> viewer = TableViewer2.create(roleComposite, 34818);
        viewer.getTable().setHeaderVisible(false);
        viewer.getTable().setLinesVisible(false);
        this.roleViewers.put(role, viewer);
        viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        viewer.setLabelProvider(new ParticipantLabelProvider());
        viewer.setContentProvider(CollectionContentProvider.getInstance());
        viewer.addFilter(new ViewerFilter2<ParticipantRecord>(){

            @Override
            public boolean select(Viewer viewer, Object parentElement, ParticipantRecord participant) {
                return participant.role.equals(role);
            }
        });
        viewer.setInput(this.participants);
        LocalDragAdapter.addDragHandler((StructuredViewer)viewer.getInner(), ParticipantRecord.class, 2, new IDragHandler<ParticipantRecord>(){

            @Override
            public void dragFinished(List<ParticipantRecord> elements) {
                ParticipantsWidget.this.changeParticipants(Collections.emptyList(), elements);
            }
        });
        viewer.getInner().addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)viewer.getInner()){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && StringUtils.isBlank((String)ParticipantsWidget.this.reviewSummary.getGeneralInfo().getWhyNotAllowedToModifyParticipants());
            }

            public boolean performDrop(Object data) {
                List<ParticipantRecord> droppedParticipants = SwtUtils.getMultiSelection(LocalSelectionTransfer.getTransfer().getSelection(), ParticipantRecord.class);
                List<IUser> droppedUsers = SwtUtils.getMultiSelection(LocalSelectionTransfer.getTransfer().getSelection(), IUser.class);
                if (droppedParticipants.isEmpty() && droppedUsers.isEmpty()) {
                    return false;
                }
                for (ParticipantRecord participant : droppedParticipants) {
                    IRole participantRole = participant.role;
                    if (participantRole == null || !participantRole.equals(role)) continue;
                    return false;
                }
                ArrayList addedParticipants = Lists.newArrayListWithCapacity((int)(droppedParticipants.size() + droppedUsers.size()));
                for (ParticipantRecord participant : droppedParticipants) {
                    addedParticipants.add(new ParticipantRecord(role, participant.user, participant.pool));
                }
                for (IUser user : droppedUsers) {
                    addedParticipants.add(new ParticipantRecord(role, user, null));
                }
                ParticipantsWidget.this.changeParticipants(addedParticipants, Collections.emptyList());
                return true;
            }
        });
        viewer.setContextMenuProvider(new IActionProvider<ParticipantRecord>(){

            @Override
            public List<IAction> getActions(final List<ParticipantRecord> selectedParticipants) {
                final String whyNot = ParticipantsWidget.this.reviewSummary.getGeneralInfo().getWhyNotAllowedToModifyParticipants();
                if (selectedParticipants.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList roles = ParticipantsWidget.this.reviewSummary.getGeneralInfo().getTemplate().getRoles();
                ArrayList actions = Lists.newArrayListWithCapacity((int)roles.size());
                for (final IRole otherRole : roles) {
                    if (role.equals(otherRole)) continue;
                    actions.add(new Action("Change Role to " + otherRole.getName()){

                        public boolean isEnabled() {
                            return StringUtils.isBlank((String)whyNot);
                        }

                        public void run() {
                            ArrayList newParticipants = Lists.newArrayListWithCapacity((int)selectedParticipants.size());
                            for (ParticipantRecord oldParticipant : selectedParticipants) {
                                newParticipants.add(new ParticipantRecord(otherRole, oldParticipant.user, oldParticipant.pool));
                            }
                            ParticipantsWidget.this.changeParticipants(newParticipants, selectedParticipants);
                        }
                    });
                }
                actions.add(new Action("Remove"){

                    public boolean isEnabled() {
                        return StringUtils.isBlank((String)whyNot);
                    }

                    public void run() {
                        ParticipantsWidget.this.changeParticipants(Collections.emptyList(), selectedParticipants);
                    }
                });
                actions.add(new Action("Poke"){

                    private IReviewParticipant getParticipant() {
                        if (selectedParticipants.size() != 1) {
                            return null;
                        }
                        return ParticipantsWidget.this.findParticipant((PossibleParticipant)((Object)selectedParticipants.get(0)));
                    }

                    public boolean isEnabled() {
                        IReviewParticipant participant = this.getParticipant();
                        return participant != null && StringUtils.isBlank((String)participant.getWhyNotAllowedToPoke());
                    }

                    public void run() {
                        IReviewParticipant participant = this.getParticipant();
                        CommandParticipantPoke cmd = new CommandParticipantPoke();
                        cmd.setParticipant((IUserRef)new UserRefById(participant.getUser().getId()));
                        ParticipantsWidget.this.commandRunner.run((Command)cmd, false);
                        MessageDialog.openInformation((Shell)ParticipantsWidget.this.getShell(), (String)"Poked", (String)("Poked " + participant.getUser().getDisplayName()));
                    }
                });
                actions.add(new Action("Take this Review Pool selection"){

                    private ParticipantRecord getParticipant() {
                        return (ParticipantRecord)((Object)selectedParticipants.get(0));
                    }

                    public boolean isEnabled() {
                        if (selectedParticipants.size() != 1) {
                            return false;
                        }
                        if (ParticipantsWidget.toUsers(ParticipantsWidget.this.participants).contains(ParticipantsWidget.this.clientSystemGlobals.getSelf())) {
                            return false;
                        }
                        return this.getParticipant().user == null;
                    }

                    public void run() {
                        IUser self = ParticipantsWidget.this.clientSystemGlobals.getSelf();
                        ParticipantRecord participant = this.getParticipant();
                        ParticipantRecord record = new ParticipantRecord(participant.role, self, participant.pool);
                        record.isTakenReviewPool = true;
                        ParticipantsWidget.this.changeParticipants(Collections.singletonList(record), selectedParticipants);
                    }
                });
                return actions;
            }
        });
        return roleComposite;
    }

    private Control createAddParticipantsControl(Composite parent) {
        final Composite composite = new Composite(parent, SwtUtils.BASE_COMPOSITE_STYLE);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Composite left = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        left.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite right = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        right.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        left.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.filterLabel = new Label(left, 0);
        this.filterLabel.setText("Filter:");
        this.filterText = new RightSizeText(left, 2052);
        this.filterText.setLayoutData(GridDataFactory.fillDefaults().create());
        this.possibleParticipantsViewer = TableViewer2.create(left, 2820);
        this.possibleParticipantsViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).hint(-1, 10 * this.possibleParticipantsViewer.getControl().getItemHeight()).create());
        this.possibleParticipantsViewer.setContentProvider(CollectionContentProvider.getInstance());
        this.possibleParticipantsViewer.setLabelProvider(new PossibleParticipantLabelProvider());
        this.possibleParticipantsViewer.addFilter(new ViewerFilter2<PossibleParticipant>(){

            @Override
            public boolean select(Viewer viewer, Object parentElement, PossibleParticipant possibleParticipant) {
                for (ParticipantRecord participant : ParticipantsWidget.this.participants) {
                    IUser participantUser = participant.user;
                    IUser participantRecordUser = possibleParticipant.user;
                    if (participantUser == null || participantRecordUser == null || participantUser.getId() != participantRecordUser.getId()) continue;
                    return false;
                }
                return true;
            }
        });
        final ArrayList roles = this.reviewSummary.getGeneralInfo().getTemplate().getRoles();
        final ArrayList addButtons = Lists.newArrayListWithCapacity((int)roles.size());
        Composite addButtonsComposite = new Composite(left, SwtUtils.BASE_COMPOSITE_STYLE);
        addButtonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        addButtonsComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(roles.size()).create());
        for (final IRole role : roles) {
            Button2 addButton = new Button2(addButtonsComposite, 8);
            addButton.setText("Add " + role.getName());
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List possibleParticipants = ParticipantsWidget.this.possibleParticipantsViewer.getSelection();
                    ArrayList addedParticipants = Lists.newArrayListWithCapacity((int)possibleParticipants.size());
                    for (PossibleParticipant possibleParticipant : possibleParticipants) {
                        if (ParticipantsWidget.this.getWhyNotAllowedToAdd(possibleParticipant) != null) continue;
                        ParticipantRecord participantNew = new ParticipantRecord(role, possibleParticipant.user, possibleParticipant.pool);
                        addedParticipants.add(participantNew);
                    }
                    ParticipantsWidget.this.changeParticipants(addedParticipants, Collections.emptyList());
                    ParticipantsWidget.this.possibleParticipantsViewer.refresh(false);
                }
            });
            this.updateAddParticipantButton(addButton);
            addButtons.add(addButton);
        }
        final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (Button2 button : addButtons) {
                    ParticipantsWidget.this.updateAddParticipantButton(button);
                }
            }
        };
        this.possibleParticipantsViewer.getInner().addSelectionChangedListener(selectionChangedListener);
        ReviewGeneralInfoAdapter generalInfoListener = new ReviewGeneralInfoAdapter(){

            public void whyNotAllowedToModifyParticipantsChanged(IReviewGeneralInfo generalInfo, String whyNotAllowedToModifyParticipants) {
                for (Button2 button : addButtons) {
                    ParticipantsWidget.this.updateAddParticipantButton(button);
                }
            }
        };
        this.reviewSummary.getGeneralInfo().addReviewGeneralInfoListener((IReviewGeneralInfoListener)generalInfoListener);
        this.addDisposeListener(new DisposeListener((IReviewGeneralInfoListener)generalInfoListener){
            final /* synthetic */ IReviewGeneralInfoListener val$generalInfoListener;
            {
                this.val$generalInfoListener = iReviewGeneralInfoListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                ParticipantsWidget.this.reviewSummary.getGeneralInfo().removeReviewGeneralInfoListener(this.val$generalInfoListener);
            }
        });
        ViewerFilter2<PossibleParticipant> filter = new ViewerFilter2<PossibleParticipant>(){

            @Override
            public boolean select(Viewer viewer, Object parentElement, PossibleParticipant possibleParticipant) {
                String filter = ParticipantsWidget.this.filterText.getText();
                if (StringUtils.isBlank((String)filter)) {
                    return true;
                }
                Pattern pattern = Pattern.compile(".*(?:^|\\s|\\b)" + Strings.escapeForPattern((String)filter) + ".*", 2);
                return pattern.matcher(possibleParticipant.getDisplayName()).matches();
            }
        };
        this.possibleParticipantsViewer.addFilter(filter);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text textContent = (Text)e.widget;
                if (ParticipantsWidget.this.groupFilter.getSelection()) {
                    ParticipantsWidget.this.initAddParticipants(ParticipantsWidget.this.reviewSummary.getGeneralInfo().getGroup(), textContent.getText());
                } else {
                    ParticipantsWidget.this.initAddParticipants(null, textContent.getText());
                }
                ParticipantsWidget.this.possibleParticipantsViewer.refresh(false);
                if (ParticipantsWidget.this.possibleParticipantsViewer.getControl().getItemCount() == 1) {
                    ParticipantsWidget.this.possibleParticipantsViewer.getControl().select(0);
                    selectionChangedListener.selectionChanged(null);
                }
            }
        });
        LocalDragAdapter.addDragHandler((StructuredViewer)this.possibleParticipantsViewer.getInner(), IUser.class, 2, new IDragHandler<IUser>(){

            @Override
            public void dragFinished(List<IUser> user) {
                ParticipantsWidget.this.possibleParticipantsViewer.refresh(false);
            }
        });
        right.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        GridDataFactory indent = GridDataFactory.swtDefaults().indent(20, 0);
        GridDataFactory newSection = GridDataFactory.swtDefaults().indent(0, 10);
        if (this.reviewSummary.getGeneralInfo().getGroup() != null) {
            this.label = new Label(right, 0);
            this.label.setText("Filter Users:");
            this.groupFilter = new Button(right, 16);
            this.groupFilter.setText("Filter Users by Group '" + SwtUtils.escapeMnemonics(this.reviewSummary.getGeneralInfo().getGroup().getTitle()) + "'");
            this.groupFilter.setLayoutData((Object)indent.create());
            this.groupFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.getSource();
                    if (btn.getSelection()) {
                        ParticipantsWidget.this.initAddParticipants(ParticipantsWidget.this.reviewSummary.getGeneralInfo().getGroup(), null);
                        ParticipantsWidget.this.possibleParticipantsViewer.refresh(false);
                    }
                }
            });
            this.groupFilter.setSelection(true);
            Button noGroupFilter = new Button(right, 16);
            noGroupFilter.setText("Show all Users");
            noGroupFilter.setLayoutData((Object)indent.create());
            noGroupFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.getSource();
                    if (btn.getSelection()) {
                        ParticipantsWidget.this.initAddParticipants(null, null);
                        ParticipantsWidget.this.possibleParticipantsViewer.refresh(false);
                    }
                }
            });
        }
        LinkListViewer2.LinkSelectionListener<ParticipantRecord> addParticipantLinkListener = new LinkListViewer2.LinkSelectionListener<ParticipantRecord>(){

            @Override
            public void selected(ParticipantRecord participant) {
                ArrayList<ParticipantRecord> removes = new ArrayList<ParticipantRecord>();
                for (ParticipantRecord participantRecord : ParticipantsWidget.this.participants) {
                    if (participantRecord.user.getId() != participant.user.getId()) continue;
                    removes.add(participantRecord);
                }
                ParticipantsWidget.this.changeParticipants(Collections.singletonList(participant), removes);
            }
        };
        Label label = new Label(right, 0);
        label.setText("Add Self As:");
        label.setLayoutData((Object)newSection.create());
        this.addSelfViewer = LinkListViewer2.create(right);
        this.addSelfViewer.getControl().setLayoutData((Object)indent.create());
        this.addSelfViewer.setLabelProvider((IBaseLabelProvider2<ParticipantRecord>)new LabelProvider2<ParticipantRecord>(){

            @Override
            public String getText(ParticipantRecord participantRecord) {
                return participantRecord.role.getName();
            }
        });
        this.addSelfViewer.setContentProvider(CollectionContentProvider.getInstance());
        this.addSelfViewer.addLinkSelectionListener(addParticipantLinkListener);
        IUser self = this.clientSystemGlobals.getSelf();
        ArrayList selfParticipants = Lists.newArrayListWithCapacity((int)roles.size());
        for (IRole role : roles) {
            selfParticipants.add(new ParticipantRecord(role, self, null));
        }
        this.addSelfViewer.setInput(selfParticipants);
        label = new Label(right, 0);
        label.setText("Recent Participants:");
        label.setLayoutData((Object)newSection.create());
        this.addRecentViewer = LinkListViewer2.create(right);
        this.addRecentViewer.getControl().setLayoutData((Object)indent.create());
        this.addRecentViewer.setLabelProvider((IBaseLabelProvider2<ParticipantRecord>)new LabelProvider2<ParticipantRecord>(){

            @Override
            public String getText(ParticipantRecord participantRecord) {
                return participantRecord.user.getDisplayName() + " as " + participantRecord.role.getName();
            }
        });
        this.addRecentViewer.setComparator(new ViewerComparator2());
        this.addRecentViewer.setContentProvider((IStructuredContentProvider2<IRecentParticipants, ParticipantRecord>)new StructuredContentProvider2<IRecentParticipants, ParticipantRecord>(){

            @Override
            public Collection<? extends ParticipantRecord> getElements(IRecentParticipants recentParticipants) {
                ArrayList elements = Lists.newArrayListWithCapacity((int)recentParticipants.size());
                for (IRole role : roles) {
                    for (IUser user : recentParticipants.get(role)) {
                        elements.add(new ParticipantRecord(role, user, null));
                    }
                }
                return elements;
            }
        });
        this.addRecentViewer.addLinkSelectionListener(addParticipantLinkListener);
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ParticipantsWidget.this.initAddParticipants(ParticipantsWidget.this.reviewSummary.getGeneralInfo().getGroup(), null);
                composite.removePaintListener((PaintListener)this);
            }
        });
        return composite;
    }

    private void updateAddParticipantButton(Button2 addButton) {
        addButton.setEnabled(!this.possibleParticipantsViewer.getSelection().isEmpty() && StringUtils.isBlank((String)this.reviewSummary.getGeneralInfo().getWhyNotAllowedToModifyParticipants()));
        String disabledToolTip = this.reviewSummary.getGeneralInfo().getWhyNotAllowedToModifyParticipants();
        if (this.possibleParticipantsViewer.getSelection().isEmpty()) {
            disabledToolTip = StringUtils.defaultIfEmpty((String)disabledToolTip, (String)"Select a user to add to this Review");
        }
        addButton.setDisabledToolTipText(StringUtils.defaultIfEmpty((String)disabledToolTip, null));
    }

    private void initAddParticipants(IGroup groupFilter, String filterTextForUserName) {
        Object inGroupSuffix = groupFilter == null ? "" : " in " + this.clientSystemGlobals.getGroupLabelSingular() + " '" + groupFilter.getTitle() + "'";
        ArrayList<Object> possibleParticipants = new ArrayList<Object>();
        DMRecentParticipants recentParticipants = null;
        try {
            IReviewTemplate template = this.reviewSummary.getGeneralInfo().getTemplate();
            DMRecentParticipants theRecentParticipants = null;
            JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
            CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
            ParticipantResponse response = null;
            ParticipantFilterRequest filterRequest = (ParticipantFilterRequest)JsonUtils.create(ParticipantFilterRequest.class);
            if (groupFilter != null) {
                filterRequest.setGuid(groupFilter.getGuid());
            }
            filterRequest.setFilterText(filterTextForUserName);
            response = jsonApi.reviewApi().participantsApi().getFilterParticipants(filterRequest);
            List userInfos = response.getUserInfos();
            if (userInfos.size() > 99) {
                this.label.setText("Filter Users:(You have a lot of users, start typing a name to narrow the list)");
                this.addParticipantsComposite.layout();
            } else {
                this.label.setText("Filter Users:");
                this.addParticipantsComposite.layout();
            }
            ArrayList users = JsonAPIHandler.getDMUsers((List)userInfos);
            for (IUser user : users) {
                PossibleParticipant possibleParticipant = new PossibleParticipant(user, null);
                possibleParticipants.add((Object)possibleParticipant);
            }
            GroupListResponse groupListResponse = response.getGroupListResponse();
            List grouplists = groupListResponse.getGroupList();
            if (grouplists != null) {
                for (GroupDescription group : grouplists) {
                    DMGroup.InitData initData = new DMGroup.InitData(group.getGuid(), group.getTitle(), group.getDescription(), group.isAllowAssociateWithReviews().booleanValue(), group.isReviewPool().booleanValue(), group.isEnabled().booleanValue(), false);
                    DMGroup dmGroup = new DMGroup(initData);
                    PossibleParticipant possibleParticipant = new PossibleParticipant(null, (IGroup)dmGroup);
                    possibleParticipant.setGroupLevel(group.getLevel());
                    possibleParticipants.add((Object)possibleParticipant);
                }
            }
            if (template != null) {
                jsonBatchCommand = new JsonBatchCommand();
                CollaboratorJsonApi jsonApi1 = jsonBatchCommand.getCollaboratorJsonApi();
                RecentParticipantRequest recentParticipantRequest = (RecentParticipantRequest)JsonUtils.create(RecentParticipantRequest.class);
                recentParticipantRequest.setTemplateId(Integer.valueOf(template.getId()));
                if (groupFilter != null) {
                    recentParticipantRequest.setGuid(groupFilter.getGuid());
                }
                RecentParticipantsResponse recentParticipantsResponse = jsonApi1.reviewApi().participantsApi().getRecentParticipants(recentParticipantRequest);
                List jdmModerators = recentParticipantsResponse.getModerators();
                List jdmAuthors = recentParticipantsResponse.getAuthors();
                List jdmReviewers = recentParticipantsResponse.getReviewers();
                List jdmObservers = recentParticipantsResponse.getObservers();
                ArrayList moderators = JsonAPIHandler.getDMUsers((List)jdmModerators);
                ArrayList authors = JsonAPIHandler.getDMUsers((List)jdmAuthors);
                ArrayList reviewers = JsonAPIHandler.getDMUsers((List)jdmReviewers);
                ArrayList observers = JsonAPIHandler.getDMUsers((List)jdmObservers);
                theRecentParticipants = new DMRecentParticipants(moderators, authors, reviewers, observers);
            }
            recentParticipants = theRecentParticipants;
        }
        catch (CollabClientServerConnectivityException e) {
            this.getDisplay().syncExec(new Runnable((String)inGroupSuffix, e){
                final /* synthetic */ String val$inGroupSuffix;
                final /* synthetic */ CollabClientServerConnectivityException val$e;
                {
                    this.val$inGroupSuffix = string;
                    this.val$e = collabClientServerConnectivityException;
                }

                @Override
                public void run() {
                    CollaboratorUI.openError(ParticipantsWidget.this.getShell(), "Error loading possible participants" + this.val$inGroupSuffix, this.val$e, false, false);
                }
            });
        }
        catch (CollabClientException ex) {
            this.getDisplay().syncExec(new Runnable((String)inGroupSuffix, ex){
                final /* synthetic */ String val$inGroupSuffix;
                final /* synthetic */ CollabClientException val$ex;
                {
                    this.val$inGroupSuffix = string;
                    this.val$ex = collabClientException;
                }

                @Override
                public void run() {
                    CollaboratorUI.openError(ParticipantsWidget.this.getShell(), "Error loading possible participants From Json" + this.val$inGroupSuffix, this.val$ex, false, false);
                }
            });
        }
        this.possibleParticipantsViewer.setInput(possibleParticipants);
        this.addRecentViewer.setInput((IRecentParticipants)recentParticipants);
        this.addRecentViewer.getControl().getParent().layout(new Control[]{this.addRecentViewer.getControl()});
    }

    private void changeParticipants(List<ParticipantRecord> add, List<ParticipantRecord> remove) {
        for (ParticipantRecord participantRecord : remove) {
            this.participants.remove((Object)participantRecord);
        }
        for (ParticipantRecord participantRecord : add) {
            this.participants.add(participantRecord);
        }
        for (Map.Entry entry : this.roleLabels.entrySet()) {
            IRole role = (IRole)entry.getKey();
            CLabel label = (CLabel)entry.getValue();
            String errorMessage = this.getRoleError(role);
            boolean error = StringUtils.isNotBlank((String)errorMessage);
            label.setImage(error ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK") : null);
            label.setText(role.getName() + (String)(error ? " - " + errorMessage : ""));
            label.setForeground(error ? this.getDisplay().getSystemColor(3) : null);
        }
        for (StructuredViewer2 structuredViewer2 : this.roleViewers.values()) {
            structuredViewer2.refresh();
        }
        this.addSelfViewer.getControl().setEnabled(!ParticipantsWidget.toUsers(this.participants).contains(this.clientSystemGlobals.getSelf()));
        this.possibleParticipantsViewer.refresh(false);
        this.layout();
        this.saveableListener.dirtyStateMayHaveChanged();
    }

    private String getRoleError(IRole role) {
        int numParticipantsInRole = 0;
        for (ParticipantRecord participantRecord : this.participants) {
            if (!participantRecord.role.equals(role)) continue;
            ++numParticipantsInRole;
        }
        if (numParticipantsInRole < role.getMinimumRequiredInReview()) {
            return "minimum " + (role.getMinimumRequiredInReview() - numParticipantsInRole) + " more required";
        }
        if (numParticipantsInRole > role.getMaximumAllowedInReview()) {
            return "maximum " + role.getMaximumAllowedInReview() + " allowed";
        }
        return null;
    }

    public boolean isDirty() {
        List<ParticipantRecord> currentRecords = ParticipantsWidget.createParticipantRecords(this.reviewSummary);
        if (currentRecords.size() != this.participants.size()) {
            return true;
        }
        for (ParticipantRecord newRecord : this.participants) {
            if (!currentRecords.contains((Object)newRecord)) {
                return true;
            }
            currentRecords.remove((Object)newRecord);
        }
        return false;
    }

    public List<AbstractReviewCommand> getSaveCommands() {
        ArrayList<AbstractReviewCommand> cmds = new ArrayList<AbstractReviewCommand>();
        CommandSetParticipants cmdParticipants = new CommandSetParticipants();
        cmds.add((AbstractReviewCommand)cmdParticipants);
        ArrayList participantRefs = Lists.newArrayListWithCapacity((int)this.participants.size());
        ArrayList poolParticipantRefs = Lists.newArrayListWithCapacity((int)this.participants.size());
        for (ParticipantRecord participant : this.participants) {
            if (participant.user != null && !participant.isTakenReviewPool) {
                participantRefs.add(new ParticipantRefById(participant.role.getSystemName(), participant.user.getId()));
                continue;
            }
            poolParticipantRefs.add(new ReviewPoolParticipantRefBySpec(participant.role.getSystemName(), participant.pool.getGuid()));
            if (!participant.isTakenReviewPool) continue;
            CommandReviewPoolTake cmdTake = new CommandReviewPoolTake();
            cmdTake.setReviewPoolParticipant((IReviewPoolParticipantRef)new ReviewPoolParticipantRefBySpec(participant.role.getSystemName(), participant.pool.getGuid()));
            participant.isTakenReviewPool = false;
            cmds.add((AbstractReviewCommand)cmdTake);
        }
        cmdParticipants.setParticipants(participantRefs.toArray(IParticipantRef.EMPTY_ARRAY));
        cmdParticipants.setPoolParticipants(poolParticipantRefs.toArray(IReviewPoolParticipantRef.EMPTY_ARRAY));
        return cmds;
    }

    private IReviewParticipant findParticipant(PossibleParticipant participantRecord) {
        for (IReviewParticipant participant : this.reviewSummary.getParticipants()) {
            if (!Objects.equal((Object)participant.getUser(), (Object)participantRecord.user) || !Objects.equal((Object)participant.getPoolGroup(), (Object)participantRecord.pool)) continue;
            return participant;
        }
        return null;
    }

    static List<ParticipantRecord> createParticipantRecords(IReviewSummary reviewSummary) {
        return Lists.newArrayList((Iterable)Collections2.transform((Collection)reviewSummary.getParticipants(), (Function)new Function<IReviewParticipant, ParticipantRecord>(){

            public ParticipantRecord apply(IReviewParticipant from) {
                return new ParticipantRecord(from);
            }
        }));
    }

    static List<ParticipantRecord> createPoolParticipantRecords(IReviewSummary reviewSummary) {
        ArrayList<ParticipantRecord> records = new ArrayList<ParticipantRecord>();
        for (IReviewParticipant participant : reviewSummary.getParticipants()) {
            if (participant.getUser() != null) continue;
            records.add(new ParticipantRecord(participant));
        }
        return records;
    }

    private List<ParticipantRecord> getPoolRecords() {
        ArrayList<ParticipantRecord> records = new ArrayList<ParticipantRecord>();
        for (ParticipantRecord participant : this.participants) {
            if (participant.user != null) continue;
            records.add(participant);
        }
        return records;
    }

    private static Set<IUser> toUsers(List<ParticipantRecord> participants) {
        HashSet users = Sets.newHashSetWithExpectedSize((int)participants.size());
        for (ParticipantRecord participant : participants) {
            if (participant.user == null) continue;
            users.add(participant.user);
        }
        return users;
    }

    private ParticipantRecord getRecordForUser(IUser user) {
        for (ParticipantRecord record : this.participants) {
            if (!user.equals(record.user)) continue;
            return record;
        }
        return null;
    }

    private String getWhyNotAllowedToAdd(PossibleParticipant possibleParticipant) {
        if (possibleParticipant.user != null) {
            return null;
        }
        String whyNotAllowedToAddPools = this.reviewSummary.getGeneralInfo().getWhyNotAllowedToAddReviewPoolParticipant();
        if (!StringUtils.isEmpty((String)whyNotAllowedToAddPools)) {
            return whyNotAllowedToAddPools;
        }
        if (this.reviewSummary.getGeneralInfo().getReviewAccess().requiresParticipantAccess()) {
            return "Review Access participant restrictions do not allow Review Pool assignments";
        }
        if (!possibleParticipant.pool.isReviewPool()) {
            return possibleParticipant.pool.getTitle() + " is not a Review Pool";
        }
        return null;
    }

    static final class ParticipantRecord
    extends PossibleParticipant {
        final IRole role;

        public ParticipantRecord(IRole role, IUser user, IGroup pool) {
            super(user, pool);
            this.role = role;
        }

        public ParticipantRecord(IReviewParticipant participant) {
            this(participant.getRole(), (IUser)participant.getUser(), participant.getPoolGroup());
        }
    }

    static class PossibleParticipant
    extends DeepObject {
        final IUser user;
        final IGroup pool;
        boolean isTakenReviewPool = false;
        int level = 0;

        public PossibleParticipant(IUser user, IGroup pool) {
            this.user = user;
            this.pool = pool;
        }

        public PossibleParticipant(IReviewParticipant participant) {
            this((IUser)participant.getUser(), participant.getPoolGroup());
        }

        public String getDisplayName() {
            String displayName = StringUtils.leftPad((String)" ", (int)(5 * this.level));
            if (this.user == null) {
                return displayName + this.pool.getTitle();
            }
            return displayName + this.user.getDisplayName();
        }

        public void setGroupLevel(int level) {
            this.level = level;
        }
    }

    private final class ParticipantLabelProvider
    extends StyledCellLabelProvider2<ParticipantRecord> {
        private ParticipantLabelProvider() {
        }

        @Override
        public void update(ViewerCell cell, ParticipantRecord participantRecord) {
            String imageKey;
            IReviewParticipant participant = ParticipantsWidget.this.findParticipant(participantRecord);
            if (participantRecord.user == null) {
                imageKey = "IMG_REVIEW_POOL";
            } else if (participant == null) {
                imageKey = "IMG_USER_ADD";
            } else {
                switch (participant.getState()) {
                    case NEW: {
                        imageKey = "IMG_USER_NEW";
                        break;
                    }
                    case ACTIVE: {
                        imageKey = "IMG_USER_ACTIVE";
                        break;
                    }
                    case WAITING_FOR_ANY: 
                    case WAITING_FOR_AUTHOR: 
                    case WAITING_FOR_FILES: 
                    case WAITING_FOR_POKE: {
                        imageKey = "IMG_USER_WAITING";
                        break;
                    }
                    case FINISHED_UNTIL_ANY: 
                    case FINISHED_UNTIL_AUTHOR: 
                    case FINISHED_UNTIL_FILES: 
                    case FINISHED_UNTIL_POKE: {
                        imageKey = "IMG_USER_FINISHED";
                        break;
                    }
                    default: {
                        imageKey = "IMG_USER";
                    }
                }
            }
            cell.setImage(CollaboratorUI.getImage(imageKey));
            ArrayList styleRanges = Lists.newArrayListWithCapacity((int)2);
            Object text = participantRecord.user != null ? participantRecord.user.getDisplayName() : participantRecord.pool.getTitle();
            if (participantRecord.user instanceof IContributor) {
                text = (String)text + " (" + ((IContributor)participantRecord.user).getInitials() + ")";
            }
            if (participant != null) {
                StyleRange nameStyle = new StyleRange();
                nameStyle.start = 0;
                nameStyle.length = ((String)text).length();
                switch (participant.getState()) {
                    case WAITING_FOR_ANY: 
                    case WAITING_FOR_AUTHOR: 
                    case WAITING_FOR_FILES: 
                    case WAITING_FOR_POKE: {
                        if (ParticipantsWidget.this.italicFont == null) {
                            ParticipantsWidget.this.italicFont = FontDescriptor.createFrom((Font)((Font)ObjectUtils.defaultIfNull((Object)cell.getFont(), (Object)cell.getControl().getFont()))).withStyle(2).createFont((Device)cell.getControl().getDisplay());
                        }
                        nameStyle.font = ParticipantsWidget.this.italicFont;
                        break;
                    }
                    case FINISHED_UNTIL_ANY: 
                    case FINISHED_UNTIL_AUTHOR: 
                    case FINISHED_UNTIL_FILES: 
                    case FINISHED_UNTIL_POKE: {
                        nameStyle.strikeout = true;
                        break;
                    }
                }
                styleRanges.add(nameStyle);
            }
            if (ParticipantsWidget.this.clientSystemGlobals.isESigsEnabled() && ParticipantsWidget.this.reviewSummary.getMovingOn().getPhase() == Phase.COMPLETED && participant != null && participant.getRole().isRequiredToSign()) {
                SignatureStatus sigStatus = participant.getSignatureStatus();
                String sigText = " (" + sigStatus.getDisplayName() + ")";
                Color sigColor = (Color)sigStatus.accept((SignatureStatus.ISignatureStatusVisitor)new SignatureStatus.ISignatureStatusVisitor<Color>(){

                    private Color lazyInitColor(Color color, int red, int green, int blue) {
                        if (color == null) {
                            color = new Color((Device)ParticipantsWidget.this.getDisplay(), red, green, blue);
                        }
                        return color;
                    }

                    public Color visitUnsigned() {
                        ParticipantsWidget.this.unsignedColor = this.lazyInitColor(ParticipantsWidget.this.unsignedColor, 55, 113, 186);
                        return ParticipantsWidget.this.unsignedColor;
                    }

                    public Color visitDeclined() {
                        ParticipantsWidget.this.declinedColor = this.lazyInitColor(ParticipantsWidget.this.declinedColor, 255, 0, 0);
                        return ParticipantsWidget.this.declinedColor;
                    }

                    public Color visitSigned() {
                        ParticipantsWidget.this.signedColor = this.lazyInitColor(ParticipantsWidget.this.signedColor, 78, 136, 51);
                        return ParticipantsWidget.this.signedColor;
                    }
                });
                StyleRange sigStyle = new StyleRange(((String)text).length(), sigText.length(), sigColor, null);
                text = (String)text + sigText;
                styleRanges.add(sigStyle);
            }
            cell.setText((String)text);
            cell.setStyleRanges(styleRanges.toArray(SwtUtils.EMPTY_STYLE_RANGE_ARRAY));
        }

        @Override
        protected void initialize(ColumnViewer viewer, ViewerColumn column) {
            super.initialize(viewer, column);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        }

        @Override
        public String getToolTipText(ParticipantRecord participantRecord) {
            IReviewParticipant participant = ParticipantsWidget.this.findParticipant(participantRecord);
            if (participant != null) {
                return participant.getState().getDescription(ParticipantsWidget.this.reviewSummary.getMovingOn().getAuthorRoleName());
            }
            return null;
        }

        @Override
        public boolean useNativeToolTip(ParticipantRecord object) {
            return false;
        }
    }

    private final class PossibleParticipantLabelProvider
    extends StyledCellLabelProvider2<PossibleParticipant> {
        private PossibleParticipantLabelProvider() {
        }

        @Override
        public void update(ViewerCell cell, PossibleParticipant possibleParticipant) {
            String imageKey;
            String text = possibleParticipant.getDisplayName();
            cell.setText(text.toString());
            if (ParticipantsWidget.this.getWhyNotAllowedToAdd(possibleParticipant) == null) {
                cell.getControl().setEnabled(true);
            } else {
                cell.getControl().setEnabled(false);
            }
            IReviewParticipant participant = ParticipantsWidget.this.findParticipant(possibleParticipant);
            if (possibleParticipant.user == null) {
                imageKey = "IMG_REVIEW_POOL";
            } else if (participant == null) {
                imageKey = "IMG_USER_ADD";
            } else {
                switch (participant.getState()) {
                    case NEW: {
                        imageKey = "IMG_USER_NEW";
                        break;
                    }
                    case ACTIVE: {
                        imageKey = "IMG_USER_ACTIVE";
                        break;
                    }
                    case WAITING_FOR_ANY: 
                    case WAITING_FOR_AUTHOR: 
                    case WAITING_FOR_FILES: 
                    case WAITING_FOR_POKE: {
                        imageKey = "IMG_USER_WAITING";
                        break;
                    }
                    case FINISHED_UNTIL_ANY: 
                    case FINISHED_UNTIL_AUTHOR: 
                    case FINISHED_UNTIL_FILES: 
                    case FINISHED_UNTIL_POKE: {
                        imageKey = "IMG_USER_FINISHED";
                        break;
                    }
                    default: {
                        imageKey = "IMG_USER";
                    }
                }
            }
            cell.setImage(CollaboratorUI.getImage(imageKey));
            if (participant != null) {
                StyleRange style = new StyleRange();
                style.start = 0;
                style.length = text.length();
                switch (participant.getState()) {
                    case WAITING_FOR_ANY: 
                    case WAITING_FOR_AUTHOR: 
                    case WAITING_FOR_FILES: 
                    case WAITING_FOR_POKE: {
                        if (ParticipantsWidget.this.italicFont == null) {
                            ParticipantsWidget.this.italicFont = FontDescriptor.createFrom((Font)((Font)ObjectUtils.defaultIfNull((Object)cell.getFont(), (Object)cell.getControl().getFont()))).withStyle(2).createFont((Device)cell.getControl().getDisplay());
                        }
                        style.font = ParticipantsWidget.this.italicFont;
                        break;
                    }
                    case FINISHED_UNTIL_ANY: 
                    case FINISHED_UNTIL_AUTHOR: 
                    case FINISHED_UNTIL_FILES: 
                    case FINISHED_UNTIL_POKE: {
                        style.strikeout = true;
                        break;
                    }
                }
                cell.setStyleRanges(new StyleRange[]{style});
            }
        }
    }
}

