/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewEdit;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IReviewChecklist;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.ITemplateChecklist;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummary;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.ReviewSummaryChecklistWidget;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.jface.CollectionContentProvider;
import com.smartbear.jface.ComboViewer2;
import com.smartbear.jface.LabelProvider2;
import com.smartbear.jface.ViewerComparator2;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.Strings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReviewSummaryChecklistSectionWidget
extends Composite {
    final ComboViewer2 listChecklistViewer;
    Map<CTabItem, ReviewSummaryChecklistWidget> tabReviewChecklistMap = new HashMap<CTabItem, ReviewSummaryChecklistWidget>();
    Map<CTabItem, Integer> reviewChecklistMap = new HashMap<CTabItem, Integer>();
    final CTabFolder tabFolder;
    SelectionAdapter tabSelectionListener = null;
    private boolean refresh = false;

    public ReviewSummaryChecklistSectionWidget(Composite parent, int style, final IClientSystemGlobals clientSystemGlobals, IReviewSummary reviewSummary, final ISaveableListener saveableListener, final IStyledTextDecorator userTextDecorator) {
        super(parent, style);
        final int reviewId = reviewSummary.getId();
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Composite left = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        left.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite right = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        right.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        left.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Label checklistLabel = new Label(left, 0);
        checklistLabel.setText("Checklist:");
        Combo combo = new Combo(left, 4);
        combo.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.listChecklistViewer = ComboViewer2.create(combo);
        this.listChecklistViewer.setComparator(new ViewerComparator2());
        combo.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 1).grab(true, true).hint(5 * combo.getBorderWidth(), -1).create());
        this.fillChecklistItemViewer(reviewSummary, saveableListener);
        right.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Button addChecklist = new Button(right, 8);
        addChecklist.setText("Add Checklist");
        addChecklist.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        List reviewChecklistList = reviewSummary.getReviewChecklists();
        this.tabFolder = new CTabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        for (IReviewChecklist iReviewChecklist : reviewChecklistList) {
            this.createChecklistItem(this.tabFolder, clientSystemGlobals, reviewSummary, iReviewChecklist, saveableListener, userTextDecorator);
        }
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                boolean shouldCloseChecklist;
                if (ReviewSummaryChecklistSectionWidget.this.reviewChecklistMap.size() > 1 && (shouldCloseChecklist = MessageDialog.openQuestion((Shell)ReviewSummaryChecklistSectionWidget.this.getShell(), (String)"Confirm Remove this checklist", (String)"Please confirm that you would like to remove the checklist from this review."))) {
                    CTabItem tabItem = (CTabItem)event.item;
                    int checklistId = ReviewSummaryChecklistSectionWidget.this.reviewChecklistMap.get(tabItem);
                    ReviewSummaryChecklistSectionWidget.this.reviewChecklistMap.remove(tabItem);
                    ReviewSummaryChecklistSectionWidget.this.updateChecklist(reviewId, checklistId, false, clientSystemGlobals, saveableListener, userTextDecorator);
                    return;
                }
                event.doit = false;
            }
        });
        this.addSelectionListenerToTabFolder(reviewId);
        addChecklist.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List templateChecklists = ReviewSummaryChecklistSectionWidget.this.listChecklistViewer.getSelection();
                if (templateChecklists != null && templateChecklists.size() > 0) {
                    boolean shouldAddChecklist = MessageDialog.openQuestion((Shell)ReviewSummaryChecklistSectionWidget.this.getShell(), (String)"Confirm Add this checklist", (String)"Please confirm that you would like to add the checklist to this review.");
                    if (shouldAddChecklist) {
                        Integer checklistId = ((ITemplateChecklist)templateChecklists.get(0)).getId();
                        ReviewSummaryChecklistSectionWidget.this.updateChecklist(reviewId, checklistId, true, clientSystemGlobals, saveableListener, userTextDecorator);
                        ReviewSummaryChecklistSectionWidget.this.refresh = true;
                    } else {
                        event.doit = false;
                    }
                } else {
                    MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)"No any checklist in the list.", (String)"Operation canceled."));
                }
            }
        });
    }

    private void updateChecklist(int reviewId, int checklistId, boolean doesAddChecklist, IClientSystemGlobals clientSystemGlobals, ISaveableListener saveableListener, IStyledTextDecorator userTextDecorator) {
        try {
            if (doesAddChecklist) {
                JsonAPIHandler.addReviewChecklist((int)reviewId, (Integer)checklistId);
            } else {
                JsonAPIHandler.removeReviewChecklist((int)reviewId, (Integer)checklistId);
            }
            DMReviewSummary updatedReviewSummary = JsonAPIHandler.getReviewSummary((int)reviewId);
            this.fillChecklistItemViewer((IReviewSummary)updatedReviewSummary, saveableListener);
            if (doesAddChecklist) {
                List updatedReviewChecklistList = updatedReviewSummary.getReviewChecklists();
                for (IReviewChecklist updatedReviewChecklist : updatedReviewChecklistList) {
                    if (this.reviewChecklistMap.values().contains(updatedReviewChecklist.getId())) continue;
                    this.createChecklistItem(this.tabFolder, clientSystemGlobals, (IReviewSummary)updatedReviewSummary, updatedReviewChecklist, saveableListener, userTextDecorator);
                    break;
                }
                this.addSelectionListenerToTabFolder(reviewId);
            }
        }
        catch (CollabClientException e) {
            ClosureReturn error = new ClosureReturn();
            error.set((Object)e);
            String errorMessage = e.getMessage();
            int beginIndex = "JSON API Error: ".length();
            int endIndex = errorMessage.length() - "(Code: InternalError )".length();
            errorMessage = errorMessage.substring(beginIndex, endIndex);
            MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)errorMessage, (String)"Operation canceled."));
            return;
        }
        catch (ParseException e) {
            ClosureReturn error = new ClosureReturn();
            error.set((Object)e);
            return;
        }
    }

    private void addSelectionListenerToTabFolder(final int reviewId) {
        this.tabFolder.setSelection(0);
        if (this.tabSelectionListener != null) {
            this.tabFolder.removeSelectionListener((SelectionListener)this.tabSelectionListener);
        }
        this.tabSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReviewSummaryChecklistWidget reviewSummaryChecklistWidget = ReviewSummaryChecklistSectionWidget.this.tabReviewChecklistMap.get(ReviewSummaryChecklistSectionWidget.this.tabFolder.getSelection());
                ArrayList<Command> commands = new ArrayList<Command>();
                Command cmd = reviewSummaryChecklistWidget.getSaveCommand();
                if (cmd instanceof CommandReviewEdit) {
                    ((CommandReviewEdit)cmd).setReview(Integer.toString(reviewId));
                    commands.add(cmd);
                    CollaboratorUI.executeServerCommands(commands, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        this.tabFolder.addSelectionListener((SelectionListener)this.tabSelectionListener);
    }

    private void createChecklistItem(CTabFolder tabFolder, IClientSystemGlobals clientSystemGlobals, IReviewSummary reviewSummary, IReviewChecklist iReviewChecklist, ISaveableListener saveableListener, IStyledTextDecorator userTextDecorator) {
        CTabItem tab = new CTabItem(tabFolder, 64);
        tab.setText(iReviewChecklist.getTitle());
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        ReviewSummaryChecklistWidget checklistWidget = new ReviewSummaryChecklistWidget(tabComposite, SwtUtils.BASE_COMPOSITE_STYLE, clientSystemGlobals, reviewSummary, iReviewChecklist, saveableListener, userTextDecorator);
        tab.setControl((Control)tabComposite);
        ReviewSummaryChecklistWidget reviewSummaryChecklistWidget = checklistWidget;
        this.tabReviewChecklistMap.put(tab, reviewSummaryChecklistWidget);
        this.reviewChecklistMap.put(tab, iReviewChecklist.getId());
        reviewSummaryChecklistWidget.refreshTabble();
    }

    public boolean isDirty() {
        for (ReviewSummaryChecklistWidget reviewSummaryChecklistWidget : this.tabReviewChecklistMap.values()) {
            if (!reviewSummaryChecklistWidget.isDirty()) continue;
            return true;
        }
        if (this.refresh) {
            this.refresh = false;
            return true;
        }
        return false;
    }

    public List<Command> getSaveCommand() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        for (ReviewSummaryChecklistWidget reviewSummaryChecklistWidget : this.tabReviewChecklistMap.values()) {
            Command command = reviewSummaryChecklistWidget.getSaveCommand();
            cmds.add(command);
        }
        return cmds;
    }

    private void fillChecklistItemViewer(IReviewSummary reviewSummary, final ISaveableListener saveableListener) {
        this.listChecklistViewer.setContentProvider(CollectionContentProvider.getInstance());
        this.listChecklistViewer.setLabelProvider(new LabelProvider2<ITemplateChecklist>(){

            @Override
            public String getText(ITemplateChecklist iTemplateChecklist) {
                return iTemplateChecklist.getTitle();
            }
        });
        List templateChecklistLists = reviewSummary.getTemplateChecklists();
        this.listChecklistViewer.setInput(templateChecklistLists);
        this.listChecklistViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                saveableListener.dirtyStateMayHaveChanged();
            }
        });
    }
}

