/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.CommandNoop;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewEdit;
import com.smartbear.ccollab.datamodel.client.IChecklistItem;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.ICustomFieldTarget;
import com.smartbear.ccollab.datamodel.client.IReviewChecklist;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IUser;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.listener.IChecklistItemListener;
import com.smartbear.ccollab.datamodel.client.listener.ICustomFieldListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ChecklistItemAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.CustomFieldAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.CustomFieldTargetWidget;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.jface.ColumnLabelProvider2;
import com.smartbear.jface.ISelectionChangedListener2;
import com.smartbear.jface.LabelProviderChangedEvent2;
import com.smartbear.jface.StructuredContentProvider2;
import com.smartbear.jface.TableViewer2;
import com.smartbear.jface.TableViewerColumn2;
import com.smartbear.swt.TableWrapData2;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.SmartBearUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ReviewSummaryChecklistWidget
extends CustomFieldTargetWidget {
    private static final String COLUMN_VISIBLE_KEY = ReviewSummaryChecklistWidget.class.getName() + ".columnVisible";
    private static final String CUSTOM_FIELD_KEY = ReviewSummaryChecklistWidget.class.getName() + ".customField";
    private final double COLUMN_WIDTH_RATIO = 0.075;
    private final int COLUMN_MINIMAL_WIDTH;
    private final int TABLE_WIDTH_TOLAL_PERCENT = 100;
    private final IReviewMovingOnListener phaseVisibilityListener;
    private IChecklistItem selectedChecklistItem;
    private final TableViewer2<IReviewChecklist, IChecklistItem> tableViewer;
    private static final String STATUS = "Status";
    private static final String USER = "User";
    private static final String TITLE = "Title";
    private static final String DATE = "Date";
    private static final String CHECKBUTTON = "CheckButton";
    private static final String NON_AVAILABLE = "-";
    private static final int STATUS_COLUMN_INDEX = 0;
    private static final int TITLE_COLUMN_INDEX = 1;
    private static final int CREATOR_COLUMN_INDEX = 2;
    private static final int DATE_COLUMN_INDEX = 3;
    private IUser self;
    IReviewChecklist reviewChecklist;

    public ReviewSummaryChecklistWidget(Composite parent, int style, IClientSystemGlobals clientSystemGlobals, final IReviewSummary reviewSummary, IReviewChecklist reviewChecklist, ISaveableListener saveableListener, IStyledTextDecorator userTextDecorator) {
        super(parent, style, reviewSummary, saveableListener);
        this.COLUMN_MINIMAL_WIDTH = (int)((double)this.getShell().getBounds().width * 0.075);
        this.TABLE_WIDTH_TOLAL_PERCENT = 100;
        this.phaseVisibilityListener = new ReviewMovingOnAdapter(){

            public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
                TableLayout tableLayout = new TableLayout();
                boolean visibilityChanged = false;
                for (TableColumn column : ReviewSummaryChecklistWidget.this.tableViewer.getControl().getColumns()) {
                    boolean columnVisible = Boolean.TRUE.equals(column.getData(COLUMN_VISIBLE_KEY));
                    ICustomField customField = (ICustomField)column.getData(CUSTOM_FIELD_KEY);
                    if (customField != null && columnVisible != customField.getVisiblePhases().contains(phase)) {
                        visibilityChanged = true;
                    }
                    if (ReviewSummaryChecklistWidget.STATUS.equalsIgnoreCase(column.getText()) || ReviewSummaryChecklistWidget.TITLE.equalsIgnoreCase(column.getText()) || ReviewSummaryChecklistWidget.USER.equalsIgnoreCase(column.getText()) || ReviewSummaryChecklistWidget.DATE.equalsIgnoreCase(column.getText())) {
                        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(0));
                        continue;
                    }
                    if (customField.getVisiblePhases().contains(phase)) {
                        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(0));
                    } else {
                        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(0, false, false));
                    }
                    column.setData(COLUMN_VISIBLE_KEY, (Object)customField.getVisiblePhases().contains(phase));
                }
                if (visibilityChanged) {
                    ReviewSummaryChecklistWidget.this.tableViewer.getControl().setLayout((Layout)tableLayout);
                    ReviewSummaryChecklistWidget.this.tableViewer.getControl().layout();
                }
            }
        };
        this.self = clientSystemGlobals.getSelf();
        List customFields = reviewChecklist != null ? reviewChecklist.getChecklistCustomFields() : Collections.EMPTY_LIST;
        TableWrapData2 layoutData = new TableWrapData2(256, 256, 1, 4);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite tablePlaceholder = new Composite((Composite)this, 0);
        tablePlaceholder.setLayoutData((Object)layoutData);
        tablePlaceholder.setLayout((Layout)tableColumnLayout);
        this.tableViewer = TableViewer2.create(tablePlaceholder, 68354);
        this.tableViewer.getControl().setHeaderVisible(true);
        this.tableViewer.getControl().setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 70;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        ColumnToolTip.enableFor((ColumnViewer)this.tableViewer.getInner(), 2);
        this.addTableViewerColumns(this.tableViewer, customFields, tableColumnLayout);
        reviewSummary.getMovingOn().addMovingOnListener(this.phaseVisibilityListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.getMovingOn().removeMovingOnListener(ReviewSummaryChecklistWidget.this.phaseVisibilityListener);
            }
        });
        ReviewMovingOnAdapter.init((IReviewMovingOn)reviewSummary.getMovingOn(), (IReviewMovingOnListener)this.phaseVisibilityListener);
        this.tableViewer.setContentProvider(new ChecklistContentProvider());
        this.tableViewer.setInput(reviewChecklist);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener2<IChecklistItem>(){

            @Override
            public void selectionChanged(List<IChecklistItem> selection) {
                IChecklistItem checklistItem;
                ReviewSummaryChecklistWidget.this.selectedChecklistItem = checklistItem = (IChecklistItem)SmartBearUtils.getFirstObject(selection);
                ReviewSummaryChecklistWidget.this.setTarget((ICustomFieldTarget)checklistItem);
            }
        });
        TableItem[] items = this.tableViewer.getTable().getItems();
        if (items.length > 0) {
            IChecklistItem checklistItem = (IChecklistItem)items[0].getData();
            this.tableViewer.getTable().setSelection(0);
            this.selectedChecklistItem = checklistItem;
            this.setTarget((ICustomFieldTarget)checklistItem);
        }
        this.addCustomFieldControls(customFields, userTextDecorator);
    }

    public void refreshTabble() {
        this.tableViewer.refresh();
    }

    private void addTableViewerColumns(TableViewer2 tableViewer, List<? extends ICustomField> customFields, TableColumnLayout tableColumnLayout) {
        TableViewerColumn2<IChecklistItem> statusColumn = TableViewerColumn2.create(tableViewer);
        ((TableColumn)statusColumn.getColumn()).setText(STATUS);
        ((TableColumn)statusColumn.getColumn()).setToolTipText("Status of Checklist");
        statusColumn.setLabelProvider(new ChecklistColumnLabelProvider(STATUS, tableViewer));
        TableViewerColumn2<IChecklistItem> tableViewerColumn2 = TableViewerColumn2.create(tableViewer);
        ((TableColumn)tableViewerColumn2.getColumn()).setText(TITLE);
        ((TableColumn)tableViewerColumn2.getColumn()).setToolTipText("Title of Checklist");
        tableViewerColumn2.setLabelProvider(new ChecklistColumnLabelProvider(TITLE, tableViewer));
        tableViewerColumn2.setEditingSupport(new CheckLengthEditingSupport(tableViewer.getInner()));
        TableViewerColumn2<IChecklistItem> userColumn = TableViewerColumn2.create(tableViewer);
        ((TableColumn)userColumn.getColumn()).setText(USER);
        ((TableColumn)userColumn.getColumn()).setToolTipText("User of Checklist");
        userColumn.setLabelProvider(new ChecklistColumnLabelProvider(USER, tableViewer));
        TableViewerColumn2<IChecklistItem> dateColumn = TableViewerColumn2.create(tableViewer);
        ((TableColumn)dateColumn.getColumn()).setText(DATE);
        ((TableColumn)dateColumn.getColumn()).setToolTipText("Date of Checklist");
        dateColumn.setLabelProvider(new ChecklistColumnLabelProvider(DATE, tableViewer));
        for (ICustomField iCustomField : customFields) {
            TableViewerColumn2<ICustomFieldTarget> fieldColumn = TableViewerColumn2.create(tableViewer);
            ((TableColumn)fieldColumn.getColumn()).setText(iCustomField.getTitle());
            ((TableColumn)fieldColumn.getColumn()).setToolTipText(iCustomField.getDescription());
            ((TableColumn)fieldColumn.getColumn()).setData(CUSTOM_FIELD_KEY, (Object)iCustomField);
            fieldColumn.setLabelProvider(new CustomFieldColumnLabelProvider(iCustomField));
        }
        TableColumn[] columns = tableViewer.getTable().getColumns();
        int n = columns.length != 0 ? 100 / columns.length : 1;
        for (TableColumn tableColumn : columns) {
            tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(n, this.COLUMN_MINIMAL_WIDTH, true));
        }
    }

    public boolean isDirty() {
        return this.isCustomFieldsDirty();
    }

    public Command getSaveCommand() {
        if (this.isDirty()) {
            CommandReviewEdit cmd = new CommandReviewEdit();
            cmd.setChecklistItemCustomFields(this.getCustomFieldValueRefs((ICustomFieldTarget)this.selectedChecklistItem));
            return cmd;
        }
        return CommandNoop.INSTANCE;
    }

    private final class ChecklistColumnLabelProvider
    extends ColumnLabelProvider2<IChecklistItem> {
        private final IChecklistItemListener listener = new ChecklistItemAdapter(){

            public void checklistItemStatusChanged(IChecklistItem iChecklistItem, boolean newStatus, IUser newUser, Date newTimestamp) {
                ChecklistColumnLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent2<IChecklistItem>(ChecklistColumnLabelProvider.this, iChecklistItem));
                ChecklistColumnLabelProvider.this.tableViewer.update(iChecklistItem, null);
                ChecklistColumnLabelProvider.this.tableViewer.refresh();
            }
        };
        private String columnName;
        private TableViewer2 tableViewer;
        private Map<Object, Button> buttons = new HashMap<Object, Button>();

        private ChecklistColumnLabelProvider(String columnName, TableViewer2 tableViewer) {
            this.columnName = columnName;
            this.tableViewer = tableViewer;
        }

        @Override
        public void update(ViewerCell cell, final IChecklistItem iChecklistItem) {
            final TableItem item = (TableItem)cell.getItem();
            iChecklistItem.addChecklistItemListener(this.listener);
            cell.getItem().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    iChecklistItem.removeChecklistItemListener(ChecklistColumnLabelProvider.this.listener);
                }
            });
            if (ReviewSummaryChecklistWidget.STATUS.equalsIgnoreCase(this.columnName)) {
                Button buttonCheckBox = (Button)item.getData(ReviewSummaryChecklistWidget.CHECKBUTTON);
                if (buttonCheckBox == null || buttonCheckBox.isDisposed()) {
                    buttonCheckBox = new Button((Composite)cell.getViewerRow().getControl(), 32);
                    buttonCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            try {
                                Button btn = (Button)event.getSource();
                                String displayName = ReviewSummaryChecklistWidget.NON_AVAILABLE;
                                String dateUpdatedString = ReviewSummaryChecklistWidget.NON_AVAILABLE;
                                if (btn.getSelection()) {
                                    if (ReviewSummaryChecklistWidget.this.self != null) {
                                        displayName = ReviewSummaryChecklistWidget.this.self.getDisplayName();
                                    }
                                    dateUpdatedString = new Date().toString();
                                }
                                item.setText(2, displayName);
                                item.setText(3, dateUpdatedString);
                                JsonAPIHandler.setChecklistItemStatus((int)iChecklistItem.getReviewSummary().getId(), (Integer)iChecklistItem.getId(), (boolean)btn.getSelection());
                            }
                            catch (CollabClientException e) {
                                ClosureReturn error = new ClosureReturn();
                                error.set((Object)e);
                                return;
                            }
                        }
                    });
                    TableEditor editor = new TableEditor(item.getParent());
                    editor.grabHorizontal = true;
                    editor.setEditor((Control)buttonCheckBox, item, cell.getColumnIndex());
                    editor.layout();
                    item.setData(ReviewSummaryChecklistWidget.CHECKBUTTON, (Object)buttonCheckBox);
                }
                buttonCheckBox.setSelection(iChecklistItem.getStatus());
            } else if (ReviewSummaryChecklistWidget.USER.equalsIgnoreCase(this.columnName)) {
                if (iChecklistItem.getStatus() && iChecklistItem.getUser() != null) {
                    cell.setText(iChecklistItem.getUser().getDisplayName());
                } else {
                    cell.setText(ReviewSummaryChecklistWidget.NON_AVAILABLE);
                }
            } else if (ReviewSummaryChecklistWidget.TITLE.equalsIgnoreCase(this.columnName)) {
                cell.setText(iChecklistItem.getName());
            } else {
                Date dateCreated = iChecklistItem.getTimestamp();
                if (dateCreated == null || !iChecklistItem.getStatus()) {
                    cell.setText(ReviewSummaryChecklistWidget.NON_AVAILABLE);
                } else {
                    cell.setText(dateCreated.toString());
                }
            }
        }

        @Override
        public String getToolTipText(IChecklistItem iChecklistItem) {
            String toolTipText = "";
            switch (this.columnName) {
                case "Title": {
                    toolTipText = iChecklistItem.getName();
                    break;
                }
                case "User": {
                    if (!iChecklistItem.getStatus() || iChecklistItem.getUser() == null) break;
                    toolTipText = iChecklistItem.getUser().getDisplayName();
                    break;
                }
                case "Date": {
                    Date dateCreated = iChecklistItem.getTimestamp();
                    if (dateCreated == null || !iChecklistItem.getStatus()) break;
                    toolTipText = dateCreated.toString();
                    break;
                }
                default: {
                    return "";
                }
            }
            return toolTipText;
        }
    }

    private static final class CustomFieldColumnLabelProvider
    extends ColumnLabelProvider2<ICustomFieldTarget> {
        private final ICustomFieldListener listener = new CustomFieldAdapter(){

            public void customFieldChanged(ICustomFieldTarget target, ICustomField customField, HashSet<String> newValue) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent2<ICustomFieldTarget>(this, target));
            }
        };
        private final ICustomField field;

        private CustomFieldColumnLabelProvider(ICustomField field) {
            this.field = field;
        }

        @Override
        public void update(ViewerCell cell, final ICustomFieldTarget target) {
            super.update(cell, target);
            target.addCustomFieldListener(this.field, this.listener);
            cell.getItem().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    target.removeCustomFieldListener(field, listener);
                }
            });
        }

        @Override
        public String getText(ICustomFieldTarget target) {
            return StringUtils.join((Collection)target.getCustomFieldValue(this.field), (String)", ").replaceAll("\n", " ");
        }

        @Override
        public String getToolTipText(ICustomFieldTarget target) {
            return StringUtils.join((Collection)target.getCustomFieldValue(this.field), (String)"\n");
        }
    }

    private static final class ChecklistContentProvider
    extends StructuredContentProvider2<IReviewChecklist, IChecklistItem> {
        final IChecklistItemListener checklistItemListener = new ChecklistItemAdapter(){

            public void checklistItemStatusChanged(IChecklistItem item, boolean newStatus, IUser newUser, Date newTimestamp) {
                this.getViewer().update(item, null);
                this.getViewer().refresh();
            }
        };

        private ChecklistContentProvider() {
        }

        @Override
        public List<? extends IChecklistItem> getElements(IReviewChecklist inputElement) {
            return inputElement != null ? inputElement.getChecklistItems() : Collections.EMPTY_LIST;
        }
    }

    static class CheckLengthEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private TextCellEditor editor = null;

        public CheckLengthEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.editor = new TextCellEditor((Composite)viewer.getTable());
            Text text = (Text)this.editor.getControl();
            text.setTextLimit(1024);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((IChecklistItem)element).getName();
        }

        protected void setValue(Object element, Object value) {
        }
    }

    private static class ColumnToolTip
    extends ColumnViewerToolTipSupport {
        public static void enableFor(ColumnViewer viewer, int style) {
            new ColumnToolTip(viewer, style, false);
        }

        private ColumnToolTip(ColumnViewer viewer, int style, boolean manualActivation) {
            super(viewer, style, manualActivation);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            String value = this.getText(event);
            int length = value.length();
            double ratio = 0.3 * (double)length;
            int size = Math.max((int)ratio, 100);
            scrolledComposite.setMinSize(size, size);
            Text text = new Text((Composite)scrolledComposite, 17218);
            text.setText(value);
            text.setSize(size, size);
            return scrolledComposite;
        }
    }
}

