/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.smartbear.ccollab.datamodel.client.DefectState;
import com.smartbear.ccollab.datamodel.client.IContributor;
import com.smartbear.ccollab.datamodel.client.ICustomField;
import com.smartbear.ccollab.datamodel.client.ICustomFieldTarget;
import com.smartbear.ccollab.datamodel.client.IDefect;
import com.smartbear.ccollab.datamodel.client.IDefectLogEntry;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.impl.DMUser;
import com.smartbear.ccollab.datamodel.client.listener.ICustomFieldListener;
import com.smartbear.ccollab.datamodel.client.listener.IDefectListener;
import com.smartbear.ccollab.datamodel.client.listener.IDefectLogEntryListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.BaseTableViewerWidget;
import com.smartbear.collaborator.ui.review.DefectWidget;
import com.smartbear.collaborator.ui.util.CommandOpenListener;
import com.smartbear.jface.IStructuredContentProvider2;
import com.smartbear.jface.StructuredContentProvider2;
import com.smartbear.jface.ViewerComparator2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;

public class ReviewSummaryDefectLogWidget
extends BaseTableViewerWidget<IReviewSummary, IDefectLogEntry> {
    private final Map<IDefectLogEntry, DefectMultiListener> defectListeners = new HashMap<IDefectLogEntry, DefectMultiListener>();
    private final IReviewSummaryListener listener = new ReviewSummaryAdapter(){

        public void defectLogAdded(IReviewSummary reviewSummary, ArrayList<? extends IDefectLogEntry> addedDefectLog) {
            for (IDefectLogEntry iDefectLogEntry : addedDefectLog) {
                ReviewSummaryDefectLogWidget.this.hookListeners(iDefectLogEntry);
            }
            this.defectLogChanged();
        }

        public void defectLogDeleted(IReviewSummary reviewSummary, ArrayList<? extends IDefectLogEntry> deletedDefectLog) {
            for (IDefectLogEntry iDefectLogEntry : deletedDefectLog) {
                ReviewSummaryDefectLogWidget.this.unhookListeners(iDefectLogEntry);
            }
            this.defectLogChanged();
        }

        private void defectLogChanged() {
            ReviewSummaryDefectLogWidget.this.tableViewer.refresh(false);
        }
    };

    public ReviewSummaryDefectLogWidget(Composite parent, int style, final IReviewSummary reviewSummary, IServiceLocator serviceLocator, IWorkbenchSite site) {
        super(parent, style, reviewSummary, site);
        reviewSummary.addReviewSummaryListener(this.listener);
        for (IDefectLogEntry defectLogEntry : reviewSummary.getDefectLog()) {
            this.hookListeners(defectLogEntry);
        }
        this.tableViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                reviewSummary.removeReviewSummaryListener(ReviewSummaryDefectLogWidget.this.listener);
                for (IDefectLogEntry defectLogEntry : reviewSummary.getDefectLog()) {
                    ReviewSummaryDefectLogWidget.this.unhookListeners(defectLogEntry);
                }
            }
        });
        this.tableViewer.setComparator(new ViewerComparator2<IDefectLogEntry>(){

            @Override
            public int compare(Viewer viewer, IDefectLogEntry o1, IDefectLogEntry o2) {
                Date date1 = o1.getDefect().getCreationDate();
                Date date2 = o2.getDefect().getCreationDate();
                return date1.compareTo(date2);
            }
        });
        this.tableViewer.addOpenListener(new CommandOpenListener<IDefectLogEntry>(serviceLocator, "com.smartbear.collaborator.ui.commands.OpenReviewFile"){

            @Override
            public void open(List<IDefectLogEntry> elements) {
                if (!(elements = Lists.newArrayList((Iterable)Iterables.filter(elements, (Predicate)new Predicate<IDefectLogEntry>(){

                    public boolean apply(IDefectLogEntry defectLogEntry) {
                        return defectLogEntry.getFilePath() != null;
                    }
                }))).isEmpty()) {
                    super.open(elements);
                }
            }
        });
    }

    private void hookListeners(IDefectLogEntry defectLogEntry) {
        DefectMultiListener listener = new DefectMultiListener(defectLogEntry);
        defectLogEntry.addDefectLogEntryListener((IDefectLogEntryListener)listener);
        IDefect defect = defectLogEntry.getDefect();
        defect.addDefectListener((IDefectListener)listener);
        for (ICustomField customField : ((IReviewSummary)this.input).getDefectCustomFields()) {
            defect.addCustomFieldListener(customField, (ICustomFieldListener)listener);
        }
        this.defectListeners.put(defectLogEntry, listener);
    }

    private void unhookListeners(IDefectLogEntry defectLogEntry) {
        DefectMultiListener listener = this.defectListeners.get(defectLogEntry);
        if (listener == null) {
            CollaboratorUI.log("Could not find listener for defect log entry " + defectLogEntry.getDefect().getId(), null);
            return;
        }
        defectLogEntry.removeDefectLogEntryListener((IDefectLogEntryListener)listener);
        IDefect defect = defectLogEntry.getDefect();
        defect.removeDefectListener((IDefectListener)listener);
        for (ICustomField customField : ((IReviewSummary)this.input).getDefectCustomFields()) {
            defect.removeCustomFieldListener(customField, (ICustomFieldListener)listener);
        }
        this.defectListeners.remove(defectLogEntry);
    }

    @Override
    protected IStructuredContentProvider2<IReviewSummary, IDefectLogEntry> createContentProvider() {
        return new StructuredContentProvider2<IReviewSummary, IDefectLogEntry>(){

            @Override
            public List<? extends IDefectLogEntry> getElements(IReviewSummary inputElement) {
                return inputElement.getDefectLog();
            }
        };
    }

    @Override
    protected Iterable<? extends BaseTableViewerWidget.Column> createColumns() {
        int i = 0;
        this.columnByIndex.put(i++, this.createStatusColumn());
        this.columnByIndex.put(i++, this.createIdColumn());
        this.columnByIndex.put(i++, this.createCreatorColumn());
        for (ICustomField customField : ((IReviewSummary)this.input).getDefectCustomFields()) {
            this.columnByIndex.put(i++, this.createCustomFieldColumn(customField));
        }
        this.columnByIndex.put(i++, this.createDescriptionColumn());
        this.columnByIndex.put(i++, this.createFileColumn());
        this.columnByIndex.put(i++, this.createLocationColumn());
        return this.columnByIndex.values();
    }

    private BaseTableViewerWidget.Column createLocationColumn() {
        return new BaseTableViewerWidget.Column(){

            @Override
            protected String getLabel() {
                return "Location";
            }

            protected String getFullText(IDefectLogEntry d) {
                return d.getLocator().toString();
            }

            @Override
            protected int getWeight() {
                return 10;
            }
        };
    }

    private BaseTableViewerWidget.Column createFileColumn() {
        return new BaseTableViewerWidget.Column(){

            @Override
            protected String getLabel() {
                return "File";
            }

            protected String getSingleLineText(IDefectLogEntry d) {
                return FilenameUtils.getName((String)this.getFullText(d));
            }

            protected String getFullText(IDefectLogEntry d) {
                return StringUtils.defaultString((String)d.getFilePath());
            }

            @Override
            protected int getWeight() {
                return 20;
            }
        };
    }

    private BaseTableViewerWidget.Column createDescriptionColumn() {
        return new BaseTableViewerWidget.Column(){

            @Override
            protected String getLabel() {
                return "Description";
            }

            protected String getFullText(IDefectLogEntry d) {
                return d.getDefect().getText();
            }

            @Override
            protected int getWeight() {
                return 30;
            }
        };
    }

    private BaseTableViewerWidget.Column createCustomFieldColumn(final ICustomField customField) {
        return new BaseTableViewerWidget.Column(){

            @Override
            protected String getLabel() {
                return customField.getTitle();
            }

            protected String getSingleLineText(IDefectLogEntry d) {
                return StringUtils.join((Collection)d.getDefect().getCustomFieldValue(customField), (String)", ").replaceAll("\n", " ");
            }

            protected String getFullText(IDefectLogEntry d) {
                return StringUtils.join((Collection)d.getDefect().getCustomFieldValue(customField), (String)"\n");
            }

            @Override
            protected int getWeight() {
                return 20;
            }
        };
    }

    private BaseTableViewerWidget.Column createCreatorColumn() {
        return new BaseTableViewerWidget.Column(){

            @Override
            protected String getLabel() {
                return "Creator";
            }

            protected String getFullText(IDefectLogEntry d) {
                IContributor creator = (IContributor)d.getDefect().getCreator();
                if (creator != null) {
                    return creator.getInitials();
                }
                return "";
            }

            @Override
            protected int getWeight() {
                return 10;
            }
        };
    }

    private BaseTableViewerWidget.Column createIdColumn() {
        return new BaseTableViewerWidget.Column(){

            @Override
            protected String getLabel() {
                return "ID";
            }

            protected String getFullText(IDefectLogEntry d) {
                return "D" + d.getDefect().getId();
            }

            @Override
            protected int getWeight() {
                return 10;
            }
        };
    }

    private BaseTableViewerWidget.Column createStatusColumn() {
        return new BaseTableViewerWidget.Column(){

            @Override
            protected String getLabel() {
                return "";
            }

            protected String getFullText(IDefectLogEntry d) {
                return "";
            }

            @Override
            protected int getWeight() {
                return 5;
            }

            protected Image getImage(IDefectLogEntry d) {
                return DefectWidget.getImage(d.getDefect().getState());
            }
        };
    }

    private class DefectMultiListener
    implements IDefectLogEntryListener,
    IDefectListener,
    ICustomFieldListener {
        private final IDefectLogEntry defectLogEntry;

        public DefectMultiListener(IDefectLogEntry defectLogEntry) {
            this.defectLogEntry = defectLogEntry;
        }

        private void defectLogEntryChanged() {
            ReviewSummaryDefectLogWidget.this.tableViewer.update(this.defectLogEntry, null);
        }

        public void locatorChanged(IDefectLogEntry defectLogEntry, ILocator locator) {
            this.defectLogEntryChanged();
        }

        public void fileVersionIdChanged(IDefectLogEntry defectLogEntry, Integer fileVersionId) {
            this.defectLogEntryChanged();
        }

        public void textChanged(IDefect defect, String newText) {
            this.defectLogEntryChanged();
        }

        public void stateChanged(IDefect defect, DefectState newState) {
            this.defectLogEntryChanged();
        }

        public void assigneeChanged(IDefect defect, DMUser assignee) {
            this.defectLogEntryChanged();
        }

        public void externalNameChanged(IDefect defect, String externalName) {
            this.defectLogEntryChanged();
        }

        public void whyNotAllowedToFixChanged(IDefect iDefect, String s) {
        }

        public void whyNotAllowedToRejectChanged(IDefect iDefect, String s) {
        }

        public void whyNotAllowedToDeleteChanged(IDefect defect, String whyNotAllowedToDelete) {
        }

        public void whyNotAllowedToModifyChanged(IDefect defect, String whyNotAllowedToModify) {
        }

        public void customFieldChanged(ICustomFieldTarget target, ICustomField customField, HashSet<String> newValue) {
            this.defectLogEntryChanged();
        }
    }
}

