/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.smartbear.ccollab.datamodel.client.IRemoteSystem;
import com.smartbear.ccollab.datamodel.client.IRemoteSystemItem;
import com.smartbear.ccollab.datamodel.client.IReviewGeneralInfo;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewTemplate;
import com.smartbear.ccollab.datamodel.client.impl.DMRemoteSystem;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummary;
import com.smartbear.ccollab.datamodel.client.listener.IRemoteSystemItemListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewGeneralInfoListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.RemoteSystemItemAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewGeneralInfoAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.BaseTableViewerWidget;
import com.smartbear.collaborator.ui.util.HTMLParser;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.jface.CollectionContentProvider;
import com.smartbear.jface.ComboViewer2;
import com.smartbear.jface.IStructuredContentProvider2;
import com.smartbear.jface.LabelProvider2;
import com.smartbear.jface.LabelProviderChangedEvent2;
import com.smartbear.jface.StructuredContentProvider2;
import com.smartbear.jface.StyledCellLabelProvider2;
import com.smartbear.jface.TableViewer2;
import com.smartbear.jface.TableViewerColumn2;
import com.smartbear.jface.ViewerComparator2;
import com.smartbear.swt.RightSizeText;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.TableWrapData2;
import com.smartbear.util.Strings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.services.IServiceLocator;

public class ReviewSummaryRemoteSystemLinkWidget
extends Composite {
    private static final String HYPERLINK = "HyperLink";
    private static final String EDITOR = "Editor";
    private static final String REFRESH = "Refresh";
    private static final String REMOVE = "Remove";
    private static final String LABEL = "Label";
    private static final String BUTTON = "Button";
    private static final String LINK_ITEMS = "Linked Item";
    private static final String STATUS = "Status";
    private static final String REMOTE_SYSTEM = "Remote System";
    private static final String ACTION = "Action";
    private static final String ITEM = "Item";
    private static final String TITLE = "Title";
    private static final String URL = "Url";
    private static final String ID = "Id";
    private final IReviewSummaryListener listener = new ReviewSummaryAdapter(){

        public void remoteSystemItemsAdded(IReviewSummary reviewSummary, ArrayList<? extends IRemoteSystemItem> remoteSystemItems) {
            this.remoteSystemItemChanged(reviewSummary.getId());
        }

        public void remoteSystemItemsDeleted(IReviewSummary reviewSummary, ArrayList<? extends IRemoteSystemItem> remoteSystemItems) {
            this.remoteSystemItemChanged(reviewSummary.getId());
        }

        private void remoteSystemItemChanged(Integer reviewId) {
            ReviewSummaryRemoteSystemLinkWidget.this.clearTable();
            ReviewSummaryRemoteSystemLinkWidget.this.resetTable(reviewId);
        }
    };
    private final IReviewGeneralInfoListener reviewGeneralInfoListener = new ReviewGeneralInfoAdapter(){

        public void reviewTemplateChanged(IReviewGeneralInfo generalInfo, IReviewTemplate reviewTemplate) {
            ReviewSummaryRemoteSystemLinkWidget.this.setSectionVisible(reviewTemplate.isRemoteSystemLinksEnabled());
        }
    };
    final RemoteSystemTable remoteSystemTable;
    final TableViewer2<IReviewSummary, IRemoteSystemItem> tableViewer;
    private RightSizeText referenceText;
    final ComboViewer2 remoteSystemItemViewer;
    ISaveableListener saveableListener;

    public ReviewSummaryRemoteSystemLinkWidget(Composite section, int style, ISaveableListener saveableListener, final IReviewSummary reviewSummary, IWorkbenchSite site) {
        super(section, style);
        this.setSectionVisible(reviewSummary.getGeneralInfo().getReviewTemplate().isRemoteSystemLinksEnabled());
        reviewSummary.getGeneralInfo().addReviewGeneralInfoListener(this.reviewGeneralInfoListener);
        this.saveableListener = saveableListener;
        reviewSummary.addReviewSummaryListener(this.listener);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Composite left = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        left.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite right = new Composite(composite, SwtUtils.BASE_COMPOSITE_STYLE);
        right.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        left.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Label referenceLabel = new Label(left, 0);
        referenceLabel.setText("Reference:");
        this.referenceText = new RightSizeText(left, 2052);
        this.referenceText.setLayoutData(GridDataFactory.fillDefaults().span(1, 1).grab(true, true).hint(5 * this.referenceText.getBorderWidth(), -1).create());
        Label remoteSystemLabel = new Label(left, 0);
        remoteSystemLabel.setText("Remote Sytem:");
        Combo combo = new Combo(left, 8);
        combo.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.remoteSystemItemViewer = ComboViewer2.create(combo);
        this.remoteSystemItemViewer.setComparator(new ViewerComparator2());
        this.fillRemoteSystemItemViewer();
        right.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Button addRemoteSystem = new Button(right, 8);
        addRemoteSystem.setText("Add Remote System");
        addRemoteSystem.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        addRemoteSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String reference = ReviewSummaryRemoteSystemLinkWidget.this.referenceText.getText();
                List remoteSystems = ReviewSummaryRemoteSystemLinkWidget.this.remoteSystemItemViewer.getSelection();
                Integer remoteSystemId = null;
                if (remoteSystems != null && remoteSystems.size() > 0) {
                    remoteSystemId = ((DMRemoteSystem)remoteSystems.get(0)).getId();
                }
                try {
                    JsonAPIHandler.addRemoteSystemLink((int)reviewSummary.getId(), remoteSystemId, (String)reference);
                    ReviewSummaryRemoteSystemLinkWidget.this.clearTable();
                    ReviewSummaryRemoteSystemLinkWidget.this.resetTable(reviewSummary.getId());
                }
                catch (CollabClientException e) {
                    ClosureReturn error = new ClosureReturn();
                    error.set((Object)e);
                    String errorMessage = e.getMessage();
                    int beginIndex = "JSON API Error: ".length();
                    int endIndex = errorMessage.length() - "(Code: InternalError )".length();
                    errorMessage = errorMessage.substring(beginIndex, endIndex);
                    MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)errorMessage, (String)"Operation canceled."));
                    return;
                }
            }
        });
        this.remoteSystemTable = new RemoteSystemTable(section, style, reviewSummary, site, this);
        this.tableViewer = this.remoteSystemTable.getTableViewer();
        this.tableViewer.setComparator(new ViewerComparator2<IRemoteSystemItem>(){

            @Override
            public int compare(Viewer viewer, IRemoteSystemItem o1, IRemoteSystemItem o2) {
                String title1 = o1.getTitle();
                String title2 = o2.getTitle();
                return title1.compareTo(title2);
            }
        });
        this.tableViewer.setContentProvider(new RemoteSystemContentProvider());
        this.tableViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReviewSummaryRemoteSystemLinkWidget.this.disposeControls();
            }
        });
    }

    private void setSectionVisible(boolean isVisible) {
        Composite section = this.getParent();
        ((TableWrapData2)section.getLayoutData()).exclude = !isVisible;
        section.setVisible(isVisible);
    }

    private void fillRemoteSystemItemViewer() {
        try {
            this.remoteSystemItemViewer.setContentProvider(CollectionContentProvider.getInstance());
            this.remoteSystemItemViewer.setLabelProvider(new LabelProvider2<IRemoteSystem>(){

                @Override
                public String getText(IRemoteSystem remoteSystem) {
                    return remoteSystem.getTitle();
                }
            });
            List dmRemoteSystems = JsonAPIHandler.getRemoteSystems();
            this.remoteSystemItemViewer.setInput(dmRemoteSystems);
            this.remoteSystemItemViewer.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ReviewSummaryRemoteSystemLinkWidget.this.saveableListener.dirtyStateMayHaveChanged();
                }
            });
        }
        catch (CollabClientException e) {
            CollaboratorUI.openError(this.getShell(), "Error connecting to server to load RemoteSystems", e, false, false);
        }
        catch (ParseException parserError) {
            ClosureReturn error = new ClosureReturn();
            error.set((Object)parserError);
            MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)parserError.getMessage(), (String)"Operation canceled."));
        }
    }

    private void handleActionButton(TableItem item, ViewerCell cell, final int reviewId, final String title, final Integer remoteSystemId, final String action) {
        Composite buttonPane = new Composite((Composite)item.getParent(), 0);
        buttonPane.setLayout((Layout)new FillLayout());
        Button buttonAction = (Button)item.getData(action + BUTTON);
        if (buttonAction == null || buttonAction.isDisposed()) {
            buttonAction = new Button(buttonPane, 8);
            if (REFRESH.equalsIgnoreCase(action)) {
                buttonAction.setImage(CollaboratorUI.getImage("IMG_REFRESH_ENABLED"));
            } else {
                buttonAction.setImage(CollaboratorUI.getImage("IMG_DELETED_OVERLAY"));
            }
            buttonAction.setAlignment(0x1000000);
            buttonAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ReviewSummaryRemoteSystemLinkWidget.REMOVE.equalsIgnoreCase(action) && !MessageDialog.openQuestion((Shell)CollaboratorUI.getShell(), (String)"Confirm Remove Remote System Lnk", (String)("Are you sure you want to remove this remote system link: " + title + "?"))) {
                        return;
                    }
                    try {
                        JsonAPIHandler.modifyRemoteSystems((int)reviewId, (Integer)remoteSystemId, (String)action);
                    }
                    catch (CollabClientException e) {
                        ClosureReturn error = new ClosureReturn();
                        error.set((Object)e);
                        String errorMessage = e.getMessage();
                        int beginIndex = "JSON API Error: ".length();
                        int endIndex = errorMessage.length() - "(Code: InternalError )".length();
                        errorMessage = errorMessage.substring(beginIndex, endIndex);
                        MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)errorMessage, (String)"Operation canceled."));
                        return;
                    }
                    if (ReviewSummaryRemoteSystemLinkWidget.REMOVE.equalsIgnoreCase(action)) {
                        ReviewSummaryRemoteSystemLinkWidget.this.clearTable();
                    }
                    ReviewSummaryRemoteSystemLinkWidget.this.resetTable(reviewId);
                }
            });
            Label label1 = new Label(buttonPane, 0);
            label1.setText("               ");
            TableEditor editor = new TableEditor(item.getParent());
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)buttonPane, item, cell.getColumnIndex());
            editor.layout();
            item.setData(action + EDITOR, (Object)editor);
            item.setData(action + LABEL, (Object)label1);
            item.setData(action + BUTTON, (Object)buttonAction);
        }
    }

    private void disposeControls() {
        if (this.tableViewer.getTable() != null && this.tableViewer.getTable().getChildren() != null) {
            for (Control item : this.tableViewer.getTable().getChildren()) {
                if (item == null || item.isDisposed()) continue;
                item.dispose();
            }
        }
    }

    private void clearTable() {
        this.disposeControls();
        this.tableViewer.getTable().clearAll();
        this.tableViewer.getTable().removeAll();
    }

    private void resetTable(Integer reviewId) {
        try {
            DMReviewSummary input = JsonAPIHandler.getReviewSummary((int)reviewId);
            this.tableViewer.setInput((IReviewSummary)input);
            this.tableViewer.refresh();
        }
        catch (CollabClientException e) {
            ClosureReturn error = new ClosureReturn();
            error.set((Object)e);
            MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)e.getMessage(), (String)"Operation canceled."));
            return;
        }
        catch (ParseException parserError) {
            ClosureReturn error = new ClosureReturn();
            error.set((Object)parserError);
            MessageDialog.openWarning((Shell)CollaboratorUI.getShell(), (String)"Operation canceled", (String)Strings.defaultIfBlank((String)parserError.getMessage(), (String)"Operation canceled."));
            return;
        }
    }

    private class RemoteSystemTable
    extends BaseTableViewerWidget<IReviewSummary, IRemoteSystemItem> {
        RemoteSystemTable(Composite section, int style, IReviewSummary reviewSummary, IWorkbenchSite site, Composite left) {
            super(section, style, reviewSummary, site, left);
        }

        @Override
        protected IStructuredContentProvider2<IReviewSummary, IRemoteSystemItem> createContentProvider() {
            return new StructuredContentProvider2<IReviewSummary, IRemoteSystemItem>(){

                @Override
                public List<? extends IRemoteSystemItem> getElements(IReviewSummary inputElement) {
                    return inputElement.getRemoteSystemItems();
                }
            };
        }

        @Override
        protected Table initTable() {
            Table table = this.tableViewer.getControl();
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            GridData gridData = new GridData(1808);
            gridData.heightHint = 70;
            table.setLayoutData((Object)gridData);
            return table;
        }

        @Override
        protected Iterable<? extends BaseTableViewerWidget.Column> createColumns() {
            int i = 0;
            this.columnByIndex.put(i++, this.createSystemColumn());
            this.columnByIndex.put(i++, this.createTitleColumn());
            this.columnByIndex.put(i++, this.createStatusColumn());
            this.columnByIndex.put(i++, this.createActionColumn());
            this.columnByIndex.put(i++, this.createRemoveColumn());
            return this.columnByIndex.values();
        }

        public TableViewer2<IReviewSummary, IRemoteSystemItem> getTableViewer() {
            return this.tableViewer;
        }

        private BaseTableViewerWidget.Column createSystemColumn() {
            return new BaseTableViewerWidget.Column(){

                @Override
                protected String getLabel() {
                    return ReviewSummaryRemoteSystemLinkWidget.REMOTE_SYSTEM;
                }

                protected String getFullText(IRemoteSystemItem workItem) {
                    if (workItem == null || workItem.getRemoteSystem() == null) {
                        return "";
                    }
                    return workItem.getRemoteSystem().getTitle();
                }

                @Override
                protected int getWeight() {
                    return 20;
                }
            };
        }

        private BaseTableViewerWidget.Column createTitleColumn() {
            return new BaseTableViewerWidget.Column(){

                @Override
                protected String getLabel() {
                    return ReviewSummaryRemoteSystemLinkWidget.LINK_ITEMS;
                }

                protected String getFullText(IRemoteSystemItem workItem) {
                    if (workItem.getUrl() != null) {
                        return workItem.getUrl();
                    }
                    return workItem.getTitle();
                }

                @Override
                protected int getWeight() {
                    return 45;
                }
            };
        }

        private BaseTableViewerWidget.Column createStatusColumn() {
            return new BaseTableViewerWidget.Column(){

                @Override
                protected String getLabel() {
                    return ReviewSummaryRemoteSystemLinkWidget.STATUS;
                }

                protected String getFullText(IRemoteSystemItem workItem) {
                    return workItem.getStatus() != null ? workItem.getStatus().toUpperCase() : null;
                }

                @Override
                protected int getWeight() {
                    return 15;
                }
            };
        }

        private BaseTableViewerWidget.Column createActionColumn() {
            return new BaseTableViewerWidget.Column(){

                @Override
                protected String getLabel() {
                    return ReviewSummaryRemoteSystemLinkWidget.ACTION;
                }

                protected String getFullText(IRemoteSystemItem d) {
                    return "";
                }

                @Override
                protected int getWeight() {
                    return 10;
                }
            };
        }

        private BaseTableViewerWidget.Column createRemoveColumn() {
            return new BaseTableViewerWidget.Column(){

                @Override
                protected String getLabel() {
                    return ReviewSummaryRemoteSystemLinkWidget.REMOVE;
                }

                protected String getFullText(IRemoteSystemItem d) {
                    return "";
                }

                @Override
                protected int getWeight() {
                    return 10;
                }
            };
        }

        @Override
        protected void initColumns() {
            Table table = this.tableViewer.getControl();
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer.getInner());
            final HashMap<TableColumn, BaseTableViewerWidget.Column> columns = new HashMap<TableColumn, BaseTableViewerWidget.Column>();
            for (BaseTableViewerWidget.Column column : this.createColumns()) {
                TableColumn col = new TableColumn(table, 0);
                col.setText(column.getLabel());
                col.setMoveable(true);
                col.setResizable(true);
                TableViewerColumn2<IRemoteSystemItem> viewerColumn = new TableViewerColumn2<IRemoteSystemItem>(this.tableViewer, col);
                viewerColumn.setLabelProvider(new RemoteSystemColumnLabelProvider(this.site, column));
                columns.put(col, column);
            }
            table.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Table table = (Table)event.widget;
                    int columnCount = table.getColumnCount();
                    if (columnCount == 0) {
                        return;
                    }
                    Rectangle area = table.getClientArea();
                    int totalAreaWdith = area.width;
                    for (TableColumn column : table.getColumns()) {
                        BaseTableViewerWidget.Column c = (BaseTableViewerWidget.Column)columns.get(column);
                        column.setWidth(totalAreaWdith * c.getWeight() / 100);
                    }
                }
            });
        }
    }

    private final class RemoteSystemColumnLabelProvider
    extends StyledCellLabelProvider2<IRemoteSystemItem> {
        private final IRemoteSystemItemListener listener = new RemoteSystemItemAdapter(){

            public void remoteSystemItemStatusChanged(IRemoteSystemItem item, String newStatus) {
                RemoteSystemColumnLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent2<IRemoteSystemItem>(RemoteSystemColumnLabelProvider.this, item));
                ReviewSummaryRemoteSystemLinkWidget.this.tableViewer.update(item, null);
                ReviewSummaryRemoteSystemLinkWidget.this.tableViewer.refresh();
            }
        };
        private BaseTableViewerWidget.Column column;
        private IWorkbenchSite site;

        private RemoteSystemColumnLabelProvider(IWorkbenchSite site, BaseTableViewerWidget.Column column) {
            this.column = column;
            this.site = site;
        }

        @Override
        public void update(ViewerCell cell, IRemoteSystemItem iRemoteSystemItemInput) {
            Integer itemId;
            String itemSystem;
            String itemStatus;
            String itemTitle;
            TableItem item = (TableItem)cell.getItem();
            final IWorkbenchSite siteWork = this.site;
            String itemUrl = (String)item.getData(ReviewSummaryRemoteSystemLinkWidget.URL);
            if (itemUrl == null) {
                itemUrl = iRemoteSystemItemInput.getUrl() != null ? iRemoteSystemItemInput.getUrl() : iRemoteSystemItemInput.getTitle();
                item.setData(ReviewSummaryRemoteSystemLinkWidget.URL, (Object)itemUrl);
            }
            if ((itemTitle = (String)item.getData(ReviewSummaryRemoteSystemLinkWidget.TITLE)) == null) {
                itemTitle = iRemoteSystemItemInput.getTitle();
                item.setData(ReviewSummaryRemoteSystemLinkWidget.TITLE, (Object)itemTitle);
            }
            if ((itemStatus = (String)item.getData(ReviewSummaryRemoteSystemLinkWidget.STATUS)) == null) {
                itemStatus = iRemoteSystemItemInput.getStatus() != null ? iRemoteSystemItemInput.getStatus().toUpperCase() : null;
                item.setData(ReviewSummaryRemoteSystemLinkWidget.STATUS, (Object)itemStatus);
            }
            if ((itemSystem = (String)item.getData(ReviewSummaryRemoteSystemLinkWidget.REMOTE_SYSTEM)) == null) {
                if (iRemoteSystemItemInput == null || iRemoteSystemItemInput.getRemoteSystem() == null) {
                    itemSystem = "";
                }
                itemSystem = iRemoteSystemItemInput.getRemoteSystem().getTitle();
                item.setData(ReviewSummaryRemoteSystemLinkWidget.REMOTE_SYSTEM, (Object)itemSystem);
            }
            if ((itemId = (Integer)item.getData("ItemId")) == null) {
                itemId = iRemoteSystemItemInput.getId();
                item.setData("ItemId", (Object)itemId);
            }
            if (ReviewSummaryRemoteSystemLinkWidget.LINK_ITEMS.equalsIgnoreCase(this.column.getLabel())) {
                Hyperlink link = (Hyperlink)item.getData(ReviewSummaryRemoteSystemLinkWidget.HYPERLINK);
                if (link == null || link.isDisposed()) {
                    link = new Hyperlink((Composite)item.getParent(), 0);
                    HTMLParser htmlParser = new HTMLParser();
                    String urlString = itemUrl != null ? itemUrl : itemTitle;
                    ArrayList<HTMLParser.HTMLLinkElement> linkElements = htmlParser.extractHTMLLinks(urlString);
                    if (linkElements.size() > 0) {
                        HTMLParser.HTMLLinkElement linkElem = linkElements.get(0);
                        link.setText(linkElem.getLinkElement());
                        link.setHref((Object)linkElem.getLinkAddress());
                        Object toolTip = "";
                        for (HTMLParser.HTMLLinkElement linkElement : linkElements) {
                            toolTip = (String)toolTip + "          " + linkElement.getLinkAddress();
                        }
                        link.setToolTipText((String)toolTip);
                    } else {
                        link.setText(itemTitle);
                        link.setHref((Object)itemUrl);
                        link.setToolTipText(itemUrl);
                    }
                    link.setUnderlined(true);
                    final String url = link.getHref().toString();
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            try {
                                PlatformUIUtils.executeCommand((IServiceLocator)siteWork, "org.eclipse.ui.browser.openBrowser", Collections.singletonMap("url", url == null ? "" : url), null);
                            }
                            catch (ExecutionException ee) {
                                CollaboratorUI.log("Error launching browser", ee);
                            }
                        }
                    });
                    TableEditor editor = new TableEditor(item.getParent());
                    editor.grabHorizontal = true;
                    editor.grabVertical = true;
                    editor.setEditor((Control)link, item, cell.getColumnIndex());
                    editor.layout();
                    item.setData(ReviewSummaryRemoteSystemLinkWidget.HYPERLINK, (Object)link);
                    item.setData("HyperLinkEditor", (Object)editor);
                }
            } else if (ReviewSummaryRemoteSystemLinkWidget.ACTION.equalsIgnoreCase(this.column.getLabel())) {
                ReviewSummaryRemoteSystemLinkWidget.this.handleActionButton(item, cell, iRemoteSystemItemInput.getReviewSummary().getId(), itemTitle, itemId, ReviewSummaryRemoteSystemLinkWidget.REFRESH);
            } else if (ReviewSummaryRemoteSystemLinkWidget.REMOVE.equalsIgnoreCase(this.column.getLabel())) {
                ReviewSummaryRemoteSystemLinkWidget.this.handleActionButton(item, cell, iRemoteSystemItemInput.getReviewSummary().getId(), itemTitle, itemId, ReviewSummaryRemoteSystemLinkWidget.REMOVE);
            } else if (ReviewSummaryRemoteSystemLinkWidget.REMOTE_SYSTEM.equalsIgnoreCase(this.column.getLabel())) {
                cell.setText(itemSystem);
            } else if (ReviewSummaryRemoteSystemLinkWidget.STATUS.equalsIgnoreCase(this.column.getLabel())) {
                cell.setText(itemStatus);
            }
        }
    }

    private static final class RemoteSystemContentProvider
    extends StructuredContentProvider2<IReviewSummary, IRemoteSystemItem> {
        final IRemoteSystemItemListener remoteSystemItemListener = new RemoteSystemItemAdapter(){

            public void remoteSystemItemStatusChanged(IRemoteSystemItem item, String newStatus) {
                this.getViewer().update(item, null);
                this.getViewer().refresh();
            }
        };

        private RemoteSystemContentProvider() {
        }

        @Override
        public List<? extends IRemoteSystemItem> getElements(IReviewSummary inputElement) {
            return inputElement.getRemoteSystemItems();
        }
    }
}

