/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review;

import com.google.common.collect.ImmutableMap;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.swt.RightSizeText;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.Strings;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

class TrackExternallyDialog
extends TrayDialog {
    private final IClientSystemGlobals clientSystemGlobals;
    private final String createBugUrl;
    private RightSizeText text;
    private String externalName;

    public TrackExternallyDialog(Shell parentShell, String defectText, IClientSystemGlobals clientSystemGlobals) {
        super(parentShell);
        this.clientSystemGlobals = clientSystemGlobals;
        int style = 2144;
        style |= 0x10;
        style |= 0x4000;
        this.setShellStyle(style |= 0);
        this.setHelpAvailable(false);
        String createBugUrlTemplate = clientSystemGlobals.getCreateBugUrlTemplate();
        this.createBugUrl = StringUtils.isNotBlank((String)createBugUrlTemplate) ? StringUtils.replace((String)createBugUrlTemplate, (String)"BUGSUBJECT", (String)Strings.urlEncode((String)defectText)) : null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(CollaboratorUI.getImage("IMG_DEFECT_EXTERNALIZED"));
        newShell.setText("Externalize " + WordUtils.capitalize((String)this.clientSystemGlobals.getDefectLabelSingular()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, SwtUtils.BASE_COMPOSITE_STYLE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        TrackExternallyDialog.applyDialogFont((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("External Name:");
        this.text = new RightSizeText(composite, 2052);
        this.text.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        Link link = new Link(composite, 0);
        link.setText("<a>Create bug in bug tracker</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StringUtils.isNotBlank((String)TrackExternallyDialog.this.createBugUrl)) {
                    try {
                        PlatformUIUtils.executeCommand((IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.ui.browser.openBrowser", (Map<String, Object>)ImmutableMap.of((Object)"url", (Object)TrackExternallyDialog.this.createBugUrl), null);
                    }
                    catch (ExecutionException ex) {
                        CollaboratorUI.openError(TrackExternallyDialog.this.getShell(), "Error opening browser", ex, false, false);
                    }
                } else {
                    ToolTip toolTip = new ToolTip(TrackExternallyDialog.this.getShell(), 2);
                    toolTip.setMessage("No 'Create Bug URL' configured on " + Product.current.getProductName() + " Server");
                    toolTip.setAutoHide(true);
                    toolTip.setVisible(true);
                }
            }
        });
        link.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).align(0x1000000, 1).create());
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (0 == id) {
            label = "Track Externally";
        }
        Button button = super.createButton(parent, id, label, defaultButton);
        if (0 == id) {
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TrackExternallyDialog.this.getButton(0).setEnabled(StringUtils.isNotBlank((String)TrackExternallyDialog.this.text.getText()));
                }
            });
            button.setEnabled(false);
        }
        return button;
    }

    protected void okPressed() {
        this.externalName = this.text.getText();
        super.okPressed();
    }

    public String getExternalName() {
        return this.externalName;
    }
}

