/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IReviewFile;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewFile;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.jobs.FileRefreshJob;
import com.smartbear.collaborator.ui.review.compare.ICompareConfig;
import com.smartbear.collaborator.ui.util.PartAdapter2;
import com.smartbear.collections.Pair;
import com.smartbear.swt.SwtUtils;
import java.text.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public abstract class AbstractCompareConfig
implements ICompareConfig {
    private final int reviewId;
    private final int versionId;

    protected AbstractCompareConfig(int reviewId, int versionId) {
        this.reviewId = reviewId;
        this.versionId = versionId;
    }

    @Override
    public int getReviewId() {
        return this.reviewId;
    }

    protected Pair<IClientSystemGlobals, IReviewFile> loadServerModel(IProgressMonitor monitor) throws CollabClientServerConnectivityException, NoLicenseAvailableException {
        try {
            monitor.beginTask("Loading server model", 100);
            monitor.subTask("Loading system globals");
            IClientSystemGlobals clientSystemGlobals = JsonAPIHandler.getClientSystemGlobals();
            monitor.worked(50);
            monitor.subTask("Loading file Review information");
            DMReviewFile reviewFile = JsonAPIHandler.getReviewFile((int)this.reviewId, (int)this.versionId);
            monitor.worked(50);
            monitor.done();
            return Pair.of((Object)clientSystemGlobals, (Object)reviewFile);
        }
        catch (CollabClientException e) {
            throw new CollabClientServerConnectivityException(CollabClientServerConnectivityException.ConnectionErrorType.getErrorTypeByException((Exception)((Object)e), (CollabClientServerConnectivityException.ConnectionErrorType)CollabClientServerConnectivityException.ConnectionErrorType.JSON_CLIENT_SERVER), e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new CollabClientServerConnectivityException(CollabClientServerConnectivityException.ConnectionErrorType.JSON_CLIENT_SERVER, e.getMessage(), (Throwable)e);
        }
    }

    protected FileRefreshJob createRefreshJob(IReviewFile reviewFile, final IWorkbenchPart part) {
        final FileRefreshJob refreshJob = new FileRefreshJob(reviewFile, SwtUtils.DISPLAY_SYNC_EXECUTOR);
        refreshJob.start();
        part.getSite().getPage().addPartListener((IPartListener2)new PartAdapter2(){

            @Override
            public void partClosed(IWorkbenchPartReference partRef) {
                if (part.equals(partRef.getPart(false))) {
                    refreshJob.stop();
                    partRef.getPage().removePartListener((IPartListener2)this);
                }
            }
        });
        return refreshJob;
    }
}

