/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IVersionLocatable;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.ui.ActivityListener;
import com.smartbear.collaborator.ui.AutomaticLinkStyledTextDecorator;
import com.smartbear.collaborator.ui.review.IConversationContext;
import com.smartbear.collaborator.ui.review.IConversationContextListener;
import com.smartbear.collaborator.ui.review.compare.CompareReference;
import com.smartbear.collaborator.ui.review.compare.ICompareModel;
import com.smartbear.collaborator.ui.review.compare.ICompareViewer;
import com.smartbear.collaborator.ui.review.compare.LinkToFileStyledTextDecorator;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.CompositeStyledTextDecorator;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.ListenerList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class BaseCompareViewer<V extends Viewer>
implements ICompareViewer {
    protected final ListenerList<IConversationContextListener> conversationContextListeners = new ListenerList();
    private final V viewer;
    private final ICompareModel model;
    private final IWorkbenchSite site;

    protected BaseCompareViewer(V viewer, ICompareModel model, IWorkbenchSite site) {
        Preconditions.checkArgument((viewer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((model != null ? 1 : 0) != 0);
        Preconditions.checkArgument((site != null ? 1 : 0) != 0);
        this.viewer = viewer;
        this.model = model;
        this.site = site;
        ActivityListener activityListener = new ActivityListener((ClientModelRefreshJob)model.getRefreshJob());
        viewer.addSelectionChangedListener((ISelectionChangedListener)activityListener);
        activityListener.hook((Widget)viewer.getControl());
        ISelectionService selectionService = (ISelectionService)site.getService(ISelectionService.class);
        if (selectionService != null) {
            selectionService.addSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (BaseCompareViewer.this != SwtUtils.getSelection(selection, IConversationContext.class)) {
                        return;
                    }
                    ILocator locator = SwtUtils.getSelection(selection, ILocator.class);
                    if (locator != null) {
                        BaseCompareViewer.this.selectAndReveal(locator);
                    }
                }
            });
        }
    }

    public V getViewer() {
        return this.viewer;
    }

    protected ICompareModel getModel() {
        return this.model;
    }

    @Override
    public ILocator getCurrentLocator() {
        return null;
    }

    @Override
    public final ILocator getLocator(IVersionLocatable locatable) {
        return this.model.getLocator((IConversation)locatable);
    }

    @Override
    public final void addConversationContextListener(IConversationContextListener listener) {
        this.conversationContextListeners.add((Object)listener);
    }

    @Override
    public final void removeConversationContextListener(IConversationContextListener listener) {
        this.conversationContextListeners.remove((Object)listener);
    }

    protected final void fireLocatorSelected(ILocator locator) {
        this.model.getRefreshJob().registerActivity();
        for (IConversationContextListener listener : this.conversationContextListeners.getListeners()) {
            listener.locatorSelected(locator);
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
    }

    @Override
    public String getWhyNotAllowedToStartNewConversation() {
        return null;
    }

    @Override
    public boolean allowsLabelLocators() {
        return true;
    }

    protected void selectAndReveal(ILocator locator) {
    }

    @Override
    public IStyledTextDecorator getUserTextDecorator() {
        CompositeStyledTextDecorator decorator = new CompositeStyledTextDecorator();
        decorator.add(AutomaticLinkStyledTextDecorator.create(this.model.getReviewFile().getAutomaticLinks(), this.site));
        int reviewId = this.getModel().getReviewFile().getId();
        HashMap nameToFile = Maps.newHashMap();
        for (Map.Entry entry : this.model.getReviewFile().getReviewPathVersionIds().entrySet()) {
            nameToFile.put((String)entry.getKey(), new CompareReference(reviewId, (Integer)entry.getValue()));
        }
        decorator.add(new LinkToFileStyledTextDecorator(nameToFile, this.site));
        return decorator;
    }

    public static BaseCompareViewer<Viewer> create(Viewer viewer, ICompareModel model, IWorkbenchSite site) {
        return new BaseCompareViewer<Viewer>(viewer, model, site);
    }
}

