/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.compare.BaseCompareViewer;
import com.smartbear.collaborator.ui.review.compare.ICompareModel;
import com.smartbear.collaborator.ui.review.compare.ICompareViewer;
import java.lang.reflect.Field;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchSite;

public class ContentMergeCompareViewer<V extends ContentMergeViewer>
extends BaseCompareViewer<V>
implements ICompareViewer {
    protected ContentMergeCompareViewer(V viewer, ICompareModel model, IReusableEditor editor) {
        super(viewer, model, (IWorkbenchSite)editor.getEditorSite());
        CCombo left = ContentMergeCompareViewer.createVersionSelectCombo(viewer, "fLeftLabel");
        CCombo right = ContentMergeCompareViewer.createVersionSelectCombo(viewer, "fRightLabel");
        if (left == null || right == null) {
            CollaboratorUI.log("Could not add version selection controls to diff viewer", null);
        } else {
            this.getModel().configureVersionSelect(left, right, editor, this);
        }
    }

    private static CCombo createVersionSelectCombo(ContentMergeViewer viewer, String labelFieldName) {
        Control label;
        Field labelField;
        try {
            labelField = ContentMergeViewer.class.getDeclaredField(labelFieldName);
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error finding " + labelFieldName + " in ContentMergeViewer", e);
            return null;
        }
        catch (NoSuchFieldException e) {
            CollaboratorUI.log("Error finding " + labelFieldName + " in ContentMergeViewer", e);
            return null;
        }
        labelField.setAccessible(true);
        try {
            label = (Control)labelField.get(viewer);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            CollaboratorUI.log("Error getting " + labelFieldName + " in ContentMergeViewer", e);
            return null;
        }
        Composite labelParent = label.getParent();
        final CCombo combo = new CCombo(labelParent, 8);
        combo.moveAbove(label);
        label.addControlListener(new ControlListener(){

            private void moveComboOver() {
                Rectangle bounds = label.getBounds();
                combo.setBounds(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }

            public void controlResized(ControlEvent e) {
                this.moveComboOver();
            }

            public void controlMoved(ControlEvent e) {
                this.moveComboOver();
            }
        });
        return combo;
    }

    public static ContentMergeCompareViewer<ContentMergeViewer> create(ContentMergeViewer viewer, ICompareModel model, IReusableEditor editor) {
        return new ContentMergeCompareViewer<ContentMergeViewer>(viewer, model, editor);
    }

    public static interface ISideVisitor<T> {
        public T visitLeft();

        public T visitRight();
    }

    public static enum Side {
        LEFT{

            @Override
            public <T> T accept(ISideVisitor<T> visitor) {
                return visitor.visitLeft();
            }
        }
        ,
        RIGHT{

            @Override
            public <T> T accept(ISideVisitor<T> visitor) {
                return visitor.visitRight();
            }
        };


        public abstract <T> T accept(ISideVisitor<T> var1);
    }
}

