/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.google.common.base.Function;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.IDefect;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.UserThreadState;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.Constants;
import com.smartbear.util.Strings;
import java.util.Collection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class ConversationAnnotation
extends Annotation
implements IAnnotationPresentation {
    public static final String TYPE = "com.smartbear.collaborator.ui.ConversationAnnotation";
    private final ILocator locator;
    private final IConversation conversation;

    public ConversationAnnotation(ILocator locator, IConversation conversation) {
        this.locator = locator;
        this.conversation = conversation;
        this.setType(TYPE);
    }

    public String getText() {
        Object text;
        UserThreadState state = this.conversation.getUserThreadState();
        switch (state) {
            case NO_COMMENT: 
            case CHATTING: 
            case ACCEPTED: {
                return null;
            }
            case DEFECT_FIXED: {
                text = "Fixed Defect";
                break;
            }
            case DEFECT_OPEN: {
                text = "Open Defect";
                break;
            }
            case DEFECT_EXTERNALIZED: {
                text = "External Defect";
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized UserThreadState: " + state);
            }
        }
        text = this.conversation.getDefects().size() > 1 ? (String)text + "s " : (String)text + " ";
        text = (String)text + Strings.joinHumanReadable((Collection)this.conversation.getDefects(), (Function)new Function<IDefect, String>(){

            public String apply(IDefect defect) {
                return "D" + defect.getId();
            }
        }, (boolean)false);
        return text;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public int getLayer() {
        return 0;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        UserThreadState state = this.conversation.getUserThreadState();
        state = state == UserThreadState.NO_COMMENT ? UserThreadState.CHATTING : state;
        Image icon = CollaboratorUI.getImage(Constants.getImageKey(state));
        ImageUtilities.drawImage((Image)icon, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000);
    }
}

