/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.google.common.base.Function;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.util.commons.ArrayUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.internal.merge.DocumentMerger;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class ExtensibleDocumentMerger
extends DocumentMerger {
    public ExtensibleDocumentMerger(DocumentMerger.IDocumentMergerInput input) {
        super(input);
    }

    protected RangeDifference[] findRanges(IProgressMonitor pm, DocLineComparator ancestor, DocLineComparator left, DocLineComparator right) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)100);
        String[] ancestorLines = this.getLines(ancestor, (IProgressMonitor)progress.newChild(20));
        String[] leftLines = this.getLines(left, (IProgressMonitor)progress.newChild(20));
        String[] rightLines = this.getLines(right, (IProgressMonitor)progress.newChild(20));
        return this.findRanges((IProgressMonitor)progress.newChild(40), ancestorLines, leftLines, rightLines);
    }

    protected abstract RangeDifference[] findRanges(IProgressMonitor var1, String[] var2, String[] var3, String[] var4);

    private String[] getLines(final DocLineComparator lineComparator, IProgressMonitor monitor) {
        Object lineReader;
        if (lineComparator == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int numLines = lineComparator.getRangeCount();
        monitor.beginTask("Reading lines", numLines);
        try {
            final Method extractMethod = DocLineComparator.class.getDeclaredMethod("extract", Integer.TYPE);
            extractMethod.setAccessible(true);
            lineReader = new Function<Integer, String>(){

                public String apply(Integer lineNo) {
                    try {
                        return (String)extractMethod.invoke((Object)lineComparator, lineNo);
                    }
                    catch (InvocationTargetException e) {
                        CollaboratorUI.log("Error generating diff", e);
                        throw new RuntimeException("Error generating diff", e);
                    }
                    catch (IllegalAccessException e) {
                        CollaboratorUI.log("Error generating diff", e);
                        throw new RuntimeException("Error generating diff", e);
                    }
                }
            };
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new RuntimeException("Error generating diff", e);
        }
        catch (NoSuchMethodException e1) {
            try {
                final Method extractMethod = DocLineComparator.class.getDeclaredMethod("extract", Integer.TYPE, Boolean.TYPE);
                extractMethod.setAccessible(true);
                lineReader = new Function<Integer, String>(){

                    public String apply(Integer lineNo) {
                        try {
                            return (String)extractMethod.invoke((Object)lineComparator, lineNo, false);
                        }
                        catch (InvocationTargetException e) {
                            CollaboratorUI.log("Error generating diff", e);
                            throw new RuntimeException("Error generating diff", e);
                        }
                        catch (IllegalAccessException e) {
                            CollaboratorUI.log("Error generating diff", e);
                            throw new RuntimeException("Error generating diff", e);
                        }
                    }
                };
            }
            catch (SecurityException e2) {
                CollaboratorUI.log("Error generating diff", e2);
                throw new RuntimeException("Error generating diff", e2);
            }
            catch (NoSuchMethodException e2) {
                CollaboratorUI.log("Error generating diff - couldn't find method DocLineComparator.extract(int)", e1);
                CollaboratorUI.log("Error generating diff - couldn't find method DocLineComparator.extract(int, boolean)", e2);
                throw new RuntimeException("Error generating diff", e2);
            }
        }
        String[] lines = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            lines[i] = (String)lineReader.apply((Object)i);
            monitor.worked(1);
        }
        monitor.done();
        return lines;
    }

    public void doDiff() throws CoreException {
        try {
            this.setChangeDiffs(new ArrayList());
            IDocument lDoc = this.getDocument('L');
            IDocument rDoc = this.getDocument('R');
            if (lDoc == null || rDoc == null) {
                return;
            }
            Position lRegion = this.getRegion('L');
            Position rRegion = this.getRegion('R');
            IDocument aDoc = null;
            Position aRegion = null;
            if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                aDoc = this.getDocument('A');
                aRegion = this.getRegion('A');
            }
            this.resetPositions(lDoc);
            this.resetPositions(rDoc);
            this.resetPositions(aDoc);
            boolean ignoreWhiteSpace = this.isIgnoreWhitespace();
            DocLineComparator sright = new DocLineComparator(rDoc, ExtensibleDocumentMerger.toRegion(rRegion), ignoreWhiteSpace);
            DocLineComparator sleft = new DocLineComparator(lDoc, ExtensibleDocumentMerger.toRegion(lRegion), ignoreWhiteSpace);
            DocLineComparator sancestor = null;
            if (aDoc != null) {
                sancestor = new DocLineComparator(aDoc, ExtensibleDocumentMerger.toRegion(aRegion), ignoreWhiteSpace);
            }
            final Object[] result = new Object[1];
            final DocLineComparator sa = sancestor;
            final DocLineComparator sl = sleft;
            final DocLineComparator sr = sright;
            final int maxWork = ExtensibleDocumentMerger.maxWork((IRangeComparator)sa, (IRangeComparator)sl, (IRangeComparator)sr);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    monitor.beginTask(CompareMessages.DocumentMerger_0, maxWork);
                    try {
                        result[0] = ExtensibleDocumentMerger.this.findRanges(monitor, sa, sl, sr);
                    }
                    catch (OutOfMemoryError ex) {
                        System.gc();
                        throw new InvocationTargetException(ex);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    monitor.done();
                }
            };
            RangeDifference[] e = null;
            try {
                this.getCompareConfiguration().getContainer().run(true, true, runnable);
                e = (RangeDifference[])result[0];
            }
            catch (InvocationTargetException ex) {
                DocumentMerger.Diff diff = this.newDiff(null, 0, aDoc, aRegion, 0, aDoc != null ? aDoc.getLength() : 0, lDoc, lRegion, 0, lDoc.getLength(), rDoc, rRegion, 0, rDoc.getLength());
                ArrayList<DocumentMerger.Diff> allDiffs = new ArrayList<DocumentMerger.Diff>();
                allDiffs.add(diff);
                this.setAllDiffs(allDiffs);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 0, CompareMessages.DocumentMerger_1, ex.getTargetException()));
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            ArrayList<DocumentMerger.Diff> newAllDiffs = new ArrayList<DocumentMerger.Diff>();
            for (int i = 0; i < e.length; ++i) {
                RangeDifference es = e[i];
                int ancestorStart = 0;
                int ancestorEnd = 0;
                if (sancestor != null) {
                    ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                    ancestorEnd = ExtensibleDocumentMerger.getTokenEnd2((ITokenComparator)sancestor, es.ancestorStart(), es.ancestorLength());
                }
                int leftStart = sleft.getTokenStart(es.leftStart());
                int leftEnd = ExtensibleDocumentMerger.getTokenEnd2((ITokenComparator)sleft, es.leftStart(), es.leftLength());
                int rightStart = sright.getTokenStart(es.rightStart());
                int rightEnd = ExtensibleDocumentMerger.getTokenEnd2((ITokenComparator)sright, es.rightStart(), es.rightLength());
                DocumentMerger.Diff diff = this.newDiff(null, es.kind(), aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart, leftEnd, rDoc, rRegion, rightStart, rightEnd);
                newAllDiffs.add(diff);
                if (this.isPatchHunk()) {
                    if (!this.useChange(diff)) continue;
                    this.recordChangeDiff(diff);
                    continue;
                }
                if (!ignoreWhiteSpace && !this.useChange(es.kind())) continue;
                String a = null;
                if (sancestor != null) {
                    a = this.extract2(aDoc, (ITokenComparator)sancestor, es.ancestorStart(), es.ancestorLength());
                }
                String s = this.extract2(lDoc, (ITokenComparator)sleft, es.leftStart(), es.leftLength());
                String d = this.extract2(rDoc, (ITokenComparator)sright, es.rightStart(), es.rightLength());
                if (ignoreWhiteSpace && (a == null || a.trim().length() == 0) && s.trim().length() == 0 && d.trim().length() == 0) {
                    ExtensibleDocumentMerger.setDiffIsWhitespace(diff, true);
                }
                if (!this.useChange(diff)) continue;
                this.recordChangeDiff(diff);
                if (s.length() <= 0 || d.length() <= 0) continue;
                if (a == null && sancestor != null) {
                    a = this.extract2(aDoc, (ITokenComparator)sancestor, es.ancestorStart(), es.ancestorLength());
                }
                this.simpleTokenDiff(diff, aDoc, a, rDoc, d, lDoc, s);
            }
            this.setAllDiffs(newAllDiffs);
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (NoSuchFieldException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (InstantiationException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
    }

    private void setChangeDiffs(ArrayList changeDiffs) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field fChangeDiffsField = DocumentMerger.class.getDeclaredField("fChangeDiffs");
        fChangeDiffsField.setAccessible(true);
        fChangeDiffsField.set((Object)this, changeDiffs);
    }

    private IDocument getDocument(char contributor) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method getDocumentMethod = DocumentMerger.class.getDeclaredMethod("getDocument", Character.TYPE);
        getDocumentMethod.setAccessible(true);
        return (IDocument)getDocumentMethod.invoke((Object)this, Character.valueOf(contributor));
    }

    private Position getRegion(char contributor) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method getRegionMethod = DocumentMerger.class.getDeclaredMethod("getRegion", Character.TYPE);
        getRegionMethod.setAccessible(true);
        return (Position)getRegionMethod.invoke((Object)this, Character.valueOf(contributor));
    }

    private void resetPositions(IDocument document) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method resetPositionsMethod = DocumentMerger.class.getDeclaredMethod("resetPositions", IDocument.class);
        resetPositionsMethod.setAccessible(true);
        resetPositionsMethod.invoke((Object)this, document);
    }

    private boolean isIgnoreWhitespace() throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method isIgnoreWhitespaceMethod = DocumentMerger.class.getDeclaredMethod("isIgnoreWhitespace", new Class[0]);
        isIgnoreWhitespaceMethod.setAccessible(true);
        return (Boolean)isIgnoreWhitespaceMethod.invoke((Object)this, new Object[0]);
    }

    private static IRegion toRegion(Position position) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method toRegionMethod = DocumentMerger.class.getDeclaredMethod("toRegion", Position.class);
        toRegionMethod.setAccessible(true);
        return (IRegion)toRegionMethod.invoke(null, position);
    }

    private static int maxWork(IRangeComparator a, IRangeComparator l, IRangeComparator r) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method maxWorkMethod = DocumentMerger.class.getDeclaredMethod("maxWork", IRangeComparator.class, IRangeComparator.class, IRangeComparator.class);
        maxWorkMethod.setAccessible(true);
        return (Integer)maxWorkMethod.invoke(null, a, l, r);
    }

    private DocumentMerger.Diff newDiff(DocumentMerger.Diff parent, int dir, IDocument ancestorDoc, Position aRange, int ancestorStart, int ancestorEnd, IDocument leftDoc, Position lRange, int leftStart, int leftEnd, IDocument rightDoc, Position rRange, int rightStart, int rightEnd) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        Constructor diffConstructor = DocumentMerger.Diff.class.getDeclaredConstructor(DocumentMerger.class, DocumentMerger.Diff.class, Integer.TYPE, IDocument.class, Position.class, Integer.TYPE, Integer.TYPE, IDocument.class, Position.class, Integer.TYPE, Integer.TYPE, IDocument.class, Position.class, Integer.TYPE, Integer.TYPE);
        diffConstructor.setAccessible(true);
        return (DocumentMerger.Diff)diffConstructor.newInstance(new Object[]{this, parent, dir, ancestorDoc, aRange, ancestorStart, ancestorEnd, leftDoc, lRange, leftStart, leftEnd, rightDoc, rRange, rightStart, rightEnd});
    }

    private void setAllDiffs(ArrayList allDiffs) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field fAllDiffsField = DocumentMerger.class.getDeclaredField("fAllDiffs");
        fAllDiffsField.setAccessible(true);
        fAllDiffsField.set((Object)this, allDiffs);
    }

    private static int getTokenEnd2(ITokenComparator tc, int start, int length) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method getTokenEnd2Method = DocumentMerger.class.getDeclaredMethod("getTokenEnd2", ITokenComparator.class, Integer.TYPE, Integer.TYPE);
        getTokenEnd2Method.setAccessible(true);
        return (Integer)getTokenEnd2Method.invoke(null, tc, start, length);
    }

    private boolean isPatchHunk() throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method isPatchHunkMethod = DocumentMerger.class.getDeclaredMethod("isPatchHunk", new Class[0]);
        isPatchHunkMethod.setAccessible(true);
        return (Boolean)isPatchHunkMethod.invoke((Object)this, new Object[0]);
    }

    private void recordChangeDiff(DocumentMerger.Diff diff) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method recordChangeDiffMethod = DocumentMerger.class.getDeclaredMethod("recordChangeDiff", DocumentMerger.Diff.class);
        recordChangeDiffMethod.setAccessible(true);
        recordChangeDiffMethod.invoke((Object)this, diff);
    }

    private boolean useChange(int kind) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method useChangeMethod = DocumentMerger.class.getDeclaredMethod("useChange", Integer.TYPE);
        useChangeMethod.setAccessible(true);
        return (Boolean)useChangeMethod.invoke((Object)this, kind);
    }

    private String extract2(IDocument doc, ITokenComparator tc, int start, int length) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method extract2Method = DocumentMerger.class.getDeclaredMethod("extract2", IDocument.class, ITokenComparator.class, Integer.TYPE, Integer.TYPE);
        extract2Method.setAccessible(true);
        return (String)extract2Method.invoke((Object)this, doc, tc, start, length);
    }

    private static void setDiffIsWhitespace(DocumentMerger.Diff diff, boolean value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field fIsWhitespaceField = DocumentMerger.Diff.class.getDeclaredField("fIsWhitespace");
        fIsWhitespaceField.setAccessible(true);
        fIsWhitespaceField.set(diff, value);
    }

    private void simpleTokenDiff(DocumentMerger.Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Method simpleTokenDiffMethod = DocumentMerger.class.getDeclaredMethod("simpleTokenDiff", DocumentMerger.Diff.class, IDocument.class, String.class, IDocument.class, String.class, IDocument.class, String.class);
        simpleTokenDiffMethod.setAccessible(true);
        simpleTokenDiffMethod.invoke((Object)this, baseDiff, ancestorDoc, a, rightDoc, d, leftDoc, s);
    }

    public DocumentMerger.Diff findDiff(char type, int pos) throws CoreException {
        try {
            IDocument aDoc = null;
            IDocument lDoc = this.getDocument('L');
            IDocument rDoc = this.getDocument('R');
            if (lDoc == null || rDoc == null) {
                return null;
            }
            Position aRegion = null;
            Position lRegion = null;
            Position rRegion = null;
            boolean threeWay = this.isThreeWay();
            if (threeWay && !this.isIgnoreAncestor()) {
                aDoc = this.getDocument('A');
            }
            boolean ignoreWhiteSpace = this.isIgnoreWhitespace();
            DocLineComparator sright = new DocLineComparator(rDoc, ExtensibleDocumentMerger.toRegion(rRegion), ignoreWhiteSpace);
            DocLineComparator sleft = new DocLineComparator(lDoc, ExtensibleDocumentMerger.toRegion(lRegion), ignoreWhiteSpace);
            DocLineComparator sancestor = null;
            if (aDoc != null) {
                sancestor = new DocLineComparator(aDoc, ExtensibleDocumentMerger.toRegion(aRegion), ignoreWhiteSpace);
            }
            final Object[] result = new Object[1];
            final DocLineComparator sa = sancestor;
            final DocLineComparator sl = sleft;
            final DocLineComparator sr = sright;
            final int maxWork = ExtensibleDocumentMerger.maxWork((IRangeComparator)sa, (IRangeComparator)sl, (IRangeComparator)sr);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    monitor.beginTask(CompareMessages.DocumentMerger_2, maxWork);
                    try {
                        result[0] = ExtensibleDocumentMerger.this.findRanges(monitor, sa, sl, sr);
                    }
                    catch (OutOfMemoryError ex) {
                        System.gc();
                        throw new InvocationTargetException(ex);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    monitor.done();
                }
            };
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            RangeDifference[] e = null;
            try {
                progressService.run(true, true, runnable);
                e = (RangeDifference[])result[0];
            }
            catch (InvocationTargetException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 0, CompareMessages.DocumentMerger_3, ex.getTargetException()));
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (e != null) {
                for (int i = 0; i < e.length; ++i) {
                    int rightEnd;
                    int rightStart;
                    int leftEnd;
                    int leftStart;
                    DocumentMerger.Diff diff;
                    RangeDifference es = e[i];
                    int kind = es.kind();
                    int ancestorStart = 0;
                    int ancestorEnd = 0;
                    if (sancestor != null) {
                        ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                        ancestorEnd = ExtensibleDocumentMerger.getTokenEnd2((ITokenComparator)sancestor, es.ancestorStart(), es.ancestorLength());
                    }
                    if (!ExtensibleDocumentMerger.diffIsInRange(diff = this.newDiff(null, kind, aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart = sleft.getTokenStart(es.leftStart()), leftEnd = ExtensibleDocumentMerger.getTokenEnd2((ITokenComparator)sleft, es.leftStart(), es.leftLength()), rDoc, rRegion, rightStart = sright.getTokenStart(es.rightStart()), rightEnd = ExtensibleDocumentMerger.getTokenEnd2((ITokenComparator)sright, es.rightStart(), es.rightLength())), type, pos)) continue;
                    return diff;
                }
            }
            return null;
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
        catch (InstantiationException e) {
            CollaboratorUI.log("Error generating diff", e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", "Error generating diff", (Throwable)e));
        }
    }

    private static boolean diffIsInRange(DocumentMerger.Diff diff, char type, int pos) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method isInRangeMethod = DocumentMerger.Diff.class.getDeclaredMethod("isInRange", Character.TYPE, Integer.TYPE);
        isInRangeMethod.setAccessible(true);
        return (Boolean)isInRangeMethod.invoke((Object)diff, Character.valueOf(type), pos);
    }
}

