/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.google.common.base.Predicate;
import com.smartbear.ccollab.datamodel.client.CoordinateLocator;
import com.smartbear.ccollab.datamodel.client.DefectState;
import com.smartbear.ccollab.datamodel.client.IComment;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.IDefect;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IReviewConversation;
import com.smartbear.ccollab.datamodel.client.IVersionLocatable;
import com.smartbear.ccollab.datamodel.client.LocatorType;
import com.smartbear.ccollab.datamodel.client.listener.ICommentListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.CommentAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationProviderAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.compare.BaseCompareViewer;
import com.smartbear.collaborator.ui.review.compare.ContentMergeCompareViewer;
import com.smartbear.collaborator.ui.review.compare.ICompareModel;
import com.smartbear.collaborator.ui.review.compare.ServerPageCompareVersion;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.ImageMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchSite;

public class ImageMergeCompareViewer<V extends ImageMergeViewer>
extends BaseCompareViewer<V> {
    private static final Field F_LEFT_FIELD;
    private static final Field F_RIGHT_FIELD;
    private static final int MARKER_IMAGE_OFFSET_X = 9;
    private static final int MARKER_IMAGE_OFFSET_Y = 22;
    private static final int MARKER_IMAGE_SIZE = 32;
    private static final ContentMergeCompareViewer.ISideVisitor<Field> FIELD_VISITOR;
    private final Predicate<ILocator> locatorFilter = new Predicate<ILocator>(){

        public boolean apply(ILocator locator) {
            if (locator.getType() != LocatorType.COORDINATE) {
                return false;
            }
            CoordinateLocator coordinateLocator = (CoordinateLocator)locator;
            Integer page = ImageMergeCompareViewer.this.getPage();
            return page == null || page + 1 == coordinateLocator.getPage();
        }
    };
    private final IConversationProviderListener convoProviderListener = new ConversationProviderAdapter(){

        public void conversationsAdded(IConversationProvider conversationProvider, ArrayList<? extends IConversation> newConversations) {
            for (IConversation iConversation : newConversations) {
                iConversation.addConversationListener(ImageMergeCompareViewer.this.convoListener);
                ReviewConversationAdapter.init((IReviewConversation)((IReviewConversation)iConversation), (IReviewConversationListener)((IReviewConversationListener)ImageMergeCompareViewer.this.convoListener));
            }
        }
    };
    private final IConversationListener convoListener = new ReviewConversationAdapter(){

        public void commentsAdded(IConversation conversation, ArrayList<? extends IComment> newComments) {
            for (IComment iComment : newComments) {
                iComment.addCommentListener(ImageMergeCompareViewer.this.commentListener);
            }
            ImageMergeCompareViewer.this.redrawBothSides();
        }
    };
    private final ICommentListener commentListener = new CommentAdapter(){

        public void markedRead(IComment comment) {
            ImageMergeCompareViewer.this.redrawBothSides();
        }
    };
    private CoordinateLocator currentLocator;

    protected ImageMergeCompareViewer(V viewer, final ICompareModel model, IReusableEditor editor) {
        super(viewer, model, (IWorkbenchSite)editor.getSite());
        this.hook(ContentMergeCompareViewer.Side.LEFT);
        this.hook(ContentMergeCompareViewer.Side.RIGHT);
        model.getReviewFile().addConversationProviderListener(this.convoProviderListener);
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                model.getReviewFile().removeConversationProviderListener(ImageMergeCompareViewer.this.convoProviderListener);
                for (IConversation convo : model.getReviewFile().getConversations()) {
                    convo.removeConversationListener(ImageMergeCompareViewer.this.convoListener);
                    for (IComment comment : convo.getComments()) {
                        comment.removeCommentListener(ImageMergeCompareViewer.this.commentListener);
                    }
                }
            }
        });
        ConversationProviderAdapter.init((IConversationProvider)model.getReviewFile(), (IConversationProviderListener)this.convoProviderListener);
    }

    public CoordinateLocator getCurrentLocator() {
        return this.currentLocator;
    }

    private Integer getPage() {
        Object input = ((ImageMergeViewer)this.getViewer()).getInput();
        ICompareInput compareInput = input instanceof ICompareInput ? (ICompareInput)input : null;
        ITypedElement left = compareInput != null ? compareInput.getLeft() : null;
        ServerPageCompareVersion pageCompareVersion = left instanceof ServerPageCompareVersion ? (ServerPageCompareVersion)left : null;
        return pageCompareVersion == null ? null : Integer.valueOf(pageCompareVersion.getPage());
    }

    private void hook(ContentMergeCompareViewer.Side side) {
        final Canvas canvas = this.getCanvas(side);
        if (canvas == null) {
            return;
        }
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageMergeCompareViewer.this.paintLocators(canvas, e.gc);
            }
        });
        SelectionAdapter scrollListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GC gc = new GC((Drawable)canvas);
                try {
                    ImageMergeCompareViewer.this.paintLocators(canvas, gc);
                }
                finally {
                    gc.dispose();
                }
            }
        };
        canvas.getHorizontalBar().addSelectionListener((SelectionListener)scrollListener);
        canvas.getVerticalBar().addSelectionListener((SelectionListener)scrollListener);
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Integer page;
                int x = e.x;
                int y = e.y;
                x += canvas.getHorizontalBar().getSelection();
                y += canvas.getVerticalBar().getSelection();
                Rectangle relativeImageBounds = ImageMergeCompareViewer.this.getRelativeImageBounds(canvas);
                if (relativeImageBounds != null) {
                    x -= relativeImageBounds.x;
                    y -= relativeImageBounds.y;
                    x = ImageMergeCompareViewer.constrain(x, 0, relativeImageBounds.width);
                    y = ImageMergeCompareViewer.constrain(y, 0, relativeImageBounds.height);
                }
                CoordinateLocator selectedLocator = new CoordinateLocator((page = ImageMergeCompareViewer.this.getPage()) == null ? 1 : page + 1, x, y, 0);
                for (IConversation convo : ImageMergeCompareViewer.this.getModel().getReviewFile().getConversations()) {
                    CoordinateLocator existingLocator;
                    Rectangle rect;
                    ILocator locator = ImageMergeCompareViewer.this.getLocator((IVersionLocatable)convo);
                    if (!ImageMergeCompareViewer.this.locatorFilter.apply((Object)locator) || !(rect = new Rectangle((existingLocator = (CoordinateLocator)locator).getX() - 9, existingLocator.getY() - 22, 32, 32)).contains(selectedLocator.getX(), selectedLocator.getY())) continue;
                    selectedLocator = existingLocator;
                    break;
                }
                ImageMergeCompareViewer.this.currentLocator = selectedLocator;
                ImageMergeCompareViewer.this.redrawBothSides();
                ImageMergeCompareViewer.this.fireLocatorSelected((ILocator)ImageMergeCompareViewer.this.currentLocator);
            }
        });
        final Cursor crosshair = new Cursor((Device)canvas.getDisplay(), 2);
        canvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                canvas.setCursor(crosshair);
            }

            public void mouseExit(MouseEvent e) {
                canvas.setCursor(crosshair);
            }
        });
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                crosshair.dispose();
            }
        });
    }

    @Override
    protected void selectAndReveal(ILocator locator) {
        if (!this.locatorFilter.apply((Object)locator)) {
            return;
        }
        this.currentLocator = (CoordinateLocator)locator;
        this.reveal(this.currentLocator, this.getCanvas(ContentMergeCompareViewer.Side.LEFT));
        this.reveal(this.currentLocator, this.getCanvas(ContentMergeCompareViewer.Side.RIGHT));
    }

    private void reveal(CoordinateLocator locator, Canvas canvas) {
        if (canvas == null) {
            return;
        }
        Rectangle clientArea = canvas.getClientArea();
        this.reveal(locator.getX() - clientArea.width / 2, canvas.getHorizontalBar());
        this.reveal(locator.getY() - clientArea.height / 2, canvas.getVerticalBar());
        canvas.redraw();
    }

    private void reveal(int value, ScrollBar scrollBar) {
        value = ImageMergeCompareViewer.constrain(value, scrollBar.getMinimum(), scrollBar.getMaximum());
        scrollBar.setSelection(value);
    }

    private Canvas getCanvas(ContentMergeCompareViewer.Side side) {
        Field field = side.accept(FIELD_VISITOR);
        Canvas canvas = null;
        try {
            canvas = (Canvas)(field == null ? null : field.get(this.getViewer()));
        }
        catch (IllegalArgumentException e) {
            CollaboratorUI.log("Error image canvas", e);
        }
        catch (IllegalAccessException e) {
            CollaboratorUI.log("Error image canvas", e);
        }
        return canvas;
    }

    private Image getImage(Canvas canvas) {
        Field field = null;
        try {
            field = canvas.getClass().getDeclaredField("fImage");
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error accessing image", e);
        }
        catch (NoSuchFieldException e) {
            CollaboratorUI.log("Error accessing image", e);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        Image image = null;
        try {
            image = (Image)(field == null ? null : field.get(canvas));
        }
        catch (IllegalArgumentException e) {
            CollaboratorUI.log("Error accessing image", e);
        }
        catch (IllegalAccessException e) {
            CollaboratorUI.log("Error accessing image", e);
        }
        return image;
    }

    private Rectangle getRelativeImageBounds(Canvas canvas) {
        Image image = this.getImage(canvas);
        if (image == null) {
            return null;
        }
        Rectangle bounds = image.getBounds();
        Rectangle canvasClientArea = canvas.getClientArea();
        int x = canvasClientArea.width > bounds.width ? (canvasClientArea.width - bounds.width) / 2 : 0;
        int y = canvasClientArea.height > bounds.height ? (canvasClientArea.height - bounds.height) / 2 : 0;
        return new Rectangle(x, y, bounds.width, bounds.height);
    }

    private void paintLocators(Canvas canvas, GC gc) {
        for (IConversation convo : this.getModel().getReviewFile().getConversations()) {
            this.paintLocator(canvas, gc, this.getLocator((IVersionLocatable)convo), convo);
        }
        if (this.getCurrentLocator() != null) {
            this.paintLocator(canvas, gc, (ILocator)this.getCurrentLocator(), null);
        }
    }

    private void paintLocator(Canvas canvas, GC gc, ILocator locator, IConversation convo) {
        if (!this.locatorFilter.apply((Object)locator)) {
            return;
        }
        int x = ((CoordinateLocator)locator).getX();
        int y = ((CoordinateLocator)locator).getY();
        x -= 9;
        y -= 22;
        x -= canvas.getHorizontalBar().getSelection();
        y -= canvas.getVerticalBar().getSelection();
        Rectangle relativeImageBounds = this.getRelativeImageBounds(canvas);
        if (relativeImageBounds != null) {
            x += relativeImageBounds.x;
            y += relativeImageBounds.y;
        }
        if (Boolean.FALSE.booleanValue()) {
            PaletteData paletteData = new PaletteData(0, 0, 0);
            ImageData imageData = new ImageData(34, 34, 32, paletteData);
            Image outlineImage = new Image((Device)canvas.getDisplay(), imageData);
            outlineImage.setBackground(canvas.getDisplay().getSystemColor(4));
            ImageUtilities.drawImage((Image)outlineImage, (GC)gc, (Canvas)canvas, (Rectangle)new Rectangle(x - 1, y - 1, 34, 34), (int)16384, (int)0x1000000);
            outlineImage.dispose();
        }
        Image pinImage = CollaboratorUI.getImage(ImageMergeCompareViewer.getImageKey(convo));
        ImageUtilities.drawImage((Image)pinImage, (GC)gc, (Canvas)canvas, (Rectangle)new Rectangle(x, y, 32, 32), (int)16384, (int)0x1000000);
    }

    private void redrawBothSides() {
        Canvas rightCanvas;
        Canvas leftCanvas = this.getCanvas(ContentMergeCompareViewer.Side.LEFT);
        if (leftCanvas != null) {
            leftCanvas.redraw();
        }
        if ((rightCanvas = this.getCanvas(ContentMergeCompareViewer.Side.RIGHT)) != null) {
            rightCanvas.redraw();
        }
    }

    public static <V extends ImageMergeViewer> ImageMergeCompareViewer<V> create(V viewer, ICompareModel model, IReusableEditor editor) {
        return new ImageMergeCompareViewer<V>(viewer, model, editor);
    }

    static String getImageKey(IConversation convo) {
        if (convo == null) {
            return "IMG_CONVO_PIN_SELECTED";
        }
        for (IDefect defect : convo.getDefects()) {
            if (defect.getState() != DefectState.OPEN) continue;
            return "IMG_CONVO_PIN_DEFECT_OPEN";
        }
        if (!convo.getDefects().isEmpty()) {
            return "IMG_CONVO_PIN_DEFECT_RESOLVED";
        }
        if (!convo.isRead()) {
            return "IMG_CONVO_PIN_UNREAD";
        }
        return "IMG_CONVO_PIN_READ";
    }

    private static int constrain(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    static {
        Field field = null;
        try {
            field = ImageMergeViewer.class.getDeclaredField("fLeft");
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error accessing left image canvas", e);
        }
        catch (NoSuchFieldException e) {
            CollaboratorUI.log("Error accessing left image canvas", e);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        F_LEFT_FIELD = field;
        field = null;
        try {
            field = ImageMergeViewer.class.getDeclaredField("fRight");
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error accessing right image canvas", e);
        }
        catch (NoSuchFieldException e) {
            CollaboratorUI.log("Error accessing right image canvas", e);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        F_RIGHT_FIELD = field;
        FIELD_VISITOR = new ContentMergeCompareViewer.ISideVisitor<Field>(){

            @Override
            public Field visitLeft() {
                return F_LEFT_FIELD;
            }

            @Override
            public Field visitRight() {
                return F_RIGHT_FIELD;
            }
        };
    }
}

